_G.minetest = {
	pos_to_string = function(pos)
		return ("%d,%d,%d"):format(pos.x, pos.y, pos.z)
	end,
}

_G.vector = {
	new = function(x, y, z)
		if x and y and z then
			return {x=x, y=y, z=z}
		elseif x.x and x.y and x.z then
			return {x=x.x, y=x.y, z=x.z}
		else
			error("Unknown arguments")
		end
	end,
	add = function(a, b)
		return {
			x = a.x + b.x,
			y = a.y + b.y,
			z = a.z + b.z,
		}
	end,
	subtract = function(a, b)
		return {
			x = a.x - b.x,
			y = a.y - b.y,
			z = a.z - b.z,
		}
	end,
	multiply = function(a, s)
		return {
			x = a.x * s,
			y = a.y * s,
			z = a.z * s,
		}
	end,
	divide = function(a, s)
		return {
			x = a.x / s,
			y = a.y / s,
			z = a.z / s,
		}
	end,
	floor = function(vec)
		return {
			x = math.floor(vec.x),
			y = math.floor(vec.y),
			z = math.floor(vec.z),
		}
	end,
	length = function(delta)
		return math.sqrt(delta.x*delta.x + delta.y*delta.y + delta.z*delta.z)
	end,
	distance = function(one, two)
		return vector.length({
			x = one.x - two.x,
			y = one.y - two.y,
			z = one.z - two.z,
		})
	end,
	normalize = function(vec)
		return vector.divide(vec, vector.length(vec))
	end,
}

_G.table.copy = function(tab)
	local ret = {}
	for key, value in pairs(tab) do
		ret[key] = value
	end
	return ret
end



local MockBehaviour = conquer.class()

function MockBehaviour:constructor()
	self.state = "running"
	self.ran = false
end

function MockBehaviour:get_state()
	return self.state
end

function MockBehaviour:on_step()
	self.ran = true
end


_G.conquer.S = function(str) return str end


return {
	MockBehaviour = MockBehaviour
}
