local dir = minetest.get_modpath("conquer") .. "/src"
dofile(dir .. "/utils.lua")
dofile(dir .. "/Session.lua")
dofile(dir .. "/api.lua")
dofile(dir .. "/behaviour.lua")
dofile(dir .. "/UnitEntity.lua")
dofile(dir .. "/ArrowEntity.lua")
dofile(dir .. "/wands.lua")
dofile(dir .. "/building_api.lua")
dofile(dir .. "/hudinv.lua")
dofile(dir .. "/gui.lua")
dofile(dir .. "/chatcmd.lua")
dofile(dir .. "/content/init.lua")

if default.hud then
	dofile(dir .. "/porting/repixture.lua")
end

local function chat_send_country(_, country, message, color)
	for pname, _ in pairs(country.players) do
		minetest.chat_send_player(pname, minetest.colorize(color or "#EE8822", message))
	end
end

local function chat_send_all(session, message, except_player, color)
	local players = conquer.get_players_in_session(session)
	for i=1, #players do
		if players[i] ~= except_player then
			minetest.chat_send_player(players[i]:get_player_name(),
					minetest.colorize(color or "#EE8822", message))
		end
	end
end

local S = conquer.S

local groups_context_provider = conquer.make_context_provider()

conquer.register_on_join_session(function(player, session)
	local message = S("@1 has joined the session", player:get_player_name())
	chat_send_all(session, message, player)

	local context = groups_context_provider(player)
	context.armor_groups = player:get_armor_groups()
	player:set_armor_groups({ immortal = 1 })
end)

conquer.register_on_leave_session(function(player, session)
	local message = S("@1 has left the session", player:get_player_name())
	chat_send_all(session, message, player)

	conquer.deselect_unit(player)

	local context = groups_context_provider(player)
	if context.armor_groups then
		player:set_armor_groups(context.armor_groups)
	end
end)

conquer.register_on_change_country(function(player, session, country)
	local message = conquer.S("@1 has joined country @2",
			player:get_player_name(), country.description)
	chat_send_all(session, message, player)

	conquer.deselect_unit(player)
end)

conquer.register_on_building_destroyed(function(session, country, building_type, _)
	if building_type == "keep" then
		local message = conquer.S("@1 was defeated", country.description)
		chat_send_all(session, message)

		session:remove_country(country)
	end
end)

conquer.register_on_unit_created(function(session, country, unit)
	local message = conquer.S("Finished training @1", unit:get_luaentity():get_unit_type().description)
	chat_send_country(session, country, message, "#808080")
end)


-- TODO: persist sessions across restarts
minetest.register_on_joinplayer(function(player)
	player:get_meta():set_string("conquer:session", "")

	local inv = player:get_inventory()
	if inv:get_size("mainbackup") > 0 then
		inv:set_size("main", inv:get_size("mainbackup"))
		inv:set_list("main", inv:get_list("mainbackup"))
		inv:set_size("mainbackup", 0)
	end
end)

conquer.set_interval(3, function()
	for _, session in pairs(conquer.get_sessions()) do
		for _, country in pairs(session:get_countries()) do
			if country.keep then
				conquer.heal_building(country.keep)
			end

			if country.barracks then
				conquer.heal_building(country.barracks)
			end
		end
	end
end)
