# API

## Functions

* `conquer.create_session(owner, pos) --> Session`
* `conquer.get_players_in_session(session) --> table of player ObjectRefs`
* `conquer.get_session(player) --> Session`
* `conquer.get_session_country(player) --> Session, Country`
* `conquer.get_session_by_id(pos) --> Session`
* `conquer.get_sessions() --> table of Session`
* `conquer.place_keep(session, country, pos) --> boolean`
* `conquer.get_selected_unit(player) -> ObjectRef or nil`
* `conquer.select_unit(player, object_ref) --> boolean`
* `conquer.deselect_unit(player)`
* `conquer.get_unit_type(name) --> Unit type def`
* `conquer.get_unit_types() --> table of name to Unit type def`
* `conquer.register_unit(name, def)`. def:
  * `get_properties = function(session, country) --> table`
* `conquer.register_wand(name, def)`. def:
  * Can contain anything in an item definition.
  * `on_node = function(player, unit, pos)`
  * `on_enemy_target = function(player, unit, target)`
    * target is either an ObjectRef or a node position.
  * `on_enemy_unit = function(player, unit, enemy_unit)`
  * `on_own_unit = function(player, unit, own_unit)`
  * `on_enemy_building = function(player, unit, pos)`
  * `on_own_building = function(player, unit, pos)`
* `conquer.can_train_unit(session, country, unit_type) --> boolean, message`
* `conquer.train_unit(session, country, unit_type)`
  * Takes the resources and starts to train a unit.
* `conquer.find_enemy_units(pos, session_id, country_id, min_range, max_range) -> table of ObjectRef`
  * Sorted from closest to furthest.
* `conquer.register_command(name, def)`
  * Registers a subcommand of `/conquer`.
  * `def` is exactly the same as a chat command def.
    * Only `func` and `params` are supported currently.
* `conquer.register_building(name, def)`
* `conquer.get_building_session_country(pos) --> session, country`
* `conquer.get_is_building_owner(player, pos)`
  * returns nil if not a building in the player's session,
    false if enemy and true own building.
* `conquer.get_building_hp(pos) --> number`
* `conquer.damage_building(pos, time_since_last_punch, tool_capabilities)`
* `conquer.heal_building(pos) --> boolean`

## Callbacks

* `conquer.register_on_building_placed(function(session, country, building_type))`
  * `building_type` - is one of `keep`, `barracks`.
* `conquer.register_on_building_destroyed(function(session, country, building_type, pos))`
* `conquer.register_on_selected_unit_changed(function(player, session, country, unit))`
  * unit is an object ref, may be nil
* `conquer.register_on_join_session(function(player, session))`
* `conquer.register_on_leave_session(function(player, session))`
* `conquer.register_on_change_country(function(player, session, country))`
* `conquer.register_on_can_train_unit(function(session, country, unit_type))`
  * Function can return an error message to prevent the unit from being trained.
* `conquer.register_on_train_unit(function(session, country, unit_type))`
  * Unit has started to be trained, but hasn't finished yet.
* `conquer.register_on_unit_created(function(session, country, unit))`


## Session class

A session is a running game. Units and countries from different sessions cannot fight or interact.

* `Session:new(owner, pos)`
* `get_countries() --> table of countries`
* `create_country() --> country`
* `get_country_by_id(id) --> country`
* `get_country_by_player(player_name) --> country`
* `join(player) --> country` - Player joins session, new country created.
* `set_player_country(player, country_id) --> boolean`

## Behaviour Trees

Conquer uses a simple [behaviour tree](https://en.wikipedia.org/wiki/Behavior_tree_%28artificial_intelligence%2C_robotics_and_control%29)
implementation to drive the unit actions.
Behaviour trees can be used to compose complex behaviour,
but their use in conquer is simple.

Composite nodes:

* `FickleSequence:new({child1, child2})` - runs each child every tick.
* `Sequence:new({child1, child2})` - runs each child once, remembering the last ran child.

Action nodes:

* `FollowPath:new(path, object_animations)` - follow a path.
* `MoveToNearTarget:new(target, object_animations)` - move to an object.
* `MeleeAttack:new(target, melee_spec, object_animations)` - attack.
* `RangedAttack:new(target, ranged_spec, object_animations)` - attack.

`target` can be an ObjectRef or a node position.

## Utilities

* `conquer.class() --> table` - makes a Lua class.
  * Add `class.constructor(...)` to handle parameters passed to `:new()`
