_G.conquer = {}

dofile("src/utils.lua")
dofile("tests/mocks.lua")
dofile("src/Session.lua")

describe("api", function()
	it("create sessions", function()
		dofile("src/api.lua")

		local pos = vector.new(1,2,3)
		local session = conquer.create_session("player1", pos)
		assert.equals("player1", session.owner)
		assert.same(pos, session.pos)
	end)

	it("place keeps", function()
		dofile("src/api.lua")

		local session = conquer.Session:new("player1", vector.new(1,2,1))
		local country = { colors = { primary = "red" } }
		local pos = vector.new(1,2,3)

		local callback_called = false
		conquer.register_on_building_placed(function(session2, country2, building_type)
			assert.equals(session, session2)
			assert.equals(country, country2)
			assert.equals("keep", building_type)
			assert.same(pos, country.keep)
			callback_called = true
		end)

		assert.is_true(conquer.place_keep(session, country, pos))
		assert.same(pos, country.keep)
		assert.is_true(callback_called)

		callback_called = false
		assert.is_false(conquer.place_keep(session, country, pos))
		assert.is_false(callback_called)
	end)

	it("place barracks", function()
		dofile("src/api.lua")

		local session = conquer.Session:new("player1", vector.new(1,2,1))
		local country = { colors = { primary = "red" } }
		local pos = vector.new(1,2,3)

		local callback_called = false
		conquer.register_on_building_placed(function(session2, country2, building_type)
			assert.equals(session, session2)
			assert.equals(country, country2)
			assert.equals("barracks", building_type)
			assert.same(pos, country.barracks)
			assert.is_not_nil(country.keep)
			callback_called = true
		end)

		assert.is_false(conquer.place_barracks(session, country, pos))
		assert.is_nil(country.keep)
		assert.is_false(callback_called)

		country.keep = vector.new(3, 2, 3)

		assert.is_true(conquer.place_barracks(session, country, pos))
		assert.is_not_nil(country.keep)
		assert.same(pos, country.barracks)
		assert.is_true(callback_called)

		callback_called = false
		assert.is_false(conquer.place_barracks(session, country, pos))
		assert.is_not_nil(country.keep)
		assert.is_false(callback_called)
	end)
end)
