--[[

bushy_leaves – Minetest mod to render leaves bushy
Copyright © 2022 Nils Dagsson Moskopp (erlehmann)
Copyright © 2024 Mikita Wiśniewski (rudzik8)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

Dieses Programm hat das Ziel, die Medienkompetenz der Leser zu
steigern. Gelegentlich packe ich sogar einen handfesten Buffer
Overflow oder eine Format String Vulnerability zwischen die anderen
Codezeilen und schreibe das auch nicht dran.

]]--

local mesh_type = minetest.settings:get("bushy_leaves_mesh") or "full"

local get_mesh = function(node_name, node_def)
	local mesh
	if (
		(string.match(node_name, "leaves") and not
		(string.match(node_name, "with_leaves")) ) or
		string.match(node_name, "needles")
	) then
		mesh = "bushy_leaves_"..mesh_type.."_model.obj"
	end
	return mesh
end

minetest.register_on_mods_loaded(function()
	for node_name, node_def in pairs(minetest.registered_nodes) do
		local mesh = get_mesh(node_name, node_def)
		if mesh ~= nil then
			minetest.override_item(
				node_name,
				{
					drawtype = "mesh",
					mesh = mesh,
					paramtype = "light",
					waving = 2,
				}
			)
		end
	end
end)
