# GroupLib: General Grouping API

A robust and optimized solution for all your grouping needs.


## Usage

### `grouplib.item_get(name)`

Gets the groups of an item by name.

Either returns a table or nil.

    groups = grouplib.item_get("sand")


### `grouplib.item_set(name, groups)`

Sets the groups of an item by name.

This is not the same as just plain overriding, because this doesn't replace
the entire groups table of an item, only update it with new values; if you want
to do the former then use `grouplib.item_replace`.

    grouplib.item_set("sand", {yellow = 1, crumbly = -1, magic = 9})


### `grouplib.item_replace(name, groups)`

Replaces the groups of an item by name.

The old groups are completely thrown out; if what you want to do is to update
the existing values then use `grouplib.item_set`.

    grouplib.item_replace("sand", {oddly_breakable_by_hand = 1})


### `grouplib.item_get_rating(name, ...)`

Gets the ratings of groups of an item by its name and group names.

The amount of return values will be the same as the amount of secondary
arguments passed to the function.

    one, two, three = grouplib.item_get_rating("sand", "crumbly", "falling_node", "soil")


### `grouplib.group_override(group, override)`

Bulk-overrides all items with specified group (`~= 0`) with the override table.

Values are added to a queue on call and the overrides are performed after all
mods have loaded.

Keep in mind this is basically a wrapper for `minetest.override_item`.

    grouplib.group_override("leaves", {drawtype = "firelike"})


## License

The license of the source code is MIT. See `LICENSE` file for details.
