local S = minetest.get_translator(minetest.get_current_modname())

-- Declare global for other mods to check if running HarderVoxels
-- (also possibly for future APIs)
hardervoxels = {}

-- Notify joining players of what the server is running
minetest.register_on_joinplayer(function(player)
	local name = player:get_player_name()
	if name == "singleplayer" then return end

	local meta = player:get_meta()
	local notification = S("WARNING: This server runs the HarderVoxels modpack!").."\n"..
		S("This means that your death will be PERMANENT. No second try.").."\n"..
		S("The difficulty is bumped up. Torches go off, monsters don't burn, etc.")

	if meta:get_int("hv_notified") ~= 1 then
		minetest.chat_send_player(name, minetest.colorize(mcl_colors.GOLD, notification))
		meta:set_int("hv_notified", 1)
	end
end)
