local override = {
	-- node, flammable, fire_encouragement, fire_flammability
	{"mcl_crafting_table:crafting_table", 2, 5, 15},
	{"mcl_barrels:barrel_closed", 2, 5, 10},
	{"mcl_barrels:barrel_open", 2, 5, 10},
}

-- add chests to the override table
local chests = {"chest", "trapped_chest", "trapped_chest_on"}
local chest_variants = {"", "_small", "_left", "_right"}
for _,i in ipairs(chests) do
	for _,j in ipairs(chest_variants) do
		local name = "mcl_chests:"..i..j
		local tbl = {name, 2, 5, 10}
		table.insert(override, tbl)
	end
end

-- finally, override
for _, row in ipairs(override) do
	-- define rows
	local name = row[1]
	local flammable = row[2]
	local encouragement = row[3]
	local flammability = row[4]

	local g = minetest.registered_nodes[name].groups
	g.flammable = flammable
	g.fire_encouragement = encouragement
	g.fire_flammability = flammability

	minetest.override_item(name, {
		groups = g
	})
end
