local S = core.get_translator(core.get_current_modname())

-- Minimum and maximum durations (torch lifetime) in seconds
-- 300sec =  5min
-- 600sec = 10min
local MIN_DURATION = core.settings:get("hv_rt_min_duration") or 300
local MAX_DURATION = core.settings:get("hv_rt_max_duration") or 600

local DROP_AS_DEAD = core.settings:get_bool("hv_rt_drop_burnt_out", false)
local CRAFT_AS_DEAD = core.settings:get_bool("hv_rt_craft_burnt_out", false)


-- Register the dead torch
-- aka the unlit torch
-- aka the burnt-out torch
mcl_torches.register_torch({
	name = "dead_torch",
	description = S("Torch (burnt-out)"),
	icon = "vl_real_torches_dead_torch.png",
	tiles = {"vl_real_torches_dead_torch.png"},
	light = 0, -- no light please
	-- flammable = -1 is to allow torches to get lit naturally by fire
	groups = {dig_immediate = 3, flammable = -1, not_in_creative_inventory = 1},
	sounds = mcl_sounds.node_sound_wood_defaults(),
	particles = 0 -- no particles either
})

-- Add callbacks to dead torches that are not possible through mcl_torches API
core.override_item("vl_real_torches:dead_torch", {
	_on_ignite = function(_, pointed_thing)
		core.set_node(pointed_thing.under, {
			name = "mcl_torches:torch",
			param2 = core.get_node(pointed_thing.under).param2
		})
		return true
	end,
	_on_burn = function(pos)
		core.set_node(pos, {
			name = "mcl_torches:torch",
			param2 = core.get_node(pos).param2
		})
		return true
	end
})
core.override_item("vl_real_torches:dead_torch_wall", {
	_on_ignite = function(_, pointed_thing)
		core.set_node(pointed_thing.under, {
			name = "mcl_torches:torch_wall",
			param2 = core.get_node(pointed_thing.under).param2
		})
		return true
	end,
	_on_burn = function(pos)
		core.set_node(pos, {
			name = "mcl_torches:torch_wall",
			param2 = core.get_node(pos).param2
		})
		return true
	end
})


-- Override regular torches to burn out with time
local torch_override = {
	on_timer = function(pos, _)
		core.set_node(pos, {
			name = "vl_real_torches:dead_torch",
			param2 = core.get_node(pos).param2
		})
		-- play sound
		core.sound_play("fire_extinguish_flame",
			{pos = pos, max_hear_distance = 16, gain = 0.10}, true)
	end,
	on_construct = function(pos)
		-- burn out after MIN_DURATION to MAX_DURATION seconds (random)
		core.get_node_timer(pos):start(math.random(MIN_DURATION, MAX_DURATION))
	end
}

local torch_override_wall = {
	on_timer = function(pos, _)
		core.set_node(pos, {
			name = "vl_real_torches:dead_torch_wall",
			param2 = core.get_node(pos).param2
		})
		core.sound_play("fire_extinguish_flame",
			{pos = pos, max_hear_distance = 16, gain = 0.10}, true)
	end,
	on_construct = function(pos)
		core.get_node_timer(pos):start(math.random(MIN_DURATION, MAX_DURATION))
	end
}

if DROP_AS_DEAD then
	torch_override.drop = "vl_real_torches:dead_torch"
	torch_override_wall.drop = "vl_real_torches:dead_torch"
end

core.override_item("mcl_torches:torch", torch_override)
core.override_item("mcl_torches:torch_wall", torch_override_wall)

-- Start timer on already placed torches
core.register_lbm({
	label = "Start timer on placed torches",
	name = "vl_real_torches:start_timer",
	nodenames = {"mcl_torches:torch", "mcl_torches:torch_wall"},
	action = function(pos, node, dtime_s)
		if not core.get_node_timer(pos):is_started() then
			core.get_node_timer(pos):start(math.random(MIN_DURATION, MAX_DURATION))
		end
	end
})


-- Extinguish torches when under rain
core.register_abm({
	label = "Rain extinguishes torches",
	nodenames = {"mcl_torches:torch", "mcl_torches:torch_wall"},
	interval = 3.0,
	chance = 2,
	-- All Hail the Performance God
	-- (we can do this trick because it doesn't rain in any other dimension)
	min_y = mcl_vars.mg_overworld_min,
	max_y = mcl_vars.mg_overworld_max,

	action = function(pos, node)
		if mcl_weather.rain.raining and mcl_weather.is_outdoor(pos) and mcl_weather.has_rain(pos) then
			if node.name == "mcl_torches:torch" then
				core.set_node(pos, {
					name = "vl_real_torches:dead_torch",
					param2 = node.param2
				})
				core.sound_play("fire_extinguish_flame",
					{pos = pos, max_hear_distance = 16, gain = 0.10}, true)
			elseif node.name == "mcl_torches:torch_wall" then
				core.set_node(pos, {
					name = "vl_real_torches:dead_torch_wall",
					param2 = node.param2
				})
				core.sound_play("fire_extinguish_flame",
					{pos = pos, max_hear_distance = 16, gain = 0.10}, true)
			end
		end
	end
})
-- ...and to extinguish them when near water and similar blocks
core.register_abm({
	label = "Extinguish torches near water",	
	nodenames = {"mcl_torches:torch", "mcl_torches:torch_wall"},
	-- if it puts out fire then it's good enough to put out torches
	neighbors = {"group:puts_out_fire"},
	interval = 4.0,
	chance = 1,
	min_y = mcl_vars.mg_overworld_min,
	max_y = mcl_vars.mg_overworld_max,

	action = function(pos, node)
		if node.name == "mcl_torches:torch" then
			core.set_node(pos, {
				name = "vl_real_torches:dead_torch",
				param2 = node.param2
			})
			core.sound_play("fire_extinguish_flame",
				{pos = pos, max_hear_distance = 16, gain = 0.10}, true)
		elseif node.name == "mcl_torches:torch_wall" then
			core.set_node(pos, {
				name = "vl_real_torches:dead_torch_wall",
				param2 = node.param2
			})
			core.sound_play("fire_extinguish_flame",
				{pos = pos, max_hear_distance = 16, gain = 0.10}, true)
		end
	end
})


-- Override torch crafting recipe if said so in the settings
if CRAFT_AS_DEAD then
	core.clear_craft({output = "mcl_torches:torch 4"})
	core.register_craft({
		output = "vl_real_torches:dead_torch 4",
		recipe = {
			{"group:coal"},
			{"mcl_core:stick"},
		}
	})
end
