local function deal_damage(pos, node, puncher, pointed_thing, damage)
	if not puncher:is_player() then return end

	local wielded = puncher:get_wielded_item():get_name()

	-- if empty-handed and not dead yet
	if wielded == "" and puncher:get_hp() > 0 then
		mcl_util.deal_damage(puncher, damage)
	end
	-- let the engine handle it from this point
	core.node_punch(pos, node, puncher, pointed_thing)
end

core.override_item("mcl_core:cactus", {
	on_punch = function(pos, node, puncher, pointed_thing)
		if not puncher:is_player() then return end

		local wielded = puncher:get_wielded_item():get_name()

		-- if empty-handed and not dead yet
		if wielded == "" and puncher:get_hp() > 0 then
			mcl_util.deal_damage(puncher, 1, {type = "cactus"})
		-- HOW DARE YOU PUNCH CACTUS WITH CACTUS!
		elseif wielded == "mcl_core:cactus" and puncher:get_hp() > 0 then
			mcl_util.deal_damage(puncher, 2, {type = "cactus"})
		end
		core.node_punch(pos, node, puncher, pointed_thing)
	end
})

core.override_item("mcl_core:deadbush", {
	liquid_viscosity = 6,
	liquidtype = "source",
	liquid_alternative_flowing = "mcl_core:deadbush",
	liquid_alternative_source = "mcl_core:deadbush",
	liquid_renewable = false,
	liquid_range = 0,
	on_punch = function(pos, node, puncher, pointed_thing)
		deal_damage(pos, node, puncher, pointed_thing, 0.5)
	end,
})

-- account for all sweet berry bush stages
for i=0,3 do
	core.override_item("mcl_farming:sweet_berry_bush_"..i, {
		on_punch = function(pos, node, puncher, pointed_thing)
			deal_damage(pos, node, puncher, pointed_thing, 0.5)
		end,
	})
end
