local S = core.get_translator(core.get_current_modname())

local msg = {
	S("Game over. Time to start all over again."),
	S("Oh wow, you died. Tough luck."),
	S("Seriously? What did you expect?"),
	S("You're 100% dead, no jokes. And no game."),
	S("Seems like that stalker catched up to you, huh."),
	S("Be more careful next time."),
	S("Wasted. Try again."),
}

core.register_on_dieplayer(function(player, reason)
	local name = player:get_player_name()
	local meta = player:get_meta()
	local message = msg[math.random(1, #msg)]
	meta:set_int("dead", 1)
	if core.global_exists("xban") then
		xban.ban_player(name, nil, nil, message)
	else
		core.kick_player(name, message)
	end
	core.log("action", "[vl_yolo] "..name.." died and has been banned!")
end)

core.register_on_joinplayer(function(player)
	if core.global_exists("xban") and xban.find_entry(player)[2] then
		-- xban will handle that if it didn't already
		return
	else
		local meta = player:get_meta()
		local message = msg[math.random(1, #msg)]
		if meta:get_int("dead") == 1 then
			local name = player:get_player_name()
			core.kick_player(name, message)
		end
	end
end)
