-- only loaded if core.settings:get_bool("mcl_cozy_sit_on_stairs")

local S = ...

mcl_player.register_player_setting("mcl_cozy:sit_on_stairs_slabs", {
	type = "boolean",
	short_desc = S("Enable sitting on stairs and slabs by right-clicking them"),
	ui_default = true,
})

local function sit(pos, node, player, ...)
	if mcl_player.get_player_setting(player, "mcl_cozy:sit_on_stairs_slabs", true) then
		return mcl_cozy.sit(pos, node, player, ...)
	end
end

local function check_param2_and_sit(pos, ...)
	local param2 = core.get_node(pos).param2
	-- avoid inverted stairs
	if param2 >= 20 then return end
	return sit(pos, ...)
end

core.register_on_mods_loaded(function()
	for name, _ in pairs(core.registered_nodes) do
		-- bottom slabs
		if name:find("^mcl_stairs:slab") and not (name:find("_top$") or name:find("_double$")) then
			core.override_item(name, {
				on_rightclick = sit,
			})
		-- stairs
		elseif name:find("^mcl_stairs:stair") then
			core.override_item(name, {
				on_rightclick = check_param2_and_sit,
				_mcl_cozy_offset = vector.new(0, 0, -0.15),
			})
		end
	end
end)
