-- mcl_decor/register.lua

local S = minetest.get_translator(minetest.get_current_modname())

--- Coalquartz Tile ---
minetest.register_node("mcl_decor:coalquartz_tile", {
    description = S("Coalquartz Tile"),
    tiles = {"mcl_decor_coalquartz_tile.png"},
	is_ground_content = false,
	groups = {pickaxey=1, flammable=1, quartz_block=1, building_block=1, material_stone=1, fire_encouragement=5, fire_flammability=5},
	sounds = mcl_sounds.node_sound_stone_defaults(),
	_mcl_blast_resistance = 4,
	_mcl_hardness = 3,
})
minetest.register_craft({
	output = "mcl_decor:coalquartz_tile",
	recipe = {
		{"mcl_core:coal_lump", "mcl_nether:quartz"},
		{"mcl_nether:quartz", "mcl_core:coal_lump"}
	}
})
minetest.register_craft({
	output = "mcl_decor:coalquartz_tile",
	recipe = {
		{"mcl_nether:quartz", "mcl_core:coal_lump"},
		{"mcl_core:coal_lump", "mcl_nether:quartz"}
	}
})
mcl_stairs.register_stair_and_slab_simple("coalquartz_tile", "mcl_decor:coalquartz_tile", S("Coalquartz Stair"), S("Coalquartz Slab"), S("Double Coalquartz Slab"))

--- Paths ---
mcl_decor.register_path(
	"mcl_decor:gravel_path",
	S("Gravel Path"),
	"mcl_core:gravel",
	"default_gravel.png",
	"shovely",
	mcl_sounds.node_sound_dirt_defaults({footstep = {name="default_gravel_footstep", gain=0.45}})
)
mcl_decor.register_path(
	"mcl_decor:cobble_path",
	S("Cobblestone Path"),
	"mcl_core:cobble",
	"default_cobble.png",
	"pickaxey",
	mcl_sounds.node_sound_stone_defaults()
)
mcl_decor.register_path(
	"mcl_decor:stone_path",
	S("Stone Path"),
	"mcl_core:stone",
	"default_stone.png",
	"pickaxey",
	mcl_sounds.node_sound_stone_defaults()
)
mcl_decor.register_path(
	"mcl_decor:granite_path",
	S("Granite Path"),
	"mcl_core:granite",
	"mcl_core_granite.png",
	"pickaxey",
	mcl_sounds.node_sound_stone_defaults()
)
mcl_decor.register_path(
	"mcl_decor:andesite_path",
	S("Andesite Path"),
	"mcl_core:andesite",
	"mcl_core_andesite.png",
	"pickaxey",
	mcl_sounds.node_sound_stone_defaults()
)
mcl_decor.register_path(
	"mcl_decor:diorite_path",
	S("Diorite Path"),
	"mcl_core:diorite",
	"mcl_core_diorite.png",
	"pickaxey",
	mcl_sounds.node_sound_stone_defaults()
)
mcl_decor.register_path(
	"mcl_decor:netherrack_path",
	S("Netherrack Path"),
	"mcl_nether:netherrack",
	"mcl_nether_netherrack.png",
	"pickaxey",
	mcl_sounds.node_sound_stone_defaults()
)



--- Table Lamp ---
minetest.register_node("mcl_decor:table_lamp", {
	description = S("Table Lamp"),
	tiles = {"mcl_decor_table_lamp.png", "mcl_decor_table_lamp_bottom.png", "mcl_decor_table_lamp_side.png",
		"mcl_decor_table_lamp_side.png", "mcl_decor_table_lamp_side.png", "mcl_decor_table_lamp_side.png"},
	drawtype = "nodebox",
	paramtype = "light",
	stack_max = 64,
	node_box = {
		type = "fixed",
		fixed = {
			{-0.25, -0.5, -0.25, 0.25, -0.375, 0.25},
			{-0.0625, -0.375, -0.0625, 0.0625, 0, 0.0625},
			{-0.3125, 0, -0.3125, 0.3125, 0.5, 0.3125},
		}
	},
	selection_box = {
		type = "fixed",
		fixed = {-0.3125, -0.5, -0.3125, 0.3125, 0.5, 0.3125},
	},
	is_ground_content = false,
	light_source = minetest.LIGHT_MAX,
	groups = {handy=1, axey=1, attached_node=1, material_wood=1, deco_block=1, flammable=-1},
	sounds = mcl_sounds.node_sound_wood_defaults(),
	_mcl_blast_resistance = 0.9,
	_mcl_hardness = 0.9,
})
minetest.register_craft({
	output = "mcl_decor:table_lamp 3",
	recipe = {
		{"group:wool", "group:wool", "group:wool"},
		{"group:wool", "mcl_torches:torch", "group:wool"},
		{"mcl_core:cobble", "mcl_core:cobble", "mcl_core:cobble"}
	}
})



--- Tables and Chairs ---
mcl_decor.register_chair_and_table("mcl_decor:wooden_chair", S("Oak Chair"), "mcl_decor:wooden_table", S("Oak Table"), "mcl_core:wood", "default_wood.png")
mcl_decor.register_chair_and_table("mcl_decor:dark_oak_chair", S("Dark Oak Chair"), "mcl_decor:dark_oak_table", S("Dark Oak Table"), "mcl_core:darkwood", "mcl_core_planks_big_oak.png")
mcl_decor.register_chair_and_table("mcl_decor:jungle_chair", S("Jungle Chair"), "mcl_decor:jungle_table", S("Jungle Table"), "mcl_core:junglewood", "default_junglewood.png")
mcl_decor.register_chair_and_table("mcl_decor:spruce_chair", S("Spruce Chair"), "mcl_decor:spruce_table", S("Spruce Table"), "mcl_core:sprucewood", "mcl_core_planks_spruce.png")
mcl_decor.register_chair_and_table("mcl_decor:acacia_chair", S("Acacia Chair"), "mcl_decor:acacia_table", S("Acacia Table"), "mcl_core:acaciawood", "default_acacia_wood.png")
mcl_decor.register_chair_and_table("mcl_decor:birch_chair", S("Birch Chair"), "mcl_decor:birch_table", S("Birch Table"), "mcl_core:birchwood", "mcl_core_planks_birch.png")

mcl_decor.register_slab_table("mcl_decor:wooden_stable", S("Oak Slab Table"), "mcl_core:wood", "default_wood.png")
mcl_decor.register_slab_table("mcl_decor:dark_oak_stable", S("Dark Oak Slab Table"), "mcl_core:darkwood", "mcl_core_planks_big_oak.png")
mcl_decor.register_slab_table("mcl_decor:jungle_stable", S("Jungle Slab Table"), "mcl_core:junglewood", "default_junglewood.png")
mcl_decor.register_slab_table("mcl_decor:spruce_stable", S("Spruce Slab Table"), "mcl_core:sprucewood", "mcl_core_planks_spruce.png")
mcl_decor.register_slab_table("mcl_decor:acacia_stable", S("Acacia Slab Table"), "mcl_core:acaciawood", "default_acacia_wood.png")
mcl_decor.register_slab_table("mcl_decor:birch_stable", S("Birch Slab Table"), "mcl_core:birchwood", "mcl_core_planks_birch.png")



--- Armchairs ---
mcl_decor.register_armchair("mcl_decor:white_armchair", S("White Armchair"), "mcl_wool:white", "wool_white.png", "white", "unicolor_white")
mcl_decor.register_armchair("mcl_decor:grey_armchair", S("Grey Armchair"), "mcl_wool:grey", "wool_dark_grey.png", "dark_grey", "unicolor_darkgrey")
mcl_decor.register_armchair("mcl_decor:silver_armchair", S("Light Grey Armchair"), "mcl_wool:silver", "wool_grey.png", "grey", "unicolor_grey")
mcl_decor.register_armchair("mcl_decor:black_armchair", S("Black Armchair"), "mcl_wool:black", "wool_black.png", "black", "unicolor_black")
mcl_decor.register_armchair("mcl_decor:red_armchair", S("Red Armchair"), "mcl_wool:red", "wool_red.png", "red", "unicolor_red")
mcl_decor.register_armchair("mcl_decor:yellow_armchair", S("Yellow Armchair"), "mcl_wool:yellow", "wool_yellow.png", "yellow", "unicolor_yellow")
mcl_decor.register_armchair("mcl_decor:green_armchair", S("Green Armchair"), "mcl_wool:green", "wool_dark_green.png", "dark_green", "unicolor_dark_green")
mcl_decor.register_armchair("mcl_decor:cyan_armchair", S("Cyan Armchair"), "mcl_wool:cyan", "wool_cyan.png", "cyan", "unicolor_cyan")
mcl_decor.register_armchair("mcl_decor:blue_armchair", S("Blue Armchair"), "mcl_wool:blue", "wool_blue.png", "blue", "unicolor_blue")
mcl_decor.register_armchair("mcl_decor:magenta_armchair", S("Magenta Armchair"), "mcl_wool:magenta", "wool_magenta.png", "magenta", "unicolor_red_violet")
mcl_decor.register_armchair("mcl_decor:orange_armchair", S("Orange Armchair"), "mcl_wool:orange", "wool_orange.png", "orange", "unicolor_orange")
mcl_decor.register_armchair("mcl_decor:purple_armchair", S("Purple Armchair"), "mcl_wool:purple", "wool_violet.png", "violet", "unicolor_violet")
mcl_decor.register_armchair("mcl_decor:brown_armchair", S("Brown Armchair"), "mcl_wool:brown", "wool_brown.png", "brown", "unicolor_dark_orange")
mcl_decor.register_armchair("mcl_decor:pink_armchair", S("Pink Armchair"), "mcl_wool:pink", "wool_pink.png", "pink", "unicolor_light_red")
mcl_decor.register_armchair("mcl_decor:lime_armchair", S("Lime Armchair"), "mcl_wool:lime", "mcl_wool_lime.png", "green", "unicolor_green")
mcl_decor.register_armchair("mcl_decor:light_blue_armchair", S("Light Blue Armchair"), "mcl_wool:light_blue", "mcl_wool_light_blue.png", "lightblue", "unicolor_light_blue")



--- Dyed Planks ---
mcl_decor.register_dyed_planks("white_planks", S("White Planks"), "#EDEDED", "white", "unicolor_white")
mcl_decor.register_dyed_planks("grey_planks", S("Grey Planks"), "#5F5F5F", "dark_grey", "unicolor_darkgrey")
mcl_decor.register_dyed_planks("silver_planks", S("Light Grey Planks"), "#8C8C8C", "grey", "unicolor_grey")
mcl_decor.register_dyed_planks("black_planks", S("Black Planks"), "#030303", "black", "unicolor_black")
mcl_decor.register_dyed_planks("red_planks", S("Red Planks"), "#BD0000", "red", "unicolor_red")
mcl_decor.register_dyed_planks("yellow_planks", S("Yellow Planks"), "#EBD800", "yellow", "unicolor_yellow")
mcl_decor.register_dyed_planks("green_planks", S("Green Planks"), "#086400", "dark_green", "unicolor_dark_green")
mcl_decor.register_dyed_planks("cyan_planks", S("Cyan Planks"), "#00C4B4", "cyan", "unicolor_cyan")
mcl_decor.register_dyed_planks("blue_planks", S("Blue Planks"), "#0B1E80", "blue", "unicolor_blue")
mcl_decor.register_dyed_planks("magenta_planks", S("Magenta Planks"), "#954395", "magenta", "unicolor_red_violet")
mcl_decor.register_dyed_planks("orange_planks", S("Orange Planks"), "#E68200", "orange", "unicolor_orange")
mcl_decor.register_dyed_planks("purple_planks", S("Purple Planks"), "#461A6D", "violet", "unicolor_violet")
mcl_decor.register_dyed_planks("brown_planks", S("Brown Planks"), "#432209", "brown", "unicolor_dark_orange")
mcl_decor.register_dyed_planks("pink_planks", S("Pink Planks"), "#ED9BB4", "pink", "unicolor_light_red")
mcl_decor.register_dyed_planks("lime_planks", S("Lime Planks"), "#B3DF86", "green", "unicolor_green")
mcl_decor.register_dyed_planks("light_blue_planks", S("Light Blue Planks"), "#72A4D4", "lightblue", "unicolor_light_blue")
