-- mcl_decor/api.lua

local S = minetest.get_translator(minetest.get_current_modname())

-- originally from the ts_furniture mod (which is from cozy) by Thomas--S // <https://github.com/minetest-mods/ts_furniture/>
mcl_decor.sit = function(pos, _, player)
	local name = player:get_player_name()
	if not mcl_player.player_attached[name] then
		if vector.length(player:get_player_velocity()) > 0 then
			minetest.chat_send_player(player:get_player_name(), S("You have to stop moving before sitting down!"))
			return
		end
		player:move_to(pos)
		player:set_eye_offset({x = 0, y = -7, z = 0}, {x = 0, y = 0, z = 0})
		player:set_physics_override(0, 0, 0)
		mcl_player.player_attached[name] = true
		minetest.after(0.1, function()
			if player then
				mcl_player.player_set_animation(player, "sit" , 30)
			end
		end)
	else
		mcl_decor.stand(player, name)
	end
end
mcl_decor.up = function(_, _, player)
		local name = player:get_player_name()
		if mcl_player.player_attached[name] then
			mcl_decor.stand(player, name)
		end
	end
mcl_decor.stand = function(player, name)
	player:set_eye_offset({x = 0, y = 0, z = 0}, {x = 0, y = 0, z = 0})
	player:set_physics_override(1, 1, 1)
	mcl_player.player_attached[name] = false
	mcl_player.player_set_animation(player, "stand", 30)
end
if not minetest.get_modpath("mcl_cozy") then
	minetest.register_globalstep(function(dtime)
		local players = minetest.get_connected_players()
		for i = 1, #players do
			local player = players[i]
			local name = player:get_player_name()
			local ctrl = player:get_player_control()
			if mcl_player.player_attached[name] and not player:get_attach() and
			(ctrl.up or ctrl.down or ctrl.left or ctrl.right or ctrl.jump or ctrl.sneak) then
				mcl_decor.up(nil, nil, player)
			end
		end
	end)
end



function mcl_decor.register_path(name, desc, material, tiles, sgroup, sounds)
	minetest.register_node(name, {
		description = desc,
		tiles = {tiles},
		wield_image = "mcl_decor_path_alpha.png^"..tiles.."^" ..
					"mcl_decor_path_alpha.png^[makealpha:255,126,126",
		inventory_image = "mcl_decor_path_alpha.png^"..tiles.."^" ..
					"mcl_decor_path_alpha.png^[makealpha:255,126,126",
		groups = {handy=1, [sgroup]=1, attached_node=1, dig_by_piston=1, deco_block=1},
		drawtype = "nodebox",
		paramtype = "light",
		sunlight_propagates = true,
		buildable_to = true,
		walkable = true,
		node_box = {
			type = "fixed",
			fixed = {
				{-0.4375, -0.5, -0.4375, -0.125, -0.4375, -0.125},
				{-0.125, -0.5, -0.0625, 0.0625, -0.4375, 0.125},
				{-0.3125, -0.5, 0.1875, -0.0625, -0.4375, 0.4375},
				{0.0625, -0.5, -0.375, 0.25, -0.4375, -0.1875},
				{0.125, -0.5, 0.125, 0.375, -0.4375, 0.375},
				{0.25, -0.5, -0.125, 0.375, -0.4375, 0},
				{-0.4375, -0.5, 0, -0.3125, -0.4375, 0.125},
			}
		},
		selection_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.5, 0.5, -0.4375, 0.5},
			}
		},
		collision_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.5, 0.5, -0.4375, 0.5},
			}
		},
		_mcl_blast_resistance = 0.3,
		_mcl_hardness = 0.3,
		sounds = sounds
	})
	minetest.register_craft({
		output = name.." 16",
		recipe = {
			{material, "", material},
			{"", material, ""},
			{material, "", material}
		}
	})
end



function mcl_decor.register_chair_and_table(name, desc, desc2, material, tiles, groups)
	if group == nil then
		group = {handy=1, axey=1, attached_node=1, material_wood=1, deco_block=1, flammable=-1}
	else
		group = {handy=1, axey=1, attached_node=1, material_wood=1, deco_block=1}
	end

	-- chair part
	minetest.register_node("mcl_decor:"..name.."_chair", {
		description = desc,
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{-0.25, 0, 0.125, 0.25, 0.5, 0.25},
				{-0.25, -0.125, -0.25, 0.25, 0, 0.25},
				{-0.25, -0.5, 0.125, -0.125, -0.125, 0.25},
				{0.125, -0.5, -0.25, 0.25, -0.125, -0.125},
				{0.125, -0.5, 0.125, 0.25, -0.125, 0.25},
				{-0.25, -0.5, -0.25, -0.125, -0.125, -0.125},
			}
		},
		tiles = {tiles},
		is_ground_content = false,
		paramtype = "light",
		paramtype2 = "facedir",
		stack_max = 64,
		sunlight_propagates = true,
		selection_box = {
			type = "fixed",
			fixed = { -0.25, -0.5, -0.25, 0.25, 0.5, 0.25 },
		},
		groups = group,
		_mcl_hardness = 1,
		_mcl_blast_resistance = 1,
		sounds = mcl_sounds.node_sound_wood_defaults(),
		on_rightclick = mcl_decor.sit
	})
	minetest.register_craft({
		output = "mcl_decor:"..name.."_chair",
		recipe = {
			{"", "", "mcl_core:stick"},
			{material, material, material},
			{"mcl_core:stick", "", "mcl_core:stick"}
		}
	})
	minetest.register_craft({
		output = "mcl_decor:"..name.."_chair",
		recipe = {
			{"mcl_core:stick", "", ""},
			{material, material, material},
			{"mcl_core:stick", "", "mcl_core:stick"}
		}
	})
	minetest.register_craft({
		type = "fuel",
		recipe = "mcl_decor:"..name.."_chair",
		burntime = 8,
	})
	
	-- table part
	minetest.register_node("mcl_decor:"..name.."_table", {
		description = desc2,
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{ -0.5, 0.375, -0.5, 0.5, 0.5, 0.5 },
				{ -0.4375, -0.5, -0.4375, -0.3125, 0.375, -0.3125 },
				{ 0.3125, -0.5, -0.4375, 0.4375, 0.375, -0.3125 },
				{ 0.3125, -0.5, 0.3125, 0.4375, 0.375, 0.4375 },
				{ -0.4375, -0.5, 0.3125, -0.3125, 0.375, 0.4375 },
			}
		},
		selection_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -0.5, 0.5, 0.5, 0.5 },
		},
		tiles = {tiles},
		is_ground_content = false,
		paramtype = "light",
		stack_max = 64,
		sunlight_propagates = true,
		groups = group,
		_mcl_hardness = 2,
		_mcl_blast_resistance = 3,
		sounds = mcl_sounds.node_sound_wood_defaults(),
	})
	minetest.register_craft({
		output = "mcl_decor:"..name.."_table".." 2",
		recipe = {
			{material, material, material},
			{"mcl_core:stick", "", "mcl_core:stick"},
			{"mcl_core:stick", "", "mcl_core:stick"}
		}
	})
	minetest.register_craft({
		type = "fuel",
		recipe = "mcl_decor:"..name.."_table",
		burntime = 10,
	})
end

function mcl_decor.register_slab_table(name, desc, material, tiles, group)
	if group == nil then
		group = {handy=1, axey=1, attached_node=1, material_wood=1, deco_block=1, flammable=-1}
	else
		group = {handy=1, axey=1, attached_node=1, material_wood=1, deco_block=1}
	end
	minetest.register_node("mcl_decor:"..name.."_stable", {
		description = desc,
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{-0.125, -0.5, -0.125, 0.125, 0, 0.125},
				{-0.5, 0, -0.5, 0.5, 0.5, 0.5},
			}
		},
		tiles = {tiles},
		is_ground_content = false,
		paramtype = "light",
		stack_max = 64,
		sunlight_propagates = true,
		groups = group,
		_mcl_hardness = 2,
		_mcl_blast_resistance = 3,
		sounds = mcl_sounds.node_sound_wood_defaults(),
	})
	minetest.register_craft({
		output = "mcl_decor:"..name.."_stable".." 3",
		recipe = {
			{material, material, material},
			{"", "mcl_core:stick", ""}
		}
	})
	minetest.register_craft({
		type = "fuel",
		recipe = "mcl_decor:"..name.."_stable",
		burntime = 10,
	})
end

function mcl_decor.register_armchair(color, desc, tiles, dye, colorgroup)
	minetest.register_node("mcl_decor:"..color.."_armchair", {
		description = desc,
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{-0.4375, -0.5, -0.5, 0.4375, -0.0625, 0.1875},
				{-0.5, -0.4375, -0.5, -0.3125, 0.125, 0.1875},
				{0.3125, -0.4375, -0.5, 0.5, 0.125, 0.1875},
				{-0.5, -0.5, 0.1875, 0.5, 0.5, 0.5},
				{-0.5, -0.5, -0.4375, 0.5, -0.4375, 0.5},
			}
		},
		tiles = {tiles},
		is_ground_content = false,
		paramtype = "light",
		paramtype2 = "facedir",
		stack_max = 64,
		selection_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -0.5, 0.5, 0.5, 0.5 },
		},
		groups = {handy=1, shearsy_wool=1, attached_node=1, deco_block=1, armchair=1, flammable=1, fire_encouragement=30, fire_flammability=60, [colorgroup]=1},
		_mcl_hardness = 1,
		_mcl_blast_resistance = 1,
		sounds = mcl_sounds.node_sound_wood_defaults(),
		on_rightclick = mcl_decor.sit
	})
	minetest.register_craft({
		output = "mcl_decor:"..color.."_armchair",
		recipe = {
			{"", "", "mcl_wool:"..color},
			{"mcl_wool:"..color, "mcl_wool:"..color, "mcl_wool:"..color},
			{"mcl_core:stick", "mcl_core:stick", "mcl_core:stick"}
		}
	})
	minetest.register_craft({
		output = "mcl_decor:"..color.."_armchair",
		recipe = {
			{"mcl_wool:"..color, "", ""},
			{"mcl_wool:"..color, "mcl_wool:"..color, "mcl_wool:"..color},
			{"mcl_core:stick", "mcl_core:stick", "mcl_core:stick"}
		}
	})
	minetest.register_craft({
		type = "shapeless",
		output = "mcl_decor:"..color.."_armchair",
		recipe = {"group:armchair", "mcl_dye:"..dye},
	})
	minetest.register_craft({
		type = "fuel",
		recipe = "mcl_decor:"..color.."_armchair",
		burntime = 10,
	})
end

function mcl_decor.register_dyed_planks(color, desc, hexcolor, dye, colorgroup)
	minetest.register_node("mcl_decor:"..color.."_planks", {
		description = desc,
		tiles = {"mcl_decor_dyed_planks.png^[colorize:" .. hexcolor .. ":125"},
		stack_max = 64,
		is_ground_content = false,
		groups = {handy=1, axey=1, flammable=3, wood=1, building_block=1, material_wood=1, fire_encouragement=5, fire_flammability=20, [colorgroup]=1},
		sounds = mcl_sounds.node_sound_wood_defaults(),
		_mcl_blast_resistance = 3,
		_mcl_hardness = 2,
	})
	minetest.register_craft({
		type = "shapeless",
		output = "mcl_decor:"..color.."_planks",
		recipe = {"group:wood", "mcl_dye:"..dye}
	})
	-- maybe descriptions of slabs/stairs after that workaround will be VERY CRAPPY (especially with translations via locales), but at least it works
	mcl_stairs.register_stair_and_slab_simple(
		color.."_planks", "mcl_decor:"..color.."_planks", desc..S(" Stair"), desc..S(" Slab"), S("Double")..desc..S(" Slab"), "woodlike"
	)
end

function mcl_decor.register_curtains(color, desc, wool, wooltile, dye, colorgroup)
	minetest.register_node("mcl_decor:curtain_"..color, {
		description = desc,
		tiles = {
			wooltile.."^mcl_decor_curtain_alpha.png^[makealpha:255,126,126^mcl_decor_curtain_overlay.png", -- front
			wooltile.."^mcl_decor_curtain_alpha.png^[makealpha:255,126,126^mcl_decor_curtain_overlay.png^[transformFY", -- back
			wooltile.."^mcl_decor_curtain_overlay.png^[transformR270", -- side
			wooltile.."^mcl_decor_curtain_overlay.png^[transformR90", -- side
			wooltile.."^mcl_decor_curtain_overlay.png^[transformFY", -- top
			wooltile.."^mcl_decor_curtain_alpha.png^[makealpha:255,126,126^mcl_decor_curtain_overlay.png", -- bottom
		},
		stack_max = 64,
		inventory_image = wooltile.."^mcl_decor_curtain_alpha.png^[makealpha:255,126,126^mcl_decor_curtain_overlay.png",
		wield_image = wooltile.."^mcl_decor_curtain_alpha.png^[makealpha:255,126,126^mcl_decor_curtain_overlay.png",
		walkable = false,
		sunlight_propagates = true,
		drawtype = "nodebox",
		paramtype = "light",
		paramtype2 = "wallmounted",
		groups = {handy=1, flammable=-1, curtain=1, attached_node=1, dig_by_piston=1, deco_block=1, material_wool=1, [colorgroup]=1},
		sounds = mcl_sounds.node_sound_wood_defaults(),
		node_box = {
			type = "wallmounted",
		},
		_mcl_blast_resistance = 0.2,
		_mcl_hardness = 0.2,
		on_rightclick = function(pos, node, _, itemstack)
			minetest.set_node(pos, {name="mcl_decor:curtain_"..color.."_closed", param2=node.param2})
			return itemstack
		end
	})
	minetest.register_node("mcl_decor:curtain_"..color.."_closed", {
		description = desc..S(" (closed)"),
		tiles = {
			wooltile.."^mcl_decor_curtain_overlay.png", -- front
			wooltile.."^mcl_decor_curtain_overlay.png^[transformFY", -- back
			wooltile.."^mcl_decor_curtain_overlay.png^[transformR270", -- side
			wooltile.."^mcl_decor_curtain_overlay.png^[transformR90", -- side
			wooltile.."^mcl_decor_curtain_overlay.png^[transformFY", -- top
			wooltile.."^mcl_decor_curtain_overlay.png", -- bottom
		},
		walkable = false,
		sunlight_propagates = true,
		drawtype = "nodebox",
		paramtype = "light",
		paramtype2 = "wallmounted",
		groups = {handy=1, flammable=-1, attached_node=1, dig_by_piston=1, not_in_creative_inventory=1},
		sounds = mcl_sounds.node_sound_wood_defaults(),
		node_box = {
			type = "wallmounted",
		},
		drop = "mcl_decor:curtain_"..color,
		_mcl_blast_resistance = 0.2,
		_mcl_hardness = 0.2,
		on_rightclick = function(pos, node, clicker, itemstack)
			minetest.set_node(pos, {name="mcl_decor:curtain_"..color, param2=node.param2})
			return itemstack
		end
	})
	minetest.register_craft({
		output = "mcl_decor:curtain_"..color,
		recipe = {
			{"mcl_core:iron_ingot", "mcl_core:stick", "mcl_core:iron_ingot"},
			{wool, wool, wool},
			{wool, "", wool}
		}
	})
	minetest.register_craft({
		type = "shapeless",
		output = "mcl_decor:curtain_"..color,
		recipe = {"group:curtain", "mcl_dye:"..dye},
	})
end
