-- mcl_decor/colored.lua

local S = minetest.get_translator(minetest.get_current_modname())

--=-- API --=--
function mcl_decor.register_armchair(color, desc, tiles, dye, colorgroup)
	minetest.register_node("mcl_decor:"..color.."_armchair", {
		description = desc,
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{-0.4375, -0.5, -0.5, 0.4375, -0.0625, 0.1875},
				{-0.5, -0.4375, -0.5, -0.3125, 0.125, 0.1875},
				{0.3125, -0.4375, -0.5, 0.5, 0.125, 0.1875},
				{-0.5, -0.5, 0.1875, 0.5, 0.5, 0.5},
				{-0.5, -0.5, -0.4375, 0.5, -0.4375, 0.5},
			}
		},
		tiles = {tiles},
		is_ground_content = false,
		paramtype = "light",
		paramtype2 = "facedir",
		stack_max = 64,
		selection_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -0.5, 0.5, 0.5, 0.5 },
		},
		groups = {handy=1, shearsy_wool=1, attached_node=1, deco_block=1, armchair=1, flammable=1, fire_encouragement=30, fire_flammability=60, [colorgroup]=1},
		_mcl_hardness = 1,
		_mcl_blast_resistance = 1,
		sounds = mcl_sounds.node_sound_wood_defaults(),
		on_rightclick = mcl_decor.sit
	})
	minetest.register_craft({
		output = "mcl_decor:"..color.."_armchair",
		recipe = {
			{"", "", "mcl_wool:"..color},
			{"mcl_wool:"..color, "mcl_wool:"..color, "mcl_wool:"..color},
			{"mcl_core:stick", "mcl_core:stick", "mcl_core:stick"}
		}
	})
	minetest.register_craft({
		output = "mcl_decor:"..color.."_armchair",
		recipe = {
			{"mcl_wool:"..color, "", ""},
			{"mcl_wool:"..color, "mcl_wool:"..color, "mcl_wool:"..color},
			{"mcl_core:stick", "mcl_core:stick", "mcl_core:stick"}
		}
	})
	minetest.register_craft({
		type = "shapeless",
		output = "mcl_decor:"..color.."_armchair",
		recipe = {"group:armchair", "mcl_dye:"..dye},
	})
	minetest.register_craft({
		type = "fuel",
		recipe = "mcl_decor:"..color.."_armchair",
		burntime = 10,
	})
end

function mcl_decor.register_dyed_planks(color, desc, hexcolor, dye, colorgroup)
	minetest.register_node("mcl_decor:"..color.."_planks", {
		description = desc,
		tiles = {"mcl_decor_dyed_planks.png^[colorize:" .. hexcolor .. ":125"},
		stack_max = 64,
		is_ground_content = false,
		groups = {handy=1, axey=1, flammable=3, wood=1, building_block=1, material_wood=1, fire_encouragement=5, fire_flammability=20, [colorgroup]=1},
		sounds = mcl_sounds.node_sound_wood_defaults(),
		_mcl_blast_resistance = 3,
		_mcl_hardness = 2,
	})
	minetest.register_craft({
		type = "shapeless",
		output = "mcl_decor:"..color.."_planks",
		recipe = {"group:wood", "mcl_dye:"..dye}
	})
	-- maybe descriptions of slabs/stairs after that workaround will be VERY CRAPPY (especially with translations via locales), but at least it works
	mcl_stairs.register_stair_and_slab_simple(
		color.."_planks", "mcl_decor:"..color.."_planks", desc..S(" Stair"), desc..S(" Slab"), S("Double")..desc..S(" Slab"), "woodlike"
	)
end

function mcl_decor.register_curtains(color, desc, wool, wooltile, dye, colorgroup)
	minetest.register_node("mcl_decor:curtain_"..color, {
		description = desc,
		tiles = {
			wooltile.."^mcl_decor_curtain_alpha.png^[makealpha:255,126,126^mcl_decor_curtain_overlay.png", -- front
			wooltile.."^mcl_decor_curtain_alpha.png^[makealpha:255,126,126^mcl_decor_curtain_overlay.png^[transformFY", -- back
			wooltile.."^mcl_decor_curtain_overlay.png^[transformR270", -- side
			wooltile.."^mcl_decor_curtain_overlay.png^[transformR90", -- side
			wooltile.."^mcl_decor_curtain_overlay.png^[transformFY", -- top
			wooltile.."^mcl_decor_curtain_alpha.png^[makealpha:255,126,126^mcl_decor_curtain_overlay.png", -- bottom
		},
		stack_max = 64,
		inventory_image = wooltile.."^mcl_decor_curtain_alpha.png^[makealpha:255,126,126^mcl_decor_curtain_overlay.png",
		wield_image = wooltile.."^mcl_decor_curtain_alpha.png^[makealpha:255,126,126^mcl_decor_curtain_overlay.png",
		walkable = false,
		sunlight_propagates = true,
		drawtype = "nodebox",
		paramtype = "light",
		paramtype2 = "wallmounted",
		groups = {handy=1, flammable=-1, curtain=1, attached_node=1, dig_by_piston=1, deco_block=1, material_wool=1, [colorgroup]=1},
		sounds = mcl_sounds.node_sound_wood_defaults(),
		node_box = {
			type = "wallmounted",
		},
		_mcl_blast_resistance = 0.2,
		_mcl_hardness = 0.2,
		on_rightclick = function(pos, node, _, itemstack)
			minetest.set_node(pos, {name="mcl_decor:curtain_"..color.."_closed", param2=node.param2})
			return itemstack
		end
	})
	minetest.register_node("mcl_decor:curtain_"..color.."_closed", {
		description = desc..S(" (closed)"),
		tiles = {
			wooltile.."^mcl_decor_curtain_overlay.png", -- front
			wooltile.."^mcl_decor_curtain_overlay.png^[transformFY", -- back
			wooltile.."^mcl_decor_curtain_overlay.png^[transformR270", -- side
			wooltile.."^mcl_decor_curtain_overlay.png^[transformR90", -- side
			wooltile.."^mcl_decor_curtain_overlay.png^[transformFY", -- top
			wooltile.."^mcl_decor_curtain_overlay.png", -- bottom
		},
		walkable = false,
		sunlight_propagates = true,
		drawtype = "nodebox",
		paramtype = "light",
		paramtype2 = "wallmounted",
		groups = {handy=1, flammable=-1, attached_node=1, dig_by_piston=1, not_in_creative_inventory=1},
		sounds = mcl_sounds.node_sound_wood_defaults(),
		node_box = {
			type = "wallmounted",
		},
		drop = "mcl_decor:curtain_"..color,
		_mcl_blast_resistance = 0.2,
		_mcl_hardness = 0.2,
		on_rightclick = function(pos, node, clicker, itemstack)
			minetest.set_node(pos, {name="mcl_decor:curtain_"..color, param2=node.param2})
			return itemstack
		end
	})
	minetest.register_craft({
		output = "mcl_decor:curtain_"..color,
		recipe = {
			{"mcl_core:iron_ingot", "mcl_core:stick", "mcl_core:iron_ingot"},
			{wool, wool, wool},
			{wool, "", wool}
		}
	})
	minetest.register_craft({
		type = "shapeless",
		output = "mcl_decor:curtain_"..color,
		recipe = {"group:curtain", "mcl_dye:"..dye},
	})
end



--=-- REGISTER --=--
--- Armchairs ---
mcl_decor.register_armchair("white", S("White Armchair"), "wool_white.png", "white", "unicolor_white")
mcl_decor.register_armchair("grey", S("Grey Armchair"), "wool_dark_grey.png", "dark_grey", "unicolor_darkgrey")
mcl_decor.register_armchair("silver", S("Light Grey Armchair"), "wool_grey.png", "grey", "unicolor_grey")
mcl_decor.register_armchair("black", S("Black Armchair"), "wool_black.png", "black", "unicolor_black")
mcl_decor.register_armchair("red", S("Red Armchair"), "wool_red.png", "red", "unicolor_red")
mcl_decor.register_armchair("yellow", S("Yellow Armchair"), "wool_yellow.png", "yellow", "unicolor_yellow")
mcl_decor.register_armchair("green", S("Green Armchair"), "wool_dark_green.png", "dark_green", "unicolor_dark_green")
mcl_decor.register_armchair("cyan", S("Cyan Armchair"), "wool_cyan.png", "cyan", "unicolor_cyan")
mcl_decor.register_armchair("blue", S("Blue Armchair"), "wool_blue.png", "blue", "unicolor_blue")
mcl_decor.register_armchair("magenta", S("Magenta Armchair"), "wool_magenta.png", "magenta", "unicolor_red_violet")
mcl_decor.register_armchair("orange", S("Orange Armchair"), "wool_orange.png", "orange", "unicolor_orange")
mcl_decor.register_armchair("purple", S("Purple Armchair"), "wool_violet.png", "violet", "unicolor_violet")
mcl_decor.register_armchair("brown", S("Brown Armchair"), "wool_brown.png", "brown", "unicolor_dark_orange")
mcl_decor.register_armchair("pink", S("Pink Armchair"), "wool_pink.png", "pink", "unicolor_light_red")
mcl_decor.register_armchair("lime", S("Lime Armchair"), "mcl_wool_lime.png", "green", "unicolor_green")
mcl_decor.register_armchair("light_blue", S("Light Blue Armchair"), "mcl_wool_light_blue.png", "lightblue", "unicolor_light_blue")

--- Curtains ---
mcl_decor.register_curtains("white", S("White Curtains"), "mcl_wool:white", "wool_white.png", "white", "unicolor_white")
mcl_decor.register_curtains("grey", S("Grey Curtains"), "mcl_wool:grey", "wool_dark_grey.png", "dark_grey", "unicolor_darkgrey")
mcl_decor.register_curtains("silver", S("Light Grey Curtains"), "mcl_wool:silver", "wool_grey.png", "grey", "unicolor_grey")
mcl_decor.register_curtains("black", S("Black Curtains"), "mcl_wool:black", "wool_black.png", "black", "unicolor_black")
mcl_decor.register_curtains("red", S("Red Curtains"), "mcl_wool:red", "wool_red.png", "red", "unicolor_red")
mcl_decor.register_curtains("yellow", S("Yellow Curtains"), "mcl_wool:yellow", "wool_yellow.png", "yellow", "unicolor_yellow")
mcl_decor.register_curtains("green", S("Green Curtains"), "mcl_wool:green", "wool_dark_green.png", "dark_green", "unicolor_dark_green")
mcl_decor.register_curtains("cyan", S("Cyan Curtains"), "mcl_wool:cyan", "wool_cyan.png", "cyan", "unicolor_cyan")
mcl_decor.register_curtains("blue", S("Blue Curtains"), "mcl_wool:blue", "wool_blue.png", "blue", "unicolor_blue")
mcl_decor.register_curtains("magenta", S("Magenta Curtains"), "mcl_wool:magenta", "wool_magenta.png", "magenta", "unicolor_red_violet")
mcl_decor.register_curtains("orange", S("Orange Curtains"), "mcl_wool:orange", "wool_orange.png", "orange", "unicolor_orange")
mcl_decor.register_curtains("purple", S("Purple Curtains"), "mcl_wool:purple", "wool_violet.png", "violet", "unicolor_violet")
mcl_decor.register_curtains("brown", S("Brown Curtains"), "mcl_wool:brown", "wool_brown.png", "brown", "unicolor_dark_orange")
mcl_decor.register_curtains("pink", S("Pink Curtains"), "mcl_wool:pink", "wool_pink.png", "pink", "unicolor_light_red")
mcl_decor.register_curtains("lime", S("Lime Curtains"), "mcl_wool:lime", "mcl_wool_lime.png", "green", "unicolor_green")
mcl_decor.register_curtains("light_blue", S("Light Blue Curtains"), "mcl_wool:light_blue", "mcl_wool_light_blue.png", "lightblue", "unicolor_light_blue")

--- Dyed Planks ---
mcl_decor.register_dyed_planks("white", S("White Planks"), "#EDEDED", "white", "unicolor_white")
mcl_decor.register_dyed_planks("grey", S("Grey Planks"), "#5F5F5F", "dark_grey", "unicolor_darkgrey")
mcl_decor.register_dyed_planks("silver", S("Light Grey Planks"), "#8C8C8C", "grey", "unicolor_grey")
mcl_decor.register_dyed_planks("black", S("Black Planks"), "#030303", "black", "unicolor_black")
mcl_decor.register_dyed_planks("red", S("Red Planks"), "#BD0000", "red", "unicolor_red")
mcl_decor.register_dyed_planks("yellow", S("Yellow Planks"), "#EBD800", "yellow", "unicolor_yellow")
mcl_decor.register_dyed_planks("green", S("Green Planks"), "#086400", "dark_green", "unicolor_dark_green")
mcl_decor.register_dyed_planks("cyan", S("Cyan Planks"), "#00C4B4", "cyan", "unicolor_cyan")
mcl_decor.register_dyed_planks("blue", S("Blue Planks"), "#0B1E80", "blue", "unicolor_blue")
mcl_decor.register_dyed_planks("magenta", S("Magenta Planks"), "#954395", "magenta", "unicolor_red_violet")
mcl_decor.register_dyed_planks("orange", S("Orange Planks"), "#E68200", "orange", "unicolor_orange")
mcl_decor.register_dyed_planks("purple", S("Purple Planks"), "#461A6D", "violet", "unicolor_violet")
mcl_decor.register_dyed_planks("brown", S("Brown Planks"), "#432209", "brown", "unicolor_dark_orange")
mcl_decor.register_dyed_planks("pink", S("Pink Planks"), "#ED9BB4", "pink", "unicolor_light_red")
mcl_decor.register_dyed_planks("lime", S("Lime Planks"), "#B3DF86", "green", "unicolor_green")
mcl_decor.register_dyed_planks("light_blue", S("Light Blue Planks"), "#72A4D4", "lightblue", "unicolor_light_blue")
