-- mcl_decor/api.lua

local S = minetest.get_translator(minetest.get_current_modname())

-- originally from the ts_furniture mod (which is from cozy) by Thomas--S // <https://github.com/minetest-mods/ts_furniture/>
mcl_decor.sit = function(pos, _, player)
	local name = player:get_player_name()
	local ppos = player:get_pos()
	if not player or not name then
		return false
	end
	if not mcl_player.player_attached[name] then
		-- check distance
		if vector.distance(pos, ppos) > 3 then
			mcl_title.set(player, "actionbar", {text=S("You can't sit, the block's too far away!"), color="white", stay=60})
			return
		end
		-- check movement
		if vector.length(player:get_velocity() or player:get_player_velocity()) > 0.125 then
			mcl_title.set(player, "actionbar", {text=S("You have to stop moving before sitting down!"), color="white", stay=60})
			return
		end
		-- check if occupied
		for _, other_pos in pairs(mcl_decor.pos) do
			if vector.distance(pos, other_pos) < 0.1 then
				mcl_title.set(player, "actionbar", {text=S("This block is already occupied!")})
				return
			end
		end

		player:move_to(pos)
		player:set_eye_offset({x = 0, y = -7, z = 0}, {x = 0, y = 0, z = 0})
		playerphysics.add_physics_factor(player, "speed", "mcl_decor:attached", 0)
		playerphysics.add_physics_factor(player, "jump", "mcl_decor:attached", 0)

		mcl_player.player_attached[name] = true

		mcl_decor.pos[name] = pos

		minetest.after(0.1, function()
			if player then
				mcl_player.player_set_animation(player, "sit" , 30)
			end
		end)
	else
		mcl_decor.pos[name] = nil
		mcl_decor.stand(player, name)
	end
end

mcl_decor.up = function(_, _, player)
	local name = player:get_player_name()
	if not player or not name then
		return false
	end
	mcl_decor.pos[name] = nil
	if mcl_player.player_attached[name] then
		mcl_decor.stand(player, name)
	end
end

mcl_decor.stand = function(player, name)
	player:set_eye_offset({x = 0, y = 0, z = 0}, {x = 0, y = 0, z = 0})
	playerphysics.remove_physics_factor(player, "speed", "mcl_decor:attached")
	playerphysics.remove_physics_factor(player, "jump", "mcl_decor:attached")
	mcl_player.player_attached[name] = false
	mcl_player.player_set_animation(player, "stand", 30)
end

if not minetest.get_modpath("mcl_cozy") then
	minetest.register_globalstep(function(dtime)
		local players = minetest.get_connected_players()
		for i = 1, #players do
			local player = players[i]
			local name = player:get_player_name()
			local ctrl = player:get_player_control()
			if mcl_player.player_attached[name] and not player:get_attach() and
			(ctrl.up or ctrl.down or ctrl.left or ctrl.right or ctrl.jump or ctrl.sneak) then
				mcl_decor.up(nil, nil, player)
			end
		end
	end)
end

