-- mcl_decor/src/wooden/slab_tables.lua

function mcl_decor.register_slab_table(name, desc, material, tiles, flammable)
	local group
	if flammable == nil then
		group = {handy=1, axey=1, attached_node=1, material_wood=1, deco_block=1, slab_table=1, flammable=-1}
	else
		group = {handy=1, axey=1, attached_node=1, material_wood=1, deco_block=1, slab_table=1}
	end

	-- similar hack to the one present in chairs_tables.lua, but makes more sense for slab tables for obv reasons ;)
	group.slab_top = 1

	core.register_node("mcl_decor:"..name.."_stable", {
		description = desc,
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{-0.125, -0.5, -0.125, 0.125, 0, 0.125},
				{-0.5, 0, -0.5, 0.5, 0.5, 0.5},
			},
		},
		tiles = {tiles},
		is_ground_content = false,
		paramtype = "light",
		stack_max = 64,
		sunlight_propagates = true,
		groups = group,
		_mcl_hardness = 2,
		_mcl_blast_resistance = 3,
		sounds = mcl_sounds.node_sound_wood_defaults(),
	})
	core.register_craft({
		output = "mcl_decor:"..name.."_stable".." 3",
		recipe = {
			{material, material, material},
			{"", "mcl_core:stick", ""}
		}
	})
	core.register_craft({
		type = "fuel",
		recipe = "mcl_decor:"..name.."_stable",
		burntime = 10,
	})
	-- VL-only: <https://git.minetest.land/VoxeLibre/VoxeLibre/commit/257e5f993b075ce252804eb100155d6099ce146b>
	if core.global_exists("mcl_lanterns") and mcl_lanterns.add_allowed_non_solid_nodes_floor then
		-- interestingly, top slabs in VL don't act this way...
		mcl_lanterns.add_allowed_non_solid_nodes_floor("mcl_decor:"..name.."_stable")
	end
end
