local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)
local S = core.get_translator(modname)

local hammer_tt = S("Can crush blocks") .. "\n" .. S("Increased knockback")
local hammer_longdesc = S(
"Hammers are great in melee combat, as they deal high damage with increased knockback and can endure countless battles. Hammers can also be used to crush things.")
local hammer_use = S("To crush a block, dig the block with the hammer. This only works with some blocks.")

local spear_tt = S("Reaches farther") .. "\n" .. S("Can be thrown")
local spear_longdesc = S("Spears are great in melee combat, as they have an increased reach. They can also be thrown.")
local spear_use = S("To throw a spear, hold it in your hand, then hold use (rightclick) in the air.")

local wield_scale = mcl_vars.tool_wield_scale

local uses = {
	emerald = 1796,
}
local materials = {
	emerald = "mcl_core:emerald",
}

local SPEAR_RANGE = 4.5

local function spear_on_place(itemstack, user, pointed_thing)
	if pointed_thing.type == "node" then
		-- Call on_rightclick if the pointed node defines it
		local node = core.get_node(pointed_thing.under)
		if user and not user:get_player_control().sneak then
			if core.registered_nodes[node.name] and core.registered_nodes[node.name].on_rightclick then
				return core.registered_nodes[node.name].on_rightclick(pointed_thing.under, node, user, itemstack) or itemstack
			end
		end
	end

	itemstack:get_meta():set_int("active", 1)
	return itemstack
end

-- Hammer and Spear
core.register_tool("mcl_emerald_stuff:hammer", {
	description = S("Emerald Hammer"),
	_tt_help = hammer_tt,
	_doc_items_longdesc = hammer_longdesc,
	_doc_items_usagehelp = hammer_use,
	inventory_image = "mcl_emerald_stuff_hammer.png",
	wield_scale = wield_scale,
	groups = { weapon = 1, hammer = 1, dig_speed_class = 2, enchantability = 10 },
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level = 5,
		damage_groups = { fleshy = 8 },
		punch_attack_uses = uses.emerald,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = materials.emerald,
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 4, level = 5, uses = uses.emerald }
	},
	_mcl_upgradable = true,
	_mcl_upgrade_item = "vl_weaponry:hammer_netherite"
})

core.register_tool("mcl_emerald_stuff:spear", {
	description = S("Emerald Spear"),
	_tt_help = spear_tt,
	_doc_items_longdesc = spear_longdesc,
	_doc_items_usagehelp = spear_use,
	inventory_image = "mcl_emerald_stuff_spear.png",
	wield_scale = wield_scale,
	on_place = spear_on_place,
	on_secondary_use = spear_on_place,
	groups = { weapon = 1, weapon_ranged = 1, spear = 1, dig_speed_class = 3, enchantability = 10 },
	range = SPEAR_RANGE,
	tool_capabilities = {
		full_punch_interval = 0.75,
		max_drop_level = 5,
		damage_groups = { fleshy = 7 },
		punch_attack_uses = uses.emerald,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = materials.emerald,
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		swordy = { speed = 2, level = 1, uses = uses.emerald },
		swordy_cobweb = { speed = 2, level = 1, uses = uses.emerald }
	},
	touch_interaction = "short_dig_long_place",
	_mcl_spear_thrown_damage = 8,
	_mcl_upgradable = true,
	_mcl_upgrade_item = "vl_weaponry:spear_netherite"
})


-- Crafting recipes
local s = "mcl_core:stick"
local b = ""
local m = "mcl_core:emerald"

core.register_craft({
	output = "mcl_emerald_stuff:hammer",
	recipe = {
		{ m, b, m },
		{ m, s, m },
		{ b, s, b },
	}
})

core.register_craft({
	output = "mcl_emerald_stuff:spear",
	recipe = {
		{ m, b, b },
		{ b, s, b },
		{ b, b, s },
	}
})

core.register_craft({
	output = "mcl_emerald_stuff:spear",
	recipe = {
		{ b, b, m },
		{ b, s, b },
		{ s, b, b },
	}
})
