local modname = minetest.get_current_modname()
local modpath = minetest.get_modpath(modname)
local S = minetest.get_translator(modname)

mcl_armor.register_set({
	name = "emerald",
	descriptions = {
		head = S("Emerald Helmet"),
		torso = S("Emerald Chestplate"),
		legs = S("Emerald Leggings"),
		feet = S("Emerald Boots"),
	},
	durability = 560,
	enchantability = 10,
	points = {
		head = 3,
		torso = 8,
		legs = 6,
		feet = 3,
	},
	toughness = 3,
	craft_material = "mcl_core:emerald",
	sound_equip = "mcl_armor_equip_diamond",
	sound_unequip = "mcl_armor_unequip_diamond",
	_mcl_upgradable = true,
	_mcl_upgrade_item_material = "_netherite",
})

core.register_craftitem("mcl_emerald_stuff:emerald_horse_armor", {
	description = S("Emerald Horse Armor"),
	_doc_items_longdesc = S("Emerald horse armor can be worn by horses to greatly increase their protection from harm."),
	_doc_items_usagehelp = S("Place it on a horse to put on the horse armor. Donkeys and mules can't wear horse armor."),
	inventory_image = "mcl_emerald_stuff_emerald_horse_armor.png",
	_horse_overlay_image = "mcl_emerald_stuff_horse_armor_emerald.png",
	sounds = {
		_mcl_armor_equip = "mcl_armor_equip_emerald",
	},
	stack_max = 1,
	groups = { horse_armor = 48 },
})
