local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)
local S = core.get_translator(modname)

-- Help texts (from mcl_tools)
local pickaxe_longdesc = S("Pickaxes are mining tools to mine hard blocks, such as stone. A pickaxe can also be used as weapon, but it is rather inefficient.")
local axe_longdesc = S("An axe is your tool of choice to cut down trees, wood-based blocks and other blocks. Axes deal a lot of damage as well, but they are rather slow.")
local sword_longdesc = S("Swords are great in melee combat, as they are fast, deal high damage and can endure countless battles. Swords can also be used to cut down a few particular blocks, such as cobwebs.")
local shovel_longdesc = S("Shovels are tools for digging coarse blocks, such as dirt, sand and gravel. They can also be used to turn grass blocks to grass paths. Shovels can be used as weapons, but they are very weak.")
local shovel_use = S("To turn a grass block into a grass path, hold the shovel in your hand, then use (rightclick) the top or side of a grass block. This only works when there's air above the grass block.")

local wield_scale = mcl_vars.tool_wield_scale

-- SmokeyDope code BEGIN (thank you SmokeyDope)

-- Axe stripping wood logic
local function make_stripped_trunk(itemstack, placer, pointed_thing)
	if pointed_thing.type ~= "node" then return end

	local node = core.get_node(pointed_thing.under)
	local noddef = core.registered_nodes[core.get_node(pointed_thing.under).name]

	if not placer:get_player_control().sneak and noddef.on_rightclick then
		return core.item_place(itemstack, placer, pointed_thing)
	end
	if core.is_protected(pointed_thing.under, placer:get_player_name()) then
		core.record_protection_violation(pointed_thing.under, placer:get_player_name())
		return itemstack
	end

	if noddef._mcl_stripped_variant == nil then
		return itemstack
	else
		core.swap_node(pointed_thing.under, {name=noddef._mcl_stripped_variant, param2=node.param2})
		if not core.is_creative_enabled(placer:get_player_name()) then
			-- Add wear (as if digging a axey node)
			local toolname = itemstack:get_name()
			local wear = mcl_autogroup.get_wear(toolname, "axey")
			itemstack:add_wear(wear)
		end
	end
	return itemstack
end

-- Shovel path making function
local make_grass_path = function(itemstack, placer, pointed_thing)
	-- Use pointed node's on_rightclick function first, if present
	local node = core.get_node(pointed_thing.under)
	if placer and not placer:get_player_control().sneak then
		if core.registered_nodes[node.name] and core.registered_nodes[node.name].on_rightclick then
			return core.registered_nodes[node.name].on_rightclick(pointed_thing.under, node, placer, itemstack) or itemstack
		end
	end

	-- Only make grass path if tool used on side or top of target node
	if pointed_thing.above.y < pointed_thing.under.y then
		return itemstack
	end

	if (core.get_item_group(node.name, "path_creation_possible") == 1) then
		local above = table.copy(pointed_thing.under)
		above.y = above.y + 1
		if core.get_node(above).name == "air" then
			if core.is_protected(pointed_thing.under, placer:get_player_name()) then
				core.record_protection_violation(pointed_thing.under, placer:get_player_name())
				return itemstack
			end

			if not core.is_creative_enabled(placer:get_player_name()) then
				-- Add wear (as if digging a shovely node)
				local toolname = itemstack:get_name()
				local wear = mcl_autogroup.get_wear(toolname, "shovely")
				itemstack:add_wear(wear)
			end
			core.sound_play({name="default_grass_footstep", gain=1}, {pos = above}, true)
			core.swap_node(pointed_thing.under, {name="mcl_core:grass_path"})
		end
	end
	return itemstack
end

-- SmokeyDope code END

-- Registering tools
core.register_tool("mcl_emerald_stuff:pick", {
	description = S("Emerald Pickaxe"),
	_doc_items_longdesc = pickaxe_longdesc,
	inventory_image = "mcl_emerald_stuff_pick.png",
	wield_scale = wield_scale,
	groups = { tool=1, pickaxe=1, dig_speed_class=6, enchantability=10 },
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level=5,
		damage_groups = {fleshy=6},
		punch_attack_uses = 898,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:emerald",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 8, level = 5, uses = 1796 }
	},
	_mcl_upgradable = true,
	_mcl_upgrade_item = "mcl_tools:pick_netherite"
})

core.register_tool("mcl_emerald_stuff:shovel", {
	description = S("Emerald Shovel"),
	_doc_items_longdesc = shovel_longdesc,
	_doc_items_usagehelp = shovel_use,
	inventory_image = "mcl_emerald_stuff_shovel.png",
	wield_scale = wield_scale,
	groups = { tool=1, shovel=1, dig_speed_class=6, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=5,
		damage_groups = {fleshy=6},
		punch_attack_uses = 898,
	},
	on_place = make_grass_path,
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:emerald",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		shovely = { speed = 8, level = 5, uses = 1796 }
	},
	_mcl_upgradable = true,
	_mcl_upgrade_item = "mcl_tools:shovel_netherite"
})

core.register_tool("mcl_emerald_stuff:axe", {
	description = S("Emerald Axe"),
	_doc_items_longdesc = axe_longdesc,
	inventory_image = "mcl_emerald_stuff_axe.png",
	wield_scale = wield_scale,
	groups = { tool=1, axe=1, dig_speed_class=6, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level=5,
		damage_groups = {fleshy=10},
		punch_attack_uses = 898,
	},
	on_place = make_stripped_trunk,
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:emerald",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		axey = { speed = 8, level = 5, uses = 1796 }
	},
	_mcl_upgradable = true,
	_mcl_upgrade_item = "mcl_tools:axe_netherite"
})

core.register_tool("mcl_emerald_stuff:sword", {
	description = S("Emerald Sword"),
	_doc_items_longdesc = sword_longdesc,
	inventory_image = "mcl_emerald_stuff_sword.png",
	wield_scale = wield_scale,
	groups = { weapon=1, sword=1, dig_speed_class=6, enchantability=10 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=5,
		damage_groups = {fleshy=8},
		punch_attack_uses = 1796,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:emerald",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		swordy = { speed = 8, level = 5, uses = 1796 },
		swordy_cobweb = { speed = 8, level = 5, uses = 1796 }
	},
	_mcl_upgradable = true,
	_mcl_upgrade_item = "mcl_tools:sword_netherite"
})

-- Registering crafts
core.register_craft({
	output = "mcl_emerald_stuff:pick",
	recipe = {
		{"mcl_core:emerald", "mcl_core:emerald", "mcl_core:emerald"},
		{"", "mcl_core:stick", ""},
		{"", "mcl_core:stick", ""},
	}
})

core.register_craft({
	output = "mcl_emerald_stuff:shovel",
	recipe = {
		{"mcl_core:emerald"},
		{"mcl_core:stick"},
		{"mcl_core:stick"},
	}
})

core.register_craft({
	output = "mcl_emerald_stuff:axe",
	recipe = {
		{"mcl_core:emerald", "mcl_core:emerald"},
		{"mcl_core:emerald", "mcl_core:stick"},
		{"", "mcl_core:stick"},
	}
})

core.register_craft({
	output = "mcl_emerald_stuff:axe",
	recipe = {
		{"mcl_core:emerald", "mcl_core:emerald"},
		{"mcl_core:stick", "mcl_core:emerald"},
		{"mcl_core:stick", ""},
	}
})

core.register_craft({
	output = "mcl_emerald_stuff:sword",
	recipe = {
		{"mcl_core:emerald"},
		{"mcl_core:emerald"},
		{"mcl_core:stick"},
	}
})

-- hoe code used under GPL-3.0-only from mcl_copper_stuff
minetest.register_craft({
	output = "mcl_emerald_stuff:emerald_hoe",
	recipe = {
		{"mcl_core:emerald", "mcl_core:emerald"},
		{"", "mcl_core:stick"},
		{"", "mcl_core:stick"},
	}
})
local hoe_tt = S("Turns block into farmland")
local hoe_longdesc = S("Hoes are essential tools for growing crops. They are used to create farmland in order to plant seeds on it. Hoes can also be used as very weak weapons in a pinch.")
local hoe_usagehelp = S("Use the hoe on a cultivatable block (by rightclicking it) to turn it into farmland. Dirt, grass blocks and grass paths are cultivatable blocks. Using a hoe on coarse dirt turns it into dirt.")

local function create_soil(pos, inv)
	if pos == nil then
		return false
	end
	local node = minetest.get_node(pos)
	local name = node.name
	local above = minetest.get_node({x=pos.x, y=pos.y+1, z=pos.z})
	if minetest.get_item_group(name, "cultivatable") == 2 then
		if above.name == "air" then
			node.name = "mcl_farming:soil"
			minetest.set_node(pos, node)
			minetest.sound_play("default_dig_crumbly", { pos = pos, gain = 0.5 }, true)
			return true
		end
	elseif minetest.get_item_group(name, "cultivatable") == 1 then
		if above.name == "air" then
			node.name = "mcl_core:dirt"
			minetest.set_node(pos, node)
			minetest.sound_play("default_dig_crumbly", { pos = pos, gain = 0.6 }, true)
			return true
		end
	end
	return false
end

local hoe_on_place_function = function(wear_divisor)
	return function(itemstack, user, pointed_thing)
		-- Call on_rightclick if the pointed node defines it
		local node = minetest.get_node(pointed_thing.under)
		if user and not user:get_player_control().sneak then
			if minetest.registered_nodes[node.name] and minetest.registered_nodes[node.name].on_rightclick then
				return minetest.registered_nodes[node.name].on_rightclick(pointed_thing.under, node, user, itemstack) or itemstack
			end
		end
		if minetest.is_protected(pointed_thing.under, user:get_player_name()) then
			minetest.record_protection_violation(pointed_thing.under, user:get_player_name())
			return itemstack
		end
		if create_soil(pointed_thing.under, user:get_inventory()) then
			if not minetest.is_creative_enabled(user:get_player_name()) then
				itemstack:add_wear(65535/wear_divisor)
			end
			return itemstack
		end
	end
end

local uses = 1796

minetest.register_tool("mcl_emerald_stuff:emerald_hoe", {
	description = S("Emerald Hoe"),
	_tt_help = hoe_tt.."\n"..S("Uses: @1", uses),
	_doc_items_longdesc = hoe_longdesc,
	_doc_items_usagehelp = hoe_usagehelp,
	inventory_image = "mcl_emerald_stuff_hoe.png",
	wield_scale = mcl_vars.tool_wield_scale,
	on_place = hoe_on_place_function(uses),
	groups = { tool=1, hoe=1, enchantability=9 },
	tool_capabilities = {
		full_punch_interval = 1,
		damage_groups = { fleshy = 1, },
		punch_attack_uses = uses,
	},
	_repair_material = "mcl_core:emerald",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		hoey = { speed = 10, level = 2, uses = uses }
	},
})
