local S = minetest.get_translator("vl_soaking")

local STEP_INTERVAL = tonumber(minetest.settings:get("vl_soaking_step_interval")) or 1.2
local SOAK_DAMAGE = tonumber(minetest.settings:get("vl_soaking_damage")) or 1

minetest.register_craftitem("vl_soaking:umbrella", {
	description = S("Umbrella"),
	_tt_help = minetest.colorize(mcl_colors.GREEN, S("Protects you from rain while wielding it")),
	_doc_items_longdesc = S("An umbrella is an item that prevents you from soaking under rain."),
	_doc_items_usagehelp = S("Umbrella only works while you hold it in your hand, either your main hand or offhand."),
	inventory_image = "vl_soaking_umbrella.png",
	wield_scale = mcl_vars.tool_wield_scale,
	_mcl_toollike_wield = true,
	stack_max = 1,
	groups = {tool = 1, offhand_item = 1},
})

minetest.register_craft({
	output = "vl_soaking:umbrella",
	recipe = {
		{"group:wool", "group:wool",          "group:wool"},
		{"",           "mcl_core:iron_ingot", ""          },
		{"",           "mcl_core:stick",      ""          }
	},
})

local etime = 0
minetest.register_globalstep(function(dtime)
	-- don't check all the time
	etime = etime + dtime
	if etime < STEP_INTERVAL then return end
	etime = 0

	local connected_players = minetest.get_connected_players()
	for i=1,#connected_players do
		local player = connected_players[i]
		local pos = player:get_pos()
		local inv = player:get_inventory()
		if inv:get_size("armor") == 0 then return end

		local rain = (mcl_weather.rain.raining and mcl_weather.is_outdoor(pos))
		local bare = (
			-- (helmet is none or not leather) or
			(minetest.get_item_group(inv:get_stack("armor", 2):get_name(), "armor_leather") == 0) or
			-- (chestplate is none or not leather)
			(minetest.get_item_group(inv:get_stack("armor", 3):get_name(), "armor_leather") == 0)
		)
		local no_umbrella = (
			-- check wielded item (is not umbrella)
			(player:get_wielded_item():get_name() ~= "vl_soaking:umbrella") and
			-- check offhand item (is not umbrella)
			(inv:get_stack("offhand", 1):get_name() ~= "vl_soaking:umbrella")
		)
		if rain and bare and no_umbrella then
			mcl_util.deal_damage(player, SOAK_DAMAGE)
		end
	end
end)
