# Migrating from MineClone 2 to Mineclonia
This document describes things to be aware of when migrating worlds from
MineClone 2 to Mineclonia. Currently migrating from MineClone 2 to Mineclonia is
fully supported but not the other way around. If you want to try Mineclonia and
have the option of going back, then we would advice you to make a backup of your
world first.

This revision of the document describes the compatibility between Mineclonia
0.83.0 and MineClone 2 0.83.1.

## World depth increase
In Mineclonia 0.83.0 the world depth was increased to -128 nodes (from -64
nodes) to match Minecraft 1.18. Mineclonia will automatically update worlds from
MineClone 2 and older Mineclonia versions by replacing the bedrock layer and
void underneath with newly generated mapchunks. This means that migrated worlds
will no longer be compatible with MineClone 2 until they do the same.

## Feature differences
This section describes feature differences between MineClone 2 and Mineclonia
which can cause small incompatibilities.

### MineClone 2 features not in Mineclonia
Mineclonia does not have the following items in MineClone 2:

- Hamburgers

Such items will become unknown items when a MineClone 2 world is migrated to
Mineclonia.

### Nether portal differences
In Mineclonia 0.82.0 nether portals were reworked. Their biggest update was
regarding how they are linked together. Now they will link to each other by
distance according to the rules which are described
[here](https://minecraft.fandom.com/wiki/Nether_portal#Portal_linkage_between_Overworld_and_Nether)
on the Minecraft Wiki. This allows for constructing nether portals in both the
Nether and the Overworld and have them work together, something not possible in
MineClone 2. In MineClone 2 a player constructed nether portal will only ever
link with an autogenerated nether portal.

Nether portals built in MineClone 2 will be automatically updated to work in
Mineclonia with the new linking system. Nether portals will still function if
the world is migrated back to MineClone 2 but then they will not lead to the
same locations anymore.
