# Migrating from MineClone 2 to Mineclonia
This document describes things to be aware of when migrating worlds from
MineClone 2 to Mineclonia. Currently migrating from MineClone 2 to Mineclonia is
fully supported but not the other way around. If you want to try Mineclonia and
have the option of going back, then we recommend taking a backup of your world
first.

The current revision of this document describes the compatibility between
Mineclonia 0.83.1 and MineClone 2 0.83.1.

## Overworld depth increase
In Mineclonia 0.83.0 the overworld depth was increased from 64 to 128 nodes to
match Minecraft 1.18. Mineclonia will automatically update worlds from MineClone
2 and older Mineclonia versions by replacing the bedrock layer and void
underneath with newly generated mapchunks. This means that migrated worlds will
no longer be compatible with MineClone 2 until they also increase the overworld
depth.

## Feature differences
This section describes feature differences between MineClone 2 and Mineclonia
which can cause small incompatibilities.

### MineClone 2 features not in Mineclonia
Mineclonia does not have the following items in MineClone 2:

- Hamburgers

Such items will become unknown items when a MineClone 2 world is migrated to
Mineclonia.

### Nether portal differences
In Mineclonia 0.82.0 nether portals were reworked. The biggest update was
regarding how they link with each other. In Mineclonia nether portals link with
each other according to distance using the rules described
[here](https://minecraft.fandom.com/wiki/Nether_portal#Portal_linkage_between_Overworld_and_Nether).
This allows for constructing nether portals in both the Nether and the Overworld
and having them work together, something not possible in MineClone 2. In
MineClone 2 a player-constructed nether portal will only link with an
autogenerated nether portal.

Nether portals built in MineClone 2 will automatically be updated to work in
Mineclonia. Nether portals will still function if a Mineclonia world is migrated
to MineClone 2, but then they will not lead to the same locations anymore.
