local mg_seed = minetest.get_mapgen_setting("seed")

local mod_mcl_structures = minetest.get_modpath("mcl_structures")
local mod_mcl_core = minetest.get_modpath("mcl_core")
local mod_mcl_mushrooms = minetest.get_modpath("mcl_mushrooms")
local mod_mcl_crimson = minetest.get_modpath("mcl_crimson")
local mod_mcl_blackstone = minetest.get_modpath("mcl_blackstone")
local mod_mcl_mangrove = minetest.get_modpath("mcl_mangrove")
local mod_cherry_blossom = minetest.get_modpath("mcl_cherry_blossom")

local deco_id_chorus_plant

local beach_skycolor = "#78A7FF" -- This is the case for all beach biomes except for the snowy ones! Those beaches will have their own colour instead of this one.
local ocean_skycolor = "#7BA4FF" -- This is the case for all ocean biomes except for non-deep frozen oceans! Those oceans will have their own colour instead of this one.
local overworld_fogcolor = "#C0D8FF"

--local nether_skycolor = "#6EB1FF"

--local end_fogcolor = "#A080A0"
--local end_skycolor = "#000000"

mcl_biomes = {}

--
-- Register biomes
--

local OCEAN_MIN = -15
local DEEP_OCEAN_MAX = OCEAN_MIN - 1
local DEEP_OCEAN_MIN = -31

local stonelike = {"mcl_core:stone", "mcl_core:diorite", "mcl_core:andesite", "mcl_core:granite"}
--[[ Special biome field: _mcl_biome_type:
Rough categorization of biomes: One of "snowy", "cold", "medium" and "hot"
Based off <https://minecraft.gamepedia.com/Biomes> ]]

local function register_classic_superflat_biome()
	-- Classic Superflat: bedrock (not part of biome), 2 dirt, 1 grass block
	minetest.register_biome({
		name = "flat",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_stone = "mcl_core:dirt",
		y_min = mcl_vars.mg_overworld_min - 512,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 50,
		heat_point = 50,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 0,
		_mcl_skycolor = "#78A7FF",
		_mcl_fogcolor = overworld_fogcolor
	})
end

-- All mapgens except flat and singlenode
local function register_biomes()
	--[[ OVERWORLD ]]

	--[[ These biomes try to resemble MC as good as possible. This means especially the floor cover and
	the type of plants and structures (shapes might differ). The terrain itself will be of course different
	and depends on the mapgen.
	Important: MC also takes the terrain into account while MT biomes don't care about the terrain at all
	(except height).
	MC has many “M” and “Hills” variants, most of which only differ in terrain compared to their original
	counterpart.
	In MT, any biome can occour in any terrain, so these variants are implied and are therefore
	not explicitly implmented in MCL2. “M” variants are only included if they have another unique feature,
	such as a different land cover.
	In MCL2, the MC Overworld biomes are split in multiple more parts (stacked by height):
	* The main part, this represents the land. It begins at around sea level and usually goes all the way up
	* _ocean: For the area covered by ocean water. The y_max may vary for various beach effects.
			  Has sand or dirt as floor.
	* _deep_ocean: Like _ocean, but deeper and has gravel as floor
	* _underground:
	* Other modifiers: Some complex biomes require more layers to improve the landscape.

	The following naming conventions apply:
	* The land biome name is equal to the MC biome name, as of Minecraft 1.11 (in camel case)
	* Height modifiers and sub-biomes are appended with underscores and in lowercase. Example: “_ocean”
	* Non-MC biomes are written in lowercase
	* MC dimension biomes are named after their MC dimension

	Intentionally missing biomes:
	* River (generated by valleys and v7)
	* Frozen River (generated by valleys and v7)
	* Hills biomes (shape only)
	* Plateau (shape only)
	* Plateau M (shape only)
	* Cold Taiga M (mountain only)
	* Taiga M (mountain only)
	* Roofed Forest M (mountain only)
	* Swampland M (mountain only)
	* Extreme Hills Edge (unused in MC)

	TODO:
	* Better beaches
	* Improve Extreme Hills M
	* Desert M

	]]

	-- List of Overworld biomes without modifiers.
	-- IMPORTANT: Don't forget to add new Overworld biomes to this list!
	local overworld_biomes = {
		"IcePlains",
		"IcePlainsSpikes",
		"ColdTaiga",
		"ExtremeHills",
		"ExtremeHillsM",
		"ExtremeHills+",
		"Taiga",
		"MegaTaiga",
		"MegaSpruceTaiga",
		"StoneBeach",
		"Plains",
		"SunflowerPlains",
		"Forest",
		"FlowerForest",
		"BirchForest",
		"BirchForestM",
		"RoofedForest",
		"Swampland",
		"Jungle",
		"JungleM",
		"JungleEdge",
		"JungleEdgeM",
		"BambooJungle",
		"MushroomIsland",
		"Desert",
		"Savanna",
		"SavannaM",
		"Mesa",
		"MesaBryce",
		"MesaPlateauF",
		"MesaPlateauFM",
		"MangroveSwamp",
	}


	-- Ice Plains Spikes (rare)
	minetest.register_biome({
		name = "IcePlainsSpikes",
		node_top = "mcl_core:snowblock",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 2,
		node_water_top = "mcl_core:ice",
		depth_water_top = 1,
		node_river_water = "mcl_core:ice",
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 24,
		heat_point = -5,
		_mcl_biome_type = "snowy",
		_mcl_palette_index = 2,
		_mcl_skycolor = "#7FA1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "IcePlainsSpikes_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 2,
		node_filler = "mcl_core:gravel",
		depth_filler = 3,
		node_river_water = "mcl_core:ice",
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 24,
		heat_point = -5,
		_mcl_biome_type = "snowy",
		_mcl_palette_index = 2,
		_mcl_skycolor = "#7FA1FF",
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Cold Taiga
	minetest.register_biome({
		name = "ColdTaiga",
		node_dust = "mcl_core:snow",
		node_top = "mcl_core:dirt_with_grass_snow",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 3,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 58,
		heat_point = 8,
		_mcl_biome_type = "snowy",
		_mcl_palette_index = 3,
		_mcl_skycolor = "#839EFF",
		_mcl_fogcolor = overworld_fogcolor
	})

	-- A cold beach-like biome, implemented as low part of Cold Taiga
	minetest.register_biome({
		name = "ColdTaiga_beach",
		node_dust = "mcl_core:snow",
		node_top = "mcl_core:sand",
		depth_top = 2,
		node_water_top = "mcl_core:ice",
		depth_water_top = 1,
		node_filler = "mcl_core:sandstone",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = 2,
		humidity_point = 58,
		heat_point = 8,
		_mcl_biome_type = "snowy",
		_mcl_palette_index = 3,
		_mcl_skycolor = "#7FA1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	-- Water part of the beach. Added to prevent snow being on the ice.
	minetest.register_biome({
		name = "ColdTaiga_beach_water",
		node_top = "mcl_core:sand",
		depth_top = 2,
		node_water_top = "mcl_core:ice",
		depth_water_top = 1,
		node_filler = "mcl_core:sandstone",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = -4,
		y_max = 0,
		humidity_point = 58,
		heat_point = 8,
		_mcl_biome_type = "snowy",
		_mcl_palette_index = 3,
		_mcl_skycolor = "#7FA1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "ColdTaiga_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = -5,
		humidity_point = 58,
		heat_point = 8,
		vertical_blend = 1,
		_mcl_biome_type = "snowy",
		_mcl_palette_index = 3,
		_mcl_skycolor = "#7FA1FF",
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Mega Pine Taiga
	minetest.register_biome({
		name = "MegaTaiga",
		node_top = "mcl_core:podzol",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 76,
		heat_point = 10,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 4,
		_mcl_skycolor = "#7CA3FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MegaTaiga_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 76,
		heat_point = 10,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 4,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Mega Spruce Taiga
	minetest.register_biome({
		name = "MegaSpruceTaiga",
		node_top = "mcl_core:podzol",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 100,
		heat_point = 8,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 5,
		_mcl_skycolor = "#7DA3FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MegaSpruceTaiga_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 100,
		heat_point = 8,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 5,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Extreme Hills
	-- Sparsely populated grasslands with little tallgras and trees.
	minetest.register_biome({
		name = "ExtremeHills",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 4,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 4,
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 10,
		heat_point = 45,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 6,
		_mcl_skycolor = "#7DA2FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "ExtremeHills_beach",
		node_top = "mcl_core:sand",
		depth_top = 2,
		depth_water_top = 1,
		node_filler = "mcl_core:sandstone",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 4,
		y_min = -4,
		y_max = 3,
		humidity_point = 10,
		heat_point = 45,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 6,
		_mcl_skycolor = beach_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "ExtremeHills_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 4,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 4,
		y_min = OCEAN_MIN,
		y_max = -5,
		vertical_blend = 1,
		humidity_point = 10,
		heat_point = 45,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 6,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Extreme Hills M
	-- Just gravel.
	minetest.register_biome({
		name = "ExtremeHillsM",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 3,
		node_riverbed = "mcl_core:gravel",
		depth_riverbed = 3,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 0,
		heat_point = 25,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 7,
		_mcl_skycolor = "#7DA2FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "ExtremeHillsM_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 3,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 0,
		heat_point = 25,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 7,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Extreme Hills+
	-- This biome is near-identical to Extreme Hills on the surface but has snow-covered mountains with spruce/oak
	-- forests above a certain height.
	minetest.register_biome({
		name = "ExtremeHills+",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 4,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 4,
		y_min = 1,
		y_max = 41,
		humidity_point = 24,
		heat_point = 25,
		vertical_blend = 6,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 8,
		_mcl_skycolor = "#7DA2FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	---- Sub-biome for Extreme Hills+ for those snow forests
	minetest.register_biome({
		name = "ExtremeHills+_snowtop",
		node_dust = "mcl_core:snow",
		node_top = "mcl_core:dirt_with_grass_snow",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 4,
		node_river_water = "mcl_core:ice",
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 4,
		y_min = 42,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 24,
		heat_point = 25,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 8,
		_mcl_skycolor = "#7DA2FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "ExtremeHills+_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 4,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 4,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 24,
		heat_point = 25,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 8,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Stone beach
	-- Just stone.
	-- Not neccessarily a beach at all, only named so according to MC
	minetest.register_biome({
		name = "StoneBeach",
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 1,
		y_min = -7,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 0,
		heat_point = 8,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 9,
		_mcl_skycolor = "#7DA2FF",
		_mcl_fogcolor = overworld_fogcolor
	})

	minetest.register_biome({
		name = "StoneBeach_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 1,
		y_min = OCEAN_MIN,
		y_max = -8,
		vertical_blend = 2,
		humidity_point = 0,
		heat_point = 8,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 9,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Ice Plains
	minetest.register_biome({
		name = "IcePlains",
		node_dust = "mcl_core:snow",
		node_top = "mcl_core:dirt_with_grass_snow",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 2,
		node_water_top = "mcl_core:ice",
		depth_water_top = 2,
		node_river_water = "mcl_core:ice",
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 24,
		heat_point = 8,
		_mcl_biome_type = "snowy",
		_mcl_palette_index = 10,
		_mcl_skycolor = "#7FA1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "IcePlains_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 24,
		heat_point = 8,
		_mcl_biome_type = "snowy",
		_mcl_palette_index = 10,
		_mcl_skycolor = "#7FA1FF",
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Plains
	minetest.register_biome({
		name = "Plains",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 3,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 39,
		heat_point = 58,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 0,
		_mcl_skycolor = "#78A7FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "Plains_beach",
		node_top = "mcl_core:sand",
		depth_top = 2,
		node_filler = "mcl_core:sandstone",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 0,
		y_max = 2,
		humidity_point = 39,
		heat_point = 58,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 0,
		_mcl_skycolor = beach_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "Plains_ocean",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = -1,
		humidity_point = 39,
		heat_point = 58,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 0,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	minetest.register_biome({
		name = "CherryGrove",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 18,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 41,
		heat_point = 55,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 11,
		_mcl_skycolor = "#78A7FF",
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Sunflower Plains
	minetest.register_biome({
		name = "SunflowerPlains",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 28,
		heat_point = 45,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 11,
		_mcl_skycolor = "#78A7FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "SunflowerPlains_ocean",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 3,
		node_riverbed = "mcl_core:dirt",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 28,
		heat_point = 45,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 11,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Taiga
	minetest.register_biome({
		name = "Taiga",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 58,
		heat_point = 22,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 12,
		_mcl_skycolor = "#7DA3FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "Taiga_beach",
		node_top = "mcl_core:sand",
		depth_top = 2,
		node_filler = "mcl_core:sandstone",
		depth_filler = 1,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = 3,
		humidity_point = 58,
		heat_point = 22,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 12,
		_mcl_skycolor = beach_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "Taiga_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 58,
		heat_point = 22,
		_mcl_biome_type = "cold",
		_mcl_palette_index = 12,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Forest
	minetest.register_biome({
		name = "Forest",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 61,
		heat_point = 45,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 13,
		_mcl_skycolor = "#79A6FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "Forest_beach",
		node_top = "mcl_core:sand",
		depth_top = 2,
		node_filler = "mcl_core:sandstone",
		depth_filler = 1,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = -1,
		y_max = 0,
		humidity_point = 61,
		heat_point = 45,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 13,
		_mcl_skycolor = beach_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "Forest_ocean",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = -2,
		humidity_point = 61,
		heat_point = 45,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 13,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Flower Forest
	minetest.register_biome({
		name = "FlowerForest",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 3,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 44,
		heat_point = 32,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 14,
		_mcl_skycolor = "#79A6FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "FlowerForest_beach",
		node_top = "mcl_core:sand",
		depth_top = 2,
		node_filler = "mcl_core:sandstone",
		depth_filler = 1,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = -2,
		y_max = 2,
		humidity_point = 44,
		heat_point = 32,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 14,
		_mcl_skycolor = beach_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "FlowerForest_ocean",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = -3,
		humidity_point = 44,
		heat_point = 32,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 14,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Birch Forest
	minetest.register_biome({
		name = "BirchForest",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 78,
		heat_point = 31,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 15,
		_mcl_skycolor = "#7AA5FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "BirchForest_ocean",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 78,
		heat_point = 31,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 15,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Birch Forest M
	minetest.register_biome({
		name = "BirchForestM",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 77,
		heat_point = 27,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 16,
		_mcl_skycolor = "#7AA5FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "BirchForestM_ocean",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 77,
		heat_point = 27,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 16,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Desert
	minetest.register_biome({
		name = "Desert",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		node_stone = "mcl_core:sandstone",
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 26,
		heat_point = 94,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 17,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "Desert_ocean",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 26,
		heat_point = 94,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 17,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Roofed Forest
	minetest.register_biome({
		name = "RoofedForest",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 94,
		heat_point = 27,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 18,
		_mcl_skycolor = "#79A6FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "RoofedForest_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 94,
		heat_point = 27,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 18,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Mesa: Starts with a couple of sand-covered layers (the "sandlevel"),
	-- followed by terracotta with colorful (but imperfect) strata
	minetest.register_biome({
		name = "Mesa",
		node_top = "mcl_colorblocks:hardened_clay",
		depth_top = 1,
		node_filler = "mcl_colorblocks:hardened_clay",
		node_riverbed = "mcl_core:redsand",
		depth_riverbed = 1,
		node_stone = "mcl_colorblocks:hardened_clay",
		y_min = 11,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 0,
		heat_point = 100,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 19,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	-- Helper biome for the red sand at the bottom of Mesas.
	minetest.register_biome({
		name = "Mesa_sandlevel",
		node_top = "mcl_core:redsand",
		depth_top = 1,
		node_filler = "mcl_colorblocks:hardened_clay_orange",
		depth_filler = 3,
		node_riverbed = "mcl_core:redsand",
		depth_riverbed = 1,
		node_stone = "mcl_colorblocks:hardened_clay_orange",
		y_min = -4,
		y_max = 10,
		humidity_point = 0,
		heat_point = 100,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 19,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "Mesa_ocean",
		node_top = "mcl_core:sand",
		depth_top = 3,
		node_filler = "mcl_core:sand",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = -5,
		vertical_blend = 1,
		humidity_point = 0,
		heat_point = 100,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 19,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Mesa Bryce: Variant of Mesa, but with perfect strata and a much smaller red sand desert
	minetest.register_biome({
		name = "MesaBryce",
		node_top = "mcl_colorblocks:hardened_clay",
		depth_top = 1,
		node_filler = "mcl_colorblocks:hardened_clay",
		node_riverbed = "mcl_colorblocks:hardened_clay",
		depth_riverbed = 1,
		node_stone = "mcl_colorblocks:hardened_clay",
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = -5,
		heat_point = 100,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 20,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MesaBryce_sandlevel",
		node_top = "mcl_core:redsand",
		depth_top = 1,
		node_filler = "mcl_colorblocks:hardened_clay_orange",
		depth_filler = 3,
		node_riverbed = "mcl_colorblocks:hardened_clay",
		depth_riverbed = 1,
		node_stone = "mcl_colorblocks:hardened_clay_orange",
		y_min = -4,
		y_max = 3,
		humidity_point = -5,
		heat_point = 100,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 20,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MesaBryce_ocean",
		node_top = "mcl_core:sand",
		depth_top = 3,
		node_filler = "mcl_core:sand",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = -5,
		vertical_blend = 1,
		humidity_point = -5,
		heat_point = 100,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 20,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})



	-- Mesa Plateau F
	-- Identical to Mesa below Y=30. At Y=30 and above there is a "dry" oak forest
	minetest.register_biome({
		name = "MesaPlateauF",
		node_top = "mcl_colorblocks:hardened_clay",
		depth_top = 1,
		node_filler = "mcl_colorblocks:hardened_clay",
		node_riverbed = "mcl_core:redsand",
		depth_riverbed = 1,
		node_stone = "mcl_colorblocks:hardened_clay",
		y_min = 11,
		y_max = 29,
		humidity_point = 0,
		heat_point = 60,
		vertical_blend = 0, -- we want a sharp transition
		_mcl_biome_type = "hot",
		_mcl_palette_index = 21,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	-- The oak forest plateau of this biome.
	-- This is a plateau for grass blocks, dry shrubs, tall grass, coarse dirt and oaks.
	-- Strata don't generate here.
	minetest.register_biome({
		name = "MesaPlateauF_grasstop",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 1,
		node_riverbed = "mcl_core:redsand",
		depth_riverbed = 1,
		node_stone = "mcl_colorblocks:hardened_clay",
		y_min = 30,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 0,
		heat_point = 60,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 21,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MesaPlateauF_sandlevel",
		node_top = "mcl_core:redsand",
		depth_top = 2,
		node_filler = "mcl_colorblocks:hardened_clay_orange",
		depth_filler = 3,
		node_riverbed = "mcl_core:redsand",
		depth_riverbed = 1,
		node_stone = "mcl_colorblocks:hardened_clay_orange",
		y_min = -5,
		y_max = 10,
		humidity_point = 0,
		heat_point = 60,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 21,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MesaPlateauF_ocean",
		node_top = "mcl_core:sand",
		depth_top = 3,
		node_filler = "mcl_core:sand",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = -6,
		vertical_blend = 1,
		humidity_point = 0,
		heat_point = 60,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 21,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Mesa Plateau FM
	-- Dryer and more "chaotic"/"weathered down" variant of MesaPlateauF:
	-- oak forest is less dense, more coarse dirt, more erratic terrain, vertical blend, more red sand layers,
	-- red sand as ores, red sandstone at sandlevel
	minetest.register_biome({
		name = "MesaPlateauFM",
		node_top = "mcl_colorblocks:hardened_clay",
		depth_top = 1,
		node_filler = "mcl_colorblocks:hardened_clay",
		node_riverbed = "mcl_core:redsand",
		depth_riverbed = 2,
		node_stone = "mcl_colorblocks:hardened_clay",
		y_min = 12,
		y_max = 29,
		humidity_point = -5,
		heat_point = 60,
		vertical_blend = 5,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 22,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	-- Grass plateau
	minetest.register_biome({
		name = "MesaPlateauFM_grasstop",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:coarse_dirt",
		depth_filler = 2,
		node_riverbed = "mcl_core:redsand",
		depth_riverbed = 1,
		node_stone = "mcl_colorblocks:hardened_clay",
		y_min = 30,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = -5,
		heat_point = 60,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 22,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MesaPlateauFM_sandlevel",
		node_top = "mcl_core:redsand",
		depth_top = 3,
		node_filler = "mcl_colorblocks:hardened_clay_orange",
		depth_filler = 3,
		node_riverbed = "mcl_core:redsand",
		depth_riverbed = 2,
		node_stone = "mcl_colorblocks:hardened_clay",
		-- red sand has wider reach than in other mesa biomes
		y_min = -7,
		y_max = 11,
		humidity_point = -5,
		heat_point = 60,
		vertical_blend = 4,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 22,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MesaPlateauFM_ocean",
		node_top = "mcl_core:sand",
		depth_top = 3,
		node_filler = "mcl_core:sand",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 3,
		y_min = OCEAN_MIN,
		y_max = -8,
		vertical_blend = 2,
		humidity_point = -5,
		heat_point = 60,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 22,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Savanna
	minetest.register_biome({
		name = "Savanna",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 36,
		heat_point = 79,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 1,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "Savanna_beach",
		node_top = "mcl_core:sand",
		depth_top = 3,
		node_filler = "mcl_core:sandstone",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = -1,
		y_max = 0,
		humidity_point = 36,
		heat_point = 79,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 1,
		_mcl_skycolor = beach_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "Savanna_ocean",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = -2,
		humidity_point = 36,
		heat_point = 79,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 1,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Savanna M
	-- Changes to Savanna: Coarse Dirt. No sand beach. No oaks.
	-- Otherwise identical to Savanna
	minetest.register_biome({
		name = "SavannaM",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:coarse_dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 48,
		heat_point = 100,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 23,
		_mcl_skycolor = "#6EB1FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "SavannaM_ocean",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 48,
		heat_point = 100,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 23,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Jungle
	minetest.register_biome({
		name = "Jungle",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 88,
		heat_point = 81,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 24,
		_mcl_skycolor = "#77A8FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "Jungle_shore",
		node_top = "mcl_core:dirt",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = -2,
		y_max = 0,
		humidity_point = 88,
		heat_point = 81,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 24,
		_mcl_skycolor = "#77A8FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "Jungle_ocean",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = -3,
		vertical_blend = 1,
		humidity_point = 88,
		heat_point = 81,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 24,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Jungle M
	-- Like Jungle but with even more dense vegetation
	minetest.register_biome({
		name = "JungleM",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 92,
		heat_point = 81,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 25,
		_mcl_skycolor = "#77A8FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "JungleM_shore",
		node_top = "mcl_core:dirt",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = -2,
		y_max = 0,
		humidity_point = 92,
		heat_point = 81,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 25,
		_mcl_skycolor = "#77A8FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "JungleM_ocean",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = -3,
		vertical_blend = 1,
		humidity_point = 92,
		heat_point = 81,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 25,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Bamboo Jungle
	minetest.register_biome({
		name = "BambooJungle",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 90,
		heat_point = 79,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 26,
		_mcl_skycolor = "#77A8FF",
		_mcl_fogcolor = overworld_fogcolor
	})

	minetest.register_biome({
		name = "BambooJungle_ocean",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 90,
		heat_point = 79,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 26,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Jungle Edge
	minetest.register_biome({
		name = "JungleEdge",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 88,
		heat_point = 76,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 26,
		_mcl_skycolor = "#77A8FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "JungleEdge_ocean",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 2,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 88,
		heat_point = 76,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 26,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Jungle Edge M (very rare).
	-- Almost identical to Jungle Edge. Has deeper dirt. Melons spawn here a lot.
	-- This biome occours directly between Jungle M and Jungle Edge but also has a small border to Jungle.
	-- This biome is very small in general.
	minetest.register_biome({
		name = "JungleEdgeM",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 4,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		humidity_point = 90,
		heat_point = 79,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 26,
		_mcl_skycolor = "#77A8FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "JungleEdgeM_ocean",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 4,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 90,
		heat_point = 79,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 26,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Mangrove swamp
	minetest.register_biome({
		name = "MangroveSwamp",
		node_top = "mcl_mud:mud",
		depth_top = 1,
		node_filler = "mcl_mud:mud",
		depth_filler = 3,
		node_riverbed = "mcl_core:dirt",
		depth_riverbed = 2,
		y_min = 1,
		-- Note: Limited in height!
		y_max = 27,
		humidity_point = 95,
		heat_point = 94,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 27,
		_mcl_skycolor = "#78A7FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MangroveSwamp_shore",
		node_top = "mcl_mud:mud",
		depth_top = 1,
		node_filler = "mcl_mud:mud",
		depth_filler = 3,
		node_riverbed = "mcl_core:dirt",
		depth_riverbed = 2,
		y_min = -5,
		y_max = 0,
		humidity_point = 95,
		heat_point = 94,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 27,
		_mcl_skycolor = "#78A7FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MangroveSwamp_ocean",
		node_top = "mcl_core:dirt",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:gravel",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = -6,
		vertical_blend = 1,
		humidity_point = 95,
		heat_point = 94,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 27,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})
	-- Swampland
	minetest.register_biome({
		name = "Swampland",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		-- Note: Limited in height!
		y_max = 23,
		humidity_point = 90,
		heat_point = 50,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 28,
		_mcl_skycolor = "#78A7FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "Swampland_shore",
		node_top = "mcl_core:dirt",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = -5,
		y_max = 0,
		humidity_point = 90,
		heat_point = 50,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 28,
		_mcl_skycolor = "#78A7FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "Swampland_ocean",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = -6,
		vertical_blend = 1,
		humidity_point = 90,
		heat_point = 50,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 28,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	-- Mushroom Island / Mushroom Island Shore (rare)
	-- Not neccessarily an island at all, only named after Minecraft's biome
	minetest.register_biome({
		name = "MushroomIsland",
		node_top = "mcl_core:mycelium",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 4,
		-- Note: Limited in height!
		y_max = 20,
		vertical_blend = 1,
		humidity_point = 106,
		heat_point = 50,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 29,
		_mcl_skycolor = "#77A8FF",
		_mcl_fogcolor = overworld_fogcolor
	})

	minetest.register_biome({
		name = "MushroomIslandShore",
		node_top = "mcl_core:mycelium",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = 1,
		y_max = 3,
		humidity_point = 106,
		heat_point = 50,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 29,
		_mcl_skycolor = "#77A8FF",
		_mcl_fogcolor = overworld_fogcolor
	})
	minetest.register_biome({
		name = "MushroomIsland_ocean",
		node_top = "mcl_core:gravel",
		depth_top = 1,
		node_filler = "mcl_core:gravel",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		depth_riverbed = 2,
		y_min = OCEAN_MIN,
		y_max = 0,
		humidity_point = 106,
		heat_point = 50,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 29,
		_mcl_skycolor = ocean_skycolor,
		_mcl_fogcolor = overworld_fogcolor
	})

	minetest.register_biome({
		name = "DeepDark",
		node_top = "mcl_sculk:sculk",
		depth_top = 1,
		node_filler = "mcl_deepslate:deepslate",
		node_riverbed = "mcl_deepslate:deepslate",
		depth_riverbed = 1,
		node_stone = "mcl_deepslate:deepslate",
		y_min = mcl_vars.mg_overworld_min,
		y_max = mcl_vars.mg_overworld_min_old,
		humidity_point = 0,
		heat_point = 60,
		vertical_blend = 8,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 21,
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = table.merge(stonelike, {"mcl_deepslate:deepslate"}),
		sidelen = 16,
		fill_ratio = 10,
		biomes = { "DeepDark" },
		y_min = mcl_vars.mg_overworld_min,
		y_max = mcl_vars.mg_overworld_min_old,
		decoration = "mcl_sculk:sculk",
		flags = "all_floors",
		param2 = 0,
	})

	minetest.register_biome({
		name = "LushCaves",
		node_top = "mcl_core:dirt_with_grass",
		depth_top = 1,
		node_filler = "mcl_core:dirt",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		node_cave_liquid = "mcl_core:water_source",
		depth_riverbed = 2,
		y_min = 2,
		y_max = 20,
		vertical_blend = 1,
		humidity_point = 83,
		heat_point = 57,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 0,
	})

	minetest.register_biome({
		name = "LushCaves_ocean",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		node_cave_liquid = "mcl_core:water_source",
		depth_riverbed = 2,
		y_min = -20,
		y_max = 0,
		vertical_blend = 1,
		humidity_point = 83,
		heat_point = 57,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 0,
	})
	minetest.register_biome({
		name = "LushCaves_underground",
		node_top = "mcl_core:sand",
		depth_top = 1,
		node_filler = "mcl_core:sand",
		depth_filler = 3,
		node_riverbed = "mcl_core:sand",
		node_cave_liquid = "mcl_core:water_source",
		depth_riverbed = 2,
		y_min = -57,
		y_max = -21,
		vertical_blend = 1,
		humidity_point = 83,
		heat_point = 57,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 0,
	})
	-- Add deep ocean and underground biomes automatically.
	for i=1, #overworld_biomes do
		local biome = overworld_biomes[i]

		-- Deep Ocean
		minetest.register_biome({
			name = biome .. "_deep_ocean",
			heat_point = minetest.registered_biomes[biome].heat_point,
			humidity_point = minetest.registered_biomes[biome].humidity_point,
			y_min = DEEP_OCEAN_MIN,
			y_max = DEEP_OCEAN_MAX,
			node_top = minetest.registered_biomes[biome.."_ocean"].node_top,
			depth_top = 2,
			node_filler = minetest.registered_biomes[biome.."_ocean"].node_filler,
			depth_filler = 3,
			node_riverbed = minetest.registered_biomes[biome.."_ocean"].node_riverbed,
			depth_riverbed = 2,
			vertical_blend = 5,
			_mcl_biome_type = minetest.registered_biomes[biome]._mcl_biome_type,
			_mcl_palette_index = minetest.registered_biomes[biome]._mcl_palette_index,
			_mcl_skycolor = ocean_skycolor,
			_mcl_fogcolor = overworld_fogcolor
		})

		-- Underground biomes are used to identify the underground and to prevent nodes from the surface
		-- (sand, dirt) from leaking into the underground.
		minetest.register_biome({
			name = biome .. "_underground",
			heat_point = minetest.registered_biomes[biome].heat_point,
			humidity_point = minetest.registered_biomes[biome].humidity_point,
			y_min = mcl_vars.mg_overworld_min_old,
			y_max = DEEP_OCEAN_MIN - 1,
			_mcl_biome_type = minetest.registered_biomes[biome]._mcl_biome_type,
			_mcl_palette_index = minetest.registered_biomes[biome]._mcl_palette_index,
			_mcl_skycolor = minetest.registered_biomes[biome]._mcl_skycolor,
			_mcl_fogcolor = minetest.registered_biomes[biome]._mcl_fogcolor,
		})
		minetest.register_biome({
			name = biome .. "_deep_underground",
			heat_point = minetest.registered_biomes[biome].heat_point,
			humidity_point = minetest.registered_biomes[biome].humidity_point,
			node_stone = "mcl_deepslate:deepslate",
			y_min = mcl_vars.mg_overworld_min,
			y_max = mcl_vars.mg_overworld_min_old,
			_mcl_biome_type = minetest.registered_biomes[biome]._mcl_biome_type,
			_mcl_palette_index = minetest.registered_biomes[biome]._mcl_palette_index,
		})

	end
end

-- Register biomes of non-Overworld biomes
local function register_dimension_biomes()
	--[[ REALMS ]]

	--[[ THE NETHER ]]
	-- the following decoration is a hack to cover exposed bedrock in netherrack - be careful not to put any ceiling decorations in a way that would apply to this (they would get generated regardless of biome)
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_core:bedrock"},
		sidelen = 16,
		fill_ratio = 10,
		y_min = mcl_vars.mg_lava_nether_max,
		y_max = mcl_vars.mg_nether_max + 15,
		height = 6,
		max_height = 10,
		decoration = "mcl_nether:netherrack",
		flags = "all_ceilings",
		param2 = 0,
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_core:bedrock"},
		sidelen = 16,
		fill_ratio = 10,
		y_min = mcl_vars.mg_nether_min - 10,
		y_max = mcl_vars.mg_lava_nether_max,
		height = 7,
		max_height = 14,
		decoration = "mcl_nether:netherrack",
		flags = "all_floors,force_placement",
		param2 = 0,
	})


	minetest.register_biome({
		name = "Nether",
		node_filler = "mcl_nether:netherrack",
		node_stone = "mcl_nether:netherrack",
		node_top = "mcl_nether:netherrack",
		node_water = "air",
		node_river_water = "air",
		node_cave_liquid = "air",
		y_min = mcl_vars.mg_nether_min,

		y_max = mcl_vars.mg_nether_max + 80,
		heat_point = 100,
		humidity_point = 0,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 17,
--		_mcl_skycolor = nether_skycolor,
--		_mcl_fogcolor = "#330808"
	})

	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_nether:netherrack","mcl_nether:glowstone","mcl_blackstone:nether_gold","mcl_nether:quartz_ore","mcl_core:gravel","mcl_nether:soul_sand","mcl_nether:glowstone","mcl_nether:magma"},
		sidelen = 16,
		fill_ratio = 10,
		biomes = { "Nether" },
		y_min = mcl_vars.mg_lava_nether_max,
		y_max = mcl_vars.mg_nether_deco_max,
		decoration = "mcl_nether:netherrack",
		flags = "all_floors",
		param2 = 0,
	})

	minetest.register_biome({
		name = "SoulsandValley",
		node_filler = "mcl_nether:netherrack",
		node_stone = "mcl_nether:netherrack",
		node_top = "mcl_blackstone:soul_soil",
		node_water = "air",
		node_river_water = "air",
		node_cave_liquid = "air",
		y_min = mcl_vars.mg_nether_min,
		y_max = mcl_vars.mg_nether_max + 80,
		heat_point = 77,
		humidity_point = 33,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 17,
--		_mcl_skycolor = nether_skycolor,
--		_mcl_fogcolor = "#1B4745"
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_nether:netherrack","mcl_nether:glowstone","mcl_nether:magma"},
		sidelen = 16,
		fill_ratio = 10,
		biomes = { "SoulsandValley" },
		y_min = mcl_vars.mg_lava_nether_max,
		y_max = mcl_vars.mg_nether_deco_max,
		decoration = "mcl_blackstone:soul_soil",
		flags = "all_floors, all_ceilings",
		param2 = 0,
	})

	minetest.register_ore({
		ore_type       = "blob",
		ore            = "mcl_nether:soul_sand",
		wherein        = { "mcl_nether:netherrack", "mcl_blackstone:soul_soil" },
		clust_scarcity = 100,
		clust_num_ores = 225,
		clust_size     = 15,
		biomes = { "SoulsandValley" },
		y_min = mcl_vars.mg_lava_nether_max,
		y_max = mcl_vars.mg_nether_deco_max,
		noise_params = {
			offset  = 0,
			scale   = 1,
			spread  = { x = 250, y = 250, z = 250 },
			seed    = 12345,
			octaves = 3,
			persist = 0.6,
			lacunarity = 2,
			flags = "defaults",
		}
	})
	minetest.register_biome({
		name = "CrimsonForest",
		node_filler = "mcl_nether:netherrack",
		node_stone = "mcl_nether:netherrack",
		node_top = "mcl_crimson:crimson_nylium",
		node_water = "air",
		node_river_water = "air",
		node_cave_liquid = "air",
		y_min = mcl_vars.mg_nether_min,
		y_max = mcl_vars.mg_nether_max + 80,
		heat_point = 60,
		humidity_point = 47,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 17,
--		_mcl_skycolor = nether_skycolor,
--		_mcl_fogcolor = "#330303"
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_nether:netherrack","mcl_nether:glowstone","mcl_blackstone:nether_gold","mcl_nether:quartz_ore","mcl_core:gravel","mcl_nether:soul_sand","mcl_nether:magma","mcl_blackstone:blackstone"},
		sidelen = 16,
		fill_ratio = 10,
		biomes = { "CrimsonForest" },
		y_min = mcl_vars.mg_lava_nether_max,
		y_max = mcl_vars.mg_nether_deco_max,
		decoration = "mcl_crimson:crimson_nylium",
		flags = "all_floors",
		param2 = 0,
	})
	minetest.register_biome({
		name = "WarpedForest",
		node_filler = "mcl_nether:netherrack",
		node_stone = "mcl_nether:netherrack",
		node_top = "mcl_crimson:warped_nylium",
		node_water = "air",
		node_river_water = "air",
		node_cave_liquid = "air",
		y_min = mcl_vars.mg_nether_min,
		y_max = mcl_vars.mg_nether_max + 80,
		heat_point = 37,
		humidity_point = 70,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 17,
--		_mcl_skycolor = nether_skycolor,
--		_mcl_fogcolor = "#1A051A"
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_nether:netherrack","mcl_nether:glowstone","mcl_blackstone:nether_gold","mcl_nether:quartz_ore","mcl_core:gravel","mcl_nether:soul_sand","mcl_nether:magma","mcl_blackstone:blackstone"},
		sidelen = 16,
		fill_ratio = 10,
		biomes = { "WarpedForest" },
		y_min = mcl_vars.mg_lava_nether_max,
		y_max = mcl_vars.mg_nether_deco_max,
		decoration = "mcl_crimson:warped_nylium",
		flags = "all_floors",
		param2 = 0,
	})
	minetest.register_biome({
		name = "BasaltDelta",
		node_filler = "mcl_nether:netherrack",
		node_stone = "mcl_nether:netherrack",
		node_top = "mcl_blackstone:basalt",
		node_water = "air",
		node_river_water = "air",
		node_cave_liquid = "air",
		y_min = mcl_vars.mg_nether_min,
		y_max = mcl_vars.mg_nether_max + 80,
		heat_point = 27,
		humidity_point = 80,
		_mcl_biome_type = "hot",
		_mcl_palette_index = 17,
--		_mcl_skycolor = nether_skycolor,
--		_mcl_fogcolor = "#685F70"
	})

	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_nether:netherrack","mcl_nether:glowstone","mcl_blackstone:nether_gold","mcl_nether:quartz_ore","mcl_core:gravel","mcl_nether:soul_sand","mcl_blackstone:blackstone","mcl_nether:magma"},
		sidelen = 16,
		fill_ratio = 10,
		biomes = { "BasaltDelta" },
		y_min = mcl_vars.mg_lava_nether_max,
		y_max = mcl_vars.mg_nether_deco_max,
		decoration = "mcl_blackstone:basalt",
		flags = "all_floors",
		param2 = 0,
	})

	minetest.register_ore({
	ore_type       = "blob",
	ore            = "mcl_blackstone:blackstone",
	wherein        =  {"mcl_nether:netherrack","mcl_nether:glowstone","mcl_core:gravel"},
	clust_scarcity = 100,
	clust_num_ores = 400,
	clust_size     = 20,
	biomes = { "BasaltDelta" },
	y_min = mcl_vars.mg_lava_nether_max,
	y_max = mcl_vars.mg_nether_deco_max,
	noise_params = {
		offset  = 0,
		scale   = 1,
		spread  = { x = 250, y = 250, z = 250 },
		seed    = 12345,
		octaves = 3,
		persist = 0.6,
		lacunarity = 2,
		flags = "defaults",
	}
	})

	--[[ THE END ]]
	minetest.register_biome({
		name = "End",
		node_stone = "air",
		node_filler = "air",
		node_water = "air",
		node_river_water = "air",
		node_cave_liquid = "air",
		y_min = mcl_vars.mg_end_min,
		y_max = mcl_vars.mg_end_max + 80,
		heat_point = 1000, --ridiculously high values so End Island always takes precedent
		humidity_point = 1000,
		vertical_blend = 16,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 0,
--		_mcl_skycolor = end_skycolor,
--		_mcl_fogcolor = end_fogcolor
	})
	minetest.register_biome({
		name = "EndBarrens",
		node_stone = "air",
		node_filler = "air",
		node_water = "air",
		node_river_water = "air",
		node_cave_liquid = "air",
		y_min = mcl_vars.mg_end_min,
		y_max = mcl_vars.mg_end_max + 80,
		heat_point = 1000,
		humidity_point = 1000,
		vertical_blend = 16,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 0,
--		_mcl_skycolor = end_skycolor,
--		_mcl_fogcolor = end_fogcolor
	})
	minetest.register_biome({
		name = "EndMidlands",
		node_stone = "air",
		node_filler = "air",
		node_water = "air",
		node_river_water = "air",
		node_cave_liquid = "air",
		y_min = mcl_vars.mg_end_min,
		y_max = mcl_vars.mg_end_max + 80,
		heat_point = 1000,
		humidity_point = 1000,
		vertical_blend = 16,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 0,
--		_mcl_skycolor = end_skycolor,
--		_mcl_fogcolor = end_fogcolor
	})
	minetest.register_biome({
		name = "EndHighlands",
		node_stone = "air",
		node_filler = "air",
		node_water = "air",
		node_river_water = "air",
		node_cave_liquid = "air",
		y_min = mcl_vars.mg_end_min,
		y_max = mcl_vars.mg_end_max + 80,
		heat_point = 1000,
		humidity_point = 1000,
		vertical_blend = 16,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 0,
--		_mcl_skycolor = end_skycolor,
--		_mcl_fogcolor = end_fogcolor
	})
	minetest.register_biome({
		name = "EndSmallIslands",
		node_stone = "air",
		node_filler = "air",
		node_water = "air",
		node_river_water = "air",
		node_cave_liquid = "air",
		y_min = mcl_vars.mg_end_min,
		y_max = mcl_vars.mg_end_max + 80,
		heat_point = 1000,
		humidity_point = 1000,
		vertical_blend = 16,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 0,
--		_mcl_skycolor = end_skycolor,
--		_mcl_fogcolor = end_fogcolor
	})

	minetest.register_biome({
		name = "EndBorder",
		node_stone = "air",
		node_filler = "air",
		node_water = "air",
		node_river_water = "air",
		node_cave_liquid = "air",
		y_min = mcl_vars.mg_end_min,
		y_max = mcl_vars.mg_end_max + 80,
		heat_point = 500,
		humidity_point = 500,
		vertical_blend = 16,
		max_pos = {x = 1250, y = mcl_vars.mg_end_min + 512, z = 1250},
		min_pos = {x = -1250, y = mcl_vars.mg_end_min, z = -1250},
		_mcl_biome_type = "medium",
		_mcl_palette_index = 0,
--		_mcl_skycolor = end_skycolor,
--		_mcl_fogcolor = end_fogcolor
	})

	minetest.register_biome({
		name = "EndIsland",
		node_stone = "air",
		node_filler = "air",
		node_water = "air",
		node_river_water = "air",
		node_cave_liquid = "air",
		max_pos = {x = 650, y = mcl_vars.mg_end_min + 512, z = 650},
		min_pos = {x = -650, y = mcl_vars.mg_end_min, z = -650},
		heat_point = 50,
		humidity_point = 50,
		vertical_blend = 16,
		_mcl_biome_type = "medium",
		_mcl_palette_index = 0,
--		_mcl_skycolor = end_skycolor,
--		_mcl_fogcolor = end_fogcolor
	})

end

-- Register ores which are limited by biomes. For all mapgens except flat and singlenode.
local function register_biome_ores()
	-- Emeralds
	minetest.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_emerald",
		wherein        = stonelike,
		clust_scarcity = 16384,
		clust_num_ores = 1,
		clust_size     = 1,
		y_min          = mcl_worlds.layer_to_y(4),
		y_max          = mcl_worlds.layer_to_y(32),
		biomes         = {
			"ExtremeHills", "ExtremeHills_beach", "ExtremeHills_ocean", "ExtremeHills_deep_ocean", "ExtremeHills_underground",
			"ExtremeHills+", "ExtremeHills+_ocean", "ExtremeHills+_deep_ocean", "ExtremeHills+_underground",
			"ExtremeHillsM", "ExtremeHillsM_ocean", "ExtremeHillsM_deep_ocean", "ExtremeHillsM_underground",
		},
	})

	-- Rarely replace stone with stone monster eggs.
	minetest.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_monster_eggs:monster_egg_stone",
		wherein        = "mcl_core:stone",
		clust_scarcity = 26 * 26 * 26,
		clust_num_ores = 3,
		clust_size     = 2,
		y_min          = mcl_vars.mg_overworld_min,
		y_max          = mcl_worlds.layer_to_y(61),
		biomes         = {
			"ExtremeHills", "ExtremeHills_beach", "ExtremeHills_ocean", "ExtremeHills_deep_ocean", "ExtremeHills_underground",
			"ExtremeHills+", "ExtremeHills+_ocean", "ExtremeHills+_deep_ocean", "ExtremeHills+_underground",
			"ExtremeHillsM", "ExtremeHillsM_ocean", "ExtremeHillsM_deep_ocean", "ExtremeHillsM_underground",
		},
	})

	-- Bonus gold spawn in Mesa
	minetest.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_core:stone_with_gold",
		wherein        = stonelike,
		clust_scarcity = 3333,
		clust_num_ores = 5,
		clust_size     = 3,
		y_min          = mcl_worlds.layer_to_y(32),
		y_max          = mcl_worlds.layer_to_y(79),
		biomes         = { "Mesa", "Mesa_sandlevel", "Mesa_ocean",
				"MesaBryce", "MesaBryce_sandlevel", "MesaBryce_ocean",
				"MesaPlateauF", "MesaPlateauF_sandlevel", "MesaPlateauF_ocean",
				"MesaPlateauFM", "MesaPlateauFM_sandlevel", "MesaPlateauFM_ocean", },
	})

	--nether gold
	minetest.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_blackstone:blackstone_gilded",
		wherein        = "mcl_blackstone:blackstone",
		clust_scarcity = 4775,
		clust_num_ores = 2,
		clust_size     = 2,
		y_min          = mcl_vars.mg_nether_min,
		y_max          = mcl_vars.mg_nether_max,
	})
	minetest.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_blackstone:nether_gold",
		wherein        = "mcl_nether:netherrack",
		clust_scarcity = 830,
		clust_num_ores = 5,
		clust_size     = 3,
		y_min          = mcl_vars.mg_nether_min,
		y_max          = mcl_vars.mg_nether_max,
	})
	minetest.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_blackstone:nether_gold",
		wherein        = "mcl_nether:netherrack",
		clust_scarcity = 1660,
		clust_num_ores = 4,
		clust_size     = 2,
		y_min          = mcl_vars.mg_nether_min,
		y_max          = mcl_vars.mg_nether_max,
	})
end

-- Register “fake” ores directly related to the biomes. These are mostly low-level landscape alternations
local function register_biomelike_ores()

	-- Random coarse dirt floor in Mega Taiga and Mesa Plateau F
	minetest.register_ore({
		ore_type	= "sheet",
		ore		= "mcl_core:coarse_dirt",
		wherein		= {"mcl_core:podzol", "mcl_core:dirt"},
		clust_scarcity	= 1,
		clust_num_ores	= 12,
		clust_size	= 10,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_threshold = 0.2,
		noise_params = {offset=0, scale=15, spread={x=130, y=130, z=130}, seed=24, octaves=3, persist=0.70},
		biomes = { "MegaTaiga" },
	})

	minetest.register_ore({
		ore_type	= "sheet",
		ore		= "mcl_core:coarse_dirt",
		wherein		= {"mcl_core:dirt_with_grass", "mcl_core:dirt"},
		column_height_max = 1,
		column_midpoint_factor = 0.0,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_threshold = 0.0,
		noise_params = {offset=0, scale=15, spread={x=250, y=250, z=250}, seed=24, octaves=3, persist=0.70},
		biomes = { "MesaPlateauF_grasstop" },
	})
	minetest.register_ore({
		ore_type	= "blob",
		ore		= "mcl_core:coarse_dirt",
		wherein		= {"mcl_core:dirt_with_grass", "mcl_core:dirt"},
		clust_scarcity	= 1500,
		clust_num_ores	= 25,
		clust_size	= 7,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_params = {
			offset  = 0,
			scale   = 1,
			spread  = {x=250, y=250, z=250},
			seed    = 12345,
			octaves = 3,
			persist = 0.6,
			lacunarity = 2,
			flags = "defaults",
		},
		biomes = { "MesaPlateauF_grasstop" },
	})
	minetest.register_ore({
		ore_type	= "sheet",
		ore		= "mcl_core:coarse_dirt",
		wherein		= {"mcl_core:dirt_with_grass", "mcl_core:dirt"},
		column_height_max = 1,
		column_midpoint_factor = 0.0,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_threshold = -2.5,
		noise_params = {offset=1, scale=15, spread={x=250, y=250, z=250}, seed=24, octaves=3, persist=0.80},
		biomes = { "MesaPlateauFM_grasstop" },
	})
	minetest.register_ore({
		ore_type	= "blob",
		ore		= "mcl_core:coarse_dirt",
		wherein		= {"mcl_core:dirt_with_grass", "mcl_core:dirt"},
		clust_scarcity	= 1800,
		clust_num_ores	= 65,
		clust_size	= 15,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_params = {
			offset  = 0,
			scale   = 1,
			spread  = {x=250, y=250, z=250},
			seed    = 12345,
			octaves = 3,
			persist = 0.6,
			lacunarity = 2,
			flags = "defaults",
		},
		biomes = { "MesaPlateauFM_grasstop" },
	})
	-- Occasionally dig out portions of MesaPlateauFM
	minetest.register_ore({
		ore_type	= "blob",
		ore		= "air",
		wherein		= {"group:hardened_clay", "group:sand","mcl_core:coarse_dirt"},
		clust_scarcity	= 4000,
		clust_size	= 5,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_params = {
			offset  = 0,
			scale   = 1,
			spread  = {x=250, y=250, z=250},
			seed    = 12345,
			octaves = 3,
			persist = 0.6,
			lacunarity = 2,
			flags = "defaults",
		},
		biomes = { "MesaPlateauFM", "MesaPlateauFM_grasstop" },
	})
	minetest.register_ore({
		ore_type	= "blob",
		ore		= "mcl_core:redsandstone",
		wherein		= {"mcl_colorblocks:hardened_clay_orange"},
		clust_scarcity	= 300,
		clust_size	= 8,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_params = {
			offset  = 0,
			scale   = 1,
			spread  = {x=250, y=250, z=250},
			seed    = 12345,
			octaves = 3,
			persist = 0.6,
			lacunarity = 2,
			flags = "defaults",
		},
		biomes = { "MesaPlateauFM_sandlevel" },
	})
	-- More red sand in MesaPlateauFM
	minetest.register_ore({
		ore_type	= "sheet",
		ore		= "mcl_core:redsand",
		wherein		= {"group:hardened_clay"},
		clust_scarcity	= 1,
		clust_num_ores	= 12,
		clust_size	= 10,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_threshold = 0.1,
		noise_params = {offset=0, scale=15, spread={x=130, y=130, z=130}, seed=95, octaves=3, persist=0.70},
		biomes = { "MesaPlateauFM" },
	})
	minetest.register_ore({
		ore_type	= "blob",
		ore		= "mcl_core:redsand",
		wherein		= {"group:hardened_clay"},
		clust_scarcity	= 1500,
		clust_size	= 4,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_params = {
			offset  = 0,
			scale   = 1,
			spread  = {x=250, y=250, z=250},
			seed    = 12345,
			octaves = 3,
			persist = 0.6,
			lacunarity = 2,
			flags = "defaults",
		},
		biomes = { "MesaPlateauFM", "MesaPlateauFM_grasstop", "MesaPlateauFM_sandlevel" },
	})

	-- Small dirt patches in Extreme Hills M
	minetest.register_ore({
		ore_type	= "blob",
		ore		= "mcl_core:dirt",
		wherein		= {"mcl_core:gravel"},
		clust_scarcity	= 5000,
		clust_num_ores	= 12,
		clust_size	= 4,
		y_min		= mcl_vars.mg_overworld_min,
		y_max		= mcl_vars.mg_overworld_max,
		noise_threshold = 0.2,
		noise_params = {offset=0, scale=5, spread={x=250, y=250, z=250}, seed=64, octaves=3, persist=0.60},
		biomes = { "ExtremeHillsM" },
	})
	minetest.register_decoration({
		--this decoration "hack" replaces the top layer of the above ore with grass when under air.
		deco_type = "simple",
		place_on = {"mcl_core:dirt"},
		fill_ratio = 10,
		biomes = { "ExtremeHillsM" },
		decoration = "mcl_core:dirt_with_grass",
		place_offset_y = -1,
		flags = "force_placement",
	})
	-- For a transition from stone to hardened clay in mesa biomes that is not perfectly flat
	minetest.register_ore({
		ore_type = "stratum",
		ore = "mcl_core:stone",
		wherein = {"group:hardened_clay"},
		noise_params = {offset=-6, scale=2, spread={x=25, y=25, z=25}, octaves=1, persist=0.60},
		stratum_thickness = 8,
		biomes = {
			"Mesa_sandlevel", "Mesa_ocean",
			"MesaBryce_sandlevel", "MesaBryce_ocean",
			"MesaPlateauF_sandlevel", "MesaPlateauF_ocean",
			"MesaPlateauFM_sandlevel", "MesaPlateauFM_ocean",
		},
		y_min = -4,
		y_max = 0,

	})

	-- Mesa strata (registered as sheet ores)

	-- Helper function to create strata.
	local function stratum(y_min, height, color, seed, is_perfect)
		if not height then
			height = 1
		end
		if not seed then
			seed = 39
		end
		local y_max = y_min + height-1
		local perfect_biomes
		if is_perfect then
			-- "perfect" means no erosion
			perfect_biomes = { "MesaBryce", "Mesa", "MesaPlateauF", "MesaPlateauFM" }
		else
			perfect_biomes = { "MesaBryce" }
		end
		-- Full, perfect stratum
		minetest.register_ore({
			ore_type = "stratum",
			ore = "mcl_colorblocks:hardened_clay_"..color,
			-- Only paint uncolored so the biome can choose
			-- a color in advance.
			wherein = {"mcl_colorblocks:hardened_clay"},
			y_min = y_min,
			y_max = y_max,
			biomes = perfect_biomes,
		})
		if not is_perfect then
		-- Slightly eroded stratum, only minor imperfections
		minetest.register_ore({
			ore_type = "stratum",
			ore = "mcl_colorblocks:hardened_clay_"..color,
			wherein = {"mcl_colorblocks:hardened_clay"},
			y_min = y_min,
			y_max = y_max,
			biomes = { "Mesa", "MesaPlateauF" },
			noise_params = {
				offset = y_min+(y_max-y_min)/2,
				scale = 0,
				spread = {x = 50, y = 50, z = 50},
				seed = seed+4,
				octaves = 1,
				persist = 1.0
			},
			np_stratum_thickness = {
				offset = 1.28,
				scale = 1,
				spread = {x = 18, y = 18, z = 18},
				seed = seed+4,
				octaves = 3,
				persist = 0.8,
			},
		})
		-- Very eroded stratum, most of the color is gone
		minetest.register_ore({
			ore_type = "stratum",
			ore = "mcl_colorblocks:hardened_clay_"..color,
			wherein = {"mcl_colorblocks:hardened_clay"},
			y_min = y_min,
			y_max = y_max,
			biomes = { "MesaPlateauFM" },
			noise_params = {
				offset = y_min+(y_max-y_min)/2,
				scale = 0,
				spread = {x = 50, y = 50, z = 50},
				seed = seed+4,
				octaves = 1,
				persist = 1.0
			},
			np_stratum_thickness = {
				offset = 0.1,
				scale = 1,
				spread = {x = 28, y = 28, z = 28},
				seed = seed+4,
				octaves = 2,
				persist = 0.6,
			},
		})
		end

	end

	-- Hardcoded orange strata near sea level.

	-- For MesaBryce, since it has no sand at these heights
	stratum(4, 1, "orange", nil, true)
	stratum(7, 2, "orange", nil, true)

	-- 3-level stratum above the sandlevel (all mesa biomes)
	stratum(11, 3, "orange", nil, true)

	-- Create random strata for up to Y = 256.
	-- These strata are calculated based on the world seed and are global.
	-- They are thus different per-world.
	local mesapr = PcgRandom(mg_seed)

	--[[

	------ DANGER ZONE! ------

	The following code is sensitive to changes; changing any number may break
	mapgen consistency when the mapgen generates new mapchunks in existing
	worlds because the random generator will yield different results and the strata
	suddenly don't match up anymore. ]]

	-- Available Mesa colors:
	local mesa_stratum_colors = { "silver", "brown", "orange", "red", "yellow", "white" }

	-- Start level
	local y = 17

	-- Generate stratas
	repeat
		-- Each stratum has a color (duh!)
		local colorid = mesapr:next(1, #mesa_stratum_colors)

		-- … and a random thickness
		local heightrandom = mesapr:next(1, 12)
		local h
		if heightrandom == 12 then
			h = 4
		elseif heightrandom >= 10 then
			h = 3
		elseif heightrandom >= 8 then
			h = 2
		else
			h = 1
		end
		-- Small built-in bias: Only thin strata up to this Y level
		if y < 45 then
			h = math.min(h, 2)
		end

		-- Register stratum
		stratum(y, h, mesa_stratum_colors[colorid])

		-- Skip a random amount of layers (which won't get painted)
		local skiprandom = mesapr:next(1, 12)
		local skip
		if skiprandom == 12 then
			skip = 4
		elseif skiprandom >= 10 then
			skip = 3
		elseif skiprandom >= 5 then
			skip = 2
		elseif skiprandom >= 2 then
			skip = 1
		else
			-- If this happens, the next stratum will touch the previous one without gap
			skip = 0
		end

		-- Get height of next stratum or finish
		y = y + h + skip
	until y > 256

	--[[ END OF DANGER ZONE ]]
end

-- Non-Overworld ores
local function register_dimension_ores()

	--[[ NETHER GENERATION ]]

	-- Soul sand
	minetest.register_ore({
		ore_type        = "sheet",
		ore             = "mcl_nether:soul_sand",
		wherein         = {"mcl_nether:netherrack"},
		clust_scarcity  = 13 * 13 * 13,
		clust_size      = 5,
		y_min           = mcl_vars.mg_nether_min,
		y_max           = mcl_worlds.layer_to_y(64, "nether"),
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.1,
			spread = {x = 5, y = 5, z = 5},
			seed = 2316,
			octaves = 1,
			persist = 0.0
		},
	})

	-- Magma blocks
	minetest.register_ore({
		ore_type       = "blob",
		ore            = "mcl_nether:magma",
		wherein         = {"mcl_nether:netherrack"},
		clust_scarcity = 8*8*8,
		clust_num_ores = 45,
		clust_size     = 6,
		y_min          = mcl_worlds.layer_to_y(23, "nether"),
		y_max          = mcl_worlds.layer_to_y(37, "nether"),
		noise_params = {
			offset  = 0,
			scale   = 1,
			spread  = {x=250, y=250, z=250},
			seed    = 12345,
			octaves = 3,
			persist = 0.6,
			lacunarity = 2,
			flags = "defaults",
		},
	})
	minetest.register_ore({
		ore_type       = "blob",
		ore            = "mcl_nether:magma",
		wherein        = {"mcl_nether:netherrack"},
		clust_scarcity = 10*10*10,
		clust_num_ores = 65,
		clust_size     = 8,
		y_min          = mcl_worlds.layer_to_y(23, "nether"),
		y_max          = mcl_worlds.layer_to_y(37, "nether"),
		noise_params = {
			offset  = 0,
			scale   = 1,
			spread  = {x=250, y=250, z=250},
			seed    = 12345,
			octaves = 3,
			persist = 0.6,
			lacunarity = 2,
			flags = "defaults",
		},
	})

	-- Glowstone
	minetest.register_ore({
		ore_type        = "blob",
		ore             = "mcl_nether:glowstone",
		wherein         = {"mcl_nether:netherrack"},
		clust_scarcity  = 26 * 26 * 26,
		clust_size      = 5,
		y_min           = mcl_vars.mg_lava_nether_max + 10,
		y_max           = mcl_vars.mg_nether_max - 13,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.1,
			spread = {x = 5, y = 5, z = 5},
			seed = 17676,
			octaves = 1,
			persist = 0.0
		},
	})

	-- Gravel (Nether)
	minetest.register_ore({
		ore_type        = "sheet",
		ore             = "mcl_core:gravel",
		wherein         = {"mcl_nether:netherrack"},
		column_height_min = 1,
		column_height_max = 1,
		column_midpoint_factor = 0,
		y_min           = mcl_worlds.layer_to_y(63, "nether"),
		-- This should be 65, but for some reason with this setting, the sheet ore really stops at 65. o_O
		y_max           = mcl_worlds.layer_to_y(65+2, "nether"),
		noise_threshold = 0.2,
		noise_params    = {
			offset = 0.0,
			scale = 0.5,
			spread = {x = 20, y = 20, z = 20},
			seed = 766,
			octaves = 3,
			persist = 0.6,
		},
	})

	-- Nether quartz
	if minetest.settings:get_bool("mcl_generate_ores", true) then
		minetest.register_ore({
			ore_type       = "scatter",
			ore            = "mcl_nether:quartz_ore",
			wherein         = {"mcl_nether:netherrack"},
			clust_scarcity = 850,
			clust_num_ores = 4, -- MC cluster amount: 4-10
			clust_size     = 3,
			y_min = mcl_vars.mg_nether_min,
			y_max = mcl_vars.mg_nether_max,
		})
		minetest.register_ore({
			ore_type       = "scatter",
			ore            = "mcl_nether:quartz_ore",
			wherein         = {"mcl_nether:netherrack"},
			clust_scarcity = 1650,
			clust_num_ores = 8, -- MC cluster amount: 4-10
			clust_size     = 4,
			y_min = mcl_vars.mg_nether_min,
			y_max = mcl_vars.mg_nether_max,
		})
	end

	-- Lava springs in the Nether
	minetest.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_nether:nether_lava_source",
		wherein         = {"mcl_nether:netherrack"},
		clust_scarcity = 13500, --rare
		clust_num_ores = 1,
		clust_size     = 1,
		y_min           = mcl_vars.mg_lava_nether_max,
		y_max           = mcl_vars.mg_nether_max - 13,
	})

	local lava_biomes = {"BasaltDelta","Nether"}
	minetest.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_nether:nether_lava_source",
		wherein        = {"mcl_nether:netherrack"},
		clust_scarcity = 500,
		clust_num_ores = 1,
		clust_size     = 1,
		biomes         = lava_biomes,
		y_min          = mcl_vars.mg_nether_min,
		y_max          = mcl_vars.mg_lava_nether_max + 1,
	})

	minetest.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_nether:nether_lava_source",
		wherein         = {"mcl_nether:netherrack"},
		clust_scarcity = 1000,
		clust_num_ores = 1,
		clust_size     = 1,
		biomes         = lava_biomes,
		y_min           = mcl_vars.mg_lava_nether_max + 2,
		y_max           = mcl_vars.mg_lava_nether_max + 12,
	})

	minetest.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_nether:nether_lava_source",
		wherein         = {"mcl_nether:netherrack"},
		clust_scarcity = 2000,
		clust_num_ores = 1,
		clust_size     = 1,
		biomes         = lava_biomes,
		y_min           = mcl_vars.mg_lava_nether_max + 13,
		y_max           = mcl_vars.mg_lava_nether_max + 48,
	})
	minetest.register_ore({
		ore_type       = "scatter",
		ore            = "mcl_nether:nether_lava_source",
		wherein         = {"mcl_nether:netherrack"},
		clust_scarcity = 3500,
		clust_num_ores = 1,
		clust_size     = 1,
		biomes         = lava_biomes,
		y_min           = mcl_vars.mg_lava_nether_max + 49,
		y_max           = mcl_vars.mg_nether_max - 13,
	})

	--[[ THE END ]]

	-- Generate fake End
	-- TODO: Remove the "ores" when there's a better End generator

	minetest.register_ore({
		ore_type        = "stratum",
		ore             = "mcl_end:end_stone",
		wherein         = {"air"},
		biomes          = {"EndSmallIslands","Endborder"},
		y_min           = mcl_vars.mg_end_min+64,
		y_max           = mcl_vars.mg_end_min+80,
		clust_num_ores  = 3375,
		clust_size      = 15,

		noise_params = {
			offset  = mcl_vars.mg_end_min+70,
			scale   = -1,
			spread  = {x=84, y=84, z=84},
			seed    = 145,
			octaves = 3,
			persist = 0.6,
			lacunarity = 2,
			--flags = "defaults",
		},

		np_stratum_thickness = {
			offset  = 0,
			scale   = 15,
			spread  = {x=84, y=84, z=84},
			seed    = 145,
			octaves = 3,
			persist = 0.6,
			lacunarity = 2,
			--flags = "defaults",
		},
		clust_scarcity = 1,
	})

	minetest.register_ore({
		ore_type        = "stratum",
		ore             = "mcl_end:end_stone",
		wherein         = {"air"},
		biomes          = {"End","EndMidlands","EndHighlands","EndBarrens"},
		y_min           = mcl_vars.mg_end_min+64,
		y_max           = mcl_vars.mg_end_min+80,

		noise_params = {
			offset  = mcl_vars.mg_end_min+70,
			scale   = -1,
			spread  = {x=126, y=126, z=126},
			seed    = mg_seed+9999,
			octaves = 3,
			persist = 0.5,
		},

		np_stratum_thickness = {
			offset  = -2,
			scale   = 10,
			spread  = {x=126, y=126, z=126},
			seed    = mg_seed+9999,
			octaves = 3,
			persist = 0.5,
		},
		clust_scarcity = 1,
	})

	minetest.register_ore({
		ore_type        = "stratum",
		ore             = "mcl_end:end_stone",
		wherein         = {"air"},
		biomes          = {"End","EndMidlands","EndHighlands","EndBarrens"},
		y_min           = mcl_vars.mg_end_min+64,
		y_max           = mcl_vars.mg_end_min+80,

		noise_params = {
			offset  = mcl_vars.mg_end_min+72,
			scale   = -3,
			spread  = {x=84, y=84, z=84},
			seed    = mg_seed+999,
			octaves = 4,
			persist = 0.8,
		},

		np_stratum_thickness = {
			offset  = -4,
			scale   = 10,
			spread  = {x=84, y=84, z=84},
			seed    = mg_seed+999,
			octaves = 4,
			persist = 0.8,
		},
		clust_scarcity = 1,
	})
	minetest.register_ore({
		ore_type        = "stratum",
		ore             = "mcl_end:end_stone",
		wherein         = {"air"},
		biomes          = {"End","EndMidlands","EndHighlands","EndBarrens"},
		y_min           = mcl_vars.mg_end_min+64,
		y_max           = mcl_vars.mg_end_min+80,

		noise_params = {
			offset  = mcl_vars.mg_end_min+70,
			scale   = -2,
			spread  = {x=84, y=84, z=84},
			seed    = mg_seed+99,
			octaves = 4,
			persist = 0.85,
		},

		np_stratum_thickness = {
			offset  = -3,
			scale   = 5,
			spread  = {x=63, y=63, z=63},
			seed    = mg_seed+50,
			octaves = 4,
			persist = 0.85,
		},
		clust_scarcity = 1,
	})

end


-- All mapgens

-- Template to register a grass or fern decoration
function mcl_biomes.register_grass_decoration(grasstype, offset, scale, biomes)
	local place_on, seed, node
	if grasstype == "fern" then
		node = "mcl_flowers:fern"
		place_on = {"group:grass_block_no_snow", "mcl_core:podzol","mcl_mud:mud"}
		seed = 333
	elseif grasstype == "tallgrass" then
		node = "mcl_flowers:tallgrass"
		place_on = {"group:grass_block_no_snow","mcl_mud:mud"}
		seed = 420
	end
	local noise = {
		offset = offset,
		scale = scale,
		spread = {x = 200, y = 200, z = 200},
		seed = seed,
		octaves = 3,
		persist = 0.6
	}
	for b=1, #biomes do
		local param2 = minetest.registered_biomes[biomes[b]]._mcl_palette_index
		minetest.register_decoration({
			deco_type = "simple",
			place_on = place_on,
			sidelen = 16,
			noise_params = noise,
			biomes = { biomes[b] },
			y_min = 1,
			y_max = mcl_vars.mg_overworld_max,
			decoration = node,
			param2 = param2,
		})
	end
end

local register_grass_decoration = mcl_biomes.register_grass_decoration

function mcl_biomes.register_seagrass_decoration(grasstype, offset, scale, biomes)
	local seed, nodes, surfaces, param2, param2_max, y_max
	if grasstype == "seagrass" then
		seed = 16
		param2 = 3
		surfaces = { "mcl_core:dirt", "mcl_core:sand", "mcl_core:gravel", "mcl_core:redsand" }
		nodes = { "mcl_ocean:seagrass_dirt", "mcl_ocean:seagrass_sand", "mcl_ocean:seagrass_gravel", "mcl_ocean:seagrass_redsand" }
		y_max = 0
	elseif grasstype == "kelp" then
		seed = 32
		param2 = 16
		param2_max = 96
		surfaces = { "mcl_core:dirt", "mcl_core:sand", "mcl_core:gravel" }
		nodes = { "mcl_ocean:kelp_dirt", "mcl_ocean:kelp_sand", "mcl_ocean:kelp_gravel" }
		y_max = -6
	end
	local noise = {
		offset = offset,
		scale = scale,
		spread = {x = 100, y = 100, z = 100},
		seed = seed,
		octaves = 3,
		persist = 0.6,
	}

	for s=1, #surfaces do
		minetest.register_decoration({
			deco_type = "simple",
			place_on = { surfaces[s] },
			sidelen = 16,
			noise_params = noise,
			biomes = biomes,
			y_min = DEEP_OCEAN_MIN,
			y_max = y_max,
			decoration = nodes[s],
			param2 = param2,
			param2_max = param2_max,
			place_offset_y = -1,
			flags = "force_placement",
		})
	end
end

local register_seagrass_decoration = mcl_biomes.register_seagrass_decoration

local coral_min = OCEAN_MIN
local coral_max = -10
local warm_oceans = {
	"BambooJungle_ocean",
	"JungleEdgeM_ocean",
	"Jungle_deep_ocean",
	"Savanna_ocean",
	"MesaPlateauF_ocean",
	"Swampland_ocean",
	"Mesa_ocean",
	"Plains_ocean",
	"MesaPlateauFM_ocean",
	"MushroomIsland_ocean",
	"SavannaM_ocean",
	"JungleEdge_ocean",
	"MesaBryce_ocean",
	"Jungle_ocean",
	"Desert_ocean",
	"JungleM_ocean",
	"MangroveSwamp_ocean"
}
local corals = {
	"brain",
	"horn",
	"bubble",
	"tube",
	"fire"
}

local function register_coral_decos(ck)
	local c = corals[ck]
	local noise = {
			offset = -0.0085,
			scale = 0.002,
			spread = {x = 25, y = 120, z = 25},
			seed = 235,
			octaves = 5,
			persist = 1.8,
			lacunarity = 3.5,
			flags = "absvalue"
		}
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:sand","mcl_core:gravel","mcl_mud:mud"},
		sidelen = 80,
		noise_params = noise,
		biomes = warm_oceans,
		y_min = coral_min,
		y_max = coral_max,
		schematic = mod_mcl_structures.."/schematics/mcl_structures_coral_"..c.."_1.mts",
		rotation = "random",
		flags = "all_floors,force_placement",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:sand","mcl_core:gravel","mcl_mud:mud"},
		noise_params = noise,
		sidelen = 80,
		biomes = warm_oceans,
		y_min = coral_min,
		y_max = coral_max,
		schematic = mod_mcl_structures.."/schematics/mcl_structures_coral_"..c.."_2.mts",
		rotation = "random",
		flags = "all_floors,force_placement",
	})

	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_ocean:"..c.."_coral_block"},
		sidelen = 16,
		fill_ratio = 3,
		y_min = coral_min,
		y_max = coral_max,
		decoration = "mcl_ocean:"..c.."_coral",
		biomes = warm_oceans,
		flags = "force_placement, all_floors",
		height = 1,
		height_max = 1,
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_ocean:horn_coral_block"},
		sidelen = 16,
		fill_ratio = 7,
		y_min = coral_min,
		y_max = coral_max,
		decoration = "mcl_ocean:"..c.."_coral_fan",
		biomes = warm_oceans,
		flags = "force_placement, all_floors",
		height = 1,
		height_max = 1,
	})
end

local function register_decorations()
	--Deep Dark
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_sculk:sculk"},
		sidelen = 16,
		fill_ratio = 0.1,
		decoration = "mcl_sculk:catalyst",
		biomes = {"DeepDark"},
		flags = "all_floors",
	})
	-- Coral Reefs
	for k,_ in pairs(corals) do
		register_coral_decos(k)
	end


	local lushcaves = { "LushCaves", "LushCaves_underground", "LushCaves_ocean", "LushCaves_deep_ocean"}
	local lushcaves_underground = { "LushCaves_underground", "LushCaves_ocean", "LushCaves_deep_ocean"}

	minetest.register_decoration({
		decoration = "mcl_lush_caves:moss",
		deco_type = "simple",
		place_on = table.merge(stonelike, {"mcl_core:stone","mcl_deepslate:deepslate","mcl_deepslate:tuff", "mcl_core:gravel", "mcl_core:bedrock"}),
		biomes = lushcaves,
		fill_ratio = 10,
		flags = "all_floors, all_ceilings",
		y_min = mcl_vars.mg_overworld_min,
	})

	minetest.register_decoration({
		decoration = "mcl_flowers:tallgrass",
		deco_type = "simple",
		place_on = {"mcl_lush_caves:moss"},
		biomes = lushcaves,
		fill_ratio = 1,
		flags = "all_floors",
		y_min = mcl_vars.mg_overworld_min,
	})

	minetest.register_decoration({
		decoration = "mcl_lush_caves:cave_vines",
		deco_type = "simple",
		place_on = {"mcl_lush_caves:moss"},
		height = 1,
		height_max = 4,
		fill_ratio = 0.2,
		flags = "all_ceilings",
		biomes = lushcaves_underground,
		y_min = mcl_vars.mg_overworld_min,
	})
	minetest.register_decoration({
		decoration = "mcl_lush_caves:cave_vines_lit",
		deco_type = "simple",
		place_on = {"mcl_lush_caves:moss"},
		height = 1,
		height_max = 4,
		fill_ratio = 0.3,
		flags = "all_ceilings",
		biomes = lushcaves_underground,
		y_min = mcl_vars.mg_overworld_min,
	})

	minetest.register_decoration({
			decoration = "mcl_lush_caves:azalea",
			deco_type = "simple",
			place_on = {"mcl_lush_caves:moss"},
			biomes = lushcaves,
			fill_ratio = 0.2,
			flags = "all_floors",
			y_min = mcl_vars.mg_overworld_min,
	})

	minetest.register_decoration({
			decoration = "mcl_lush_caves:azalea_flowering",
			deco_type = "simple",
			place_on = {"mcl_lush_caves:moss"},
			biomes = lushcaves,
			fill_ratio = 0.05,
			flags = "all_floors",
			y_min = mcl_vars.mg_overworld_min,
	})

	minetest.register_decoration({
		decoration = "mcl_lush_caves:cave_vines_lit",
		deco_type = "simple",
		place_on = {"mcl_lush_caves:cave_vines_lit","mcl_lush_caves:cave_vines"},
		height = 1,
		height_max = 4,
		fill_ratio = 0.1,
		flags = "all_ceilings",
		biomes = lushcaves_underground,
		y_min = mcl_vars.mg_overworld_min,
	})
	minetest.register_decoration({
		decoration = "mcl_lush_caves:cave_vines",
		deco_type = "simple",
		place_on = {"mcl_lush_caves:cave_vines_lit","mcl_lush_caves:cave_vines"},
		height = 1,
		height_max = 5,
		fill_ratio = 0.1,
		flags = "all_ceilings",
		biomes = lushcaves_underground,
		y_min = mcl_vars.mg_overworld_min,
	})

	minetest.register_decoration({
		place_on = {"mcl_lush_caves:rooted_dirt"},
		decoration = "mcl_lush_caves:hanging_roots",
		deco_type = "simple",
		fill_ratio = 10,
		flags = "all_ceilings",
		biomes = lushcaves,
		y_min = mcl_vars.mg_overworld_min,
	})

	minetest.register_decoration({
		decoration = "mcl_lush_caves:spore_blossom",
		deco_type = "simple",
		place_on = {"mcl_lush_caves:moss"},
		spawn_by = {"air"},
		num_spawn_by = 4,
		fill_ratio = 0.8,
		param2 = 4,
		flags = "all_ceilings",
		y_min = mcl_vars.mg_overworld_min,
		biomes = lushcaves_underground,
	})

	minetest.register_decoration({
		decoration = "mcl_lush_caves:moss_carpet",
		deco_type = "simple",
		place_on = table.merge(stonelike, {"mcl_deepslate:deepslate", "mcl_core:gravel","mcl_lush_caves:moss"}),
		fill_ratio = 0.1,
		flags = "all_floors",
		y_min = mcl_vars.mg_overworld_min,
		biomes = lushcaves,
	})

	minetest.register_decoration({
		deco_type = "simple",
		place_on = "mcl_lush_caves:moss","mcl_core:clay",
		fill_ratio = 0.5,
		biomes = lushcaves,
		decoration = "mcl_flowers:tallgrass",
		y_min = mcl_vars.mg_overworld_min,
		flags = "all_floors",
	})

	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"group:sand","mcl_core:gravel","mcl_mud:mud"},
		sidelen = 16,
		noise_params = {
			offset = -0.0085,
			scale = 0.002,
			spread = {x = 25, y = 120, z = 25},
			seed = 235,
			octaves = 5,
			persist = 1.8,
			lacunarity = 3.5,
			flags = "absvalue"
		},
		y_min = coral_min,
		y_max = coral_max,
		decoration = "mcl_ocean:dead_brain_coral_block",
		biomes = warm_oceans,
		flags = "force_placement",
		height = 1,
		height_max = 1,
		place_offset_y = -1,
	})

	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_ocean:dead_brain_coral_block"},
		sidelen = 16,
		fill_ratio = 3,
		y_min = coral_min,
		y_max = coral_max,
		decoration = "mcl_ocean:sea_pickle_1_dead_brain_coral_block",
		biomes = warm_oceans,
		flags = "force_placement, all_floors",
		height = 1,
		height_max = 1,
		place_offset_y = -1,
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_ocean:dead_brain_coral_block"},
		sidelen = 16,
		fill_ratio = 3,
		y_min = coral_min,
		y_max = coral_max,
		decoration = "mcl_ocean:sea_pickle_2_dead_brain_coral_block",
		biomes = warm_oceans,
		flags = "force_placement, all_floors",
		height = 1,
		height_max = 1,
		place_offset_y = -1,
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_ocean:dead_brain_coral_block"},
		sidelen = 16,
		fill_ratio = 2,
		y_min = coral_min,
		y_max = coral_max,
		decoration = "mcl_ocean:sea_pickle_3_dead_brain_coral_block",
		biomes = warm_oceans,
		flags = "force_placement, all_floors",
		height = 1,
		height_max = 1,
		place_offset_y = -1,
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_ocean:dead_brain_coral_block"},
		sidelen = 16,
		fill_ratio = 2,
		y_min = coral_min,
		y_max = coral_max,
		decoration = "mcl_ocean:sea_pickle_4_dead_brain_coral_block",
		biomes = warm_oceans,
		flags = "force_placement, all_floors",
		height = 1,
		height_max = 1,
		place_offset_y = -1,
	})
	--rare CORAl
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:sand","mcl_core:gravel"},
		fill_ratio = 0.0001,
		sidelen = 80,
		biomes = warm_oceans,
		y_min = coral_min,
		y_max = coral_max,
		schematic = mod_mcl_structures.."/schematics/coral_cora.mts",
		rotation = "random",
		flags = "place_center_x,place_center_z, force_placement",
	})

	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_core:dirt_with_grass","mcl_core:podzol"},
		sidelen = 16,
		noise_params = {
			offset = 0,
			scale = 0.012,
			spread = {x = 100, y = 100, z = 100},
			seed = 354,
			octaves = 1,
			persist = 0.5,
			lacunarity = 1.0,
			flags = "absvalue"
		},
		biomes = {"Taiga","ColdTaiga","MegaTaiga","MegaSpruceTaiga"},
		y_max = mcl_vars.mg_overworld_max,
		y_min = 2,
		decoration = "mcl_sweet_berry:sweet_berry_bush_3"
	})

	-- Large ice spike
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_core:snowblock", "mcl_core:snow", "group:grass_block_snow"},
		sidelen = 80,
		noise_params = {
			offset = 0.00040,
			scale = 0.001,
			spread = {x = 250, y = 250, z = 250},
			seed = 1133,
			octaves = 4,
			persist = 0.67,
		},
		biomes = {"IcePlainsSpikes"},
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_structures.."/schematics/mcl_structures_ice_spike_large.mts",
		rotation = "random",
		flags = "place_center_x, place_center_z",
	})

	-- Small ice spike
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_core:snowblock", "mcl_core:snow", "group:grass_block_snow"},
		sidelen = 80,
		noise_params = {
			offset = 0.005,
			scale = 0.001,
			spread = {x = 250, y = 250, z = 250},
			seed = 1133,
			octaves = 4,
			persist = 0.67,
		},
		biomes = {"IcePlainsSpikes"},
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_structures.."/schematics/mcl_structures_ice_spike_small.mts",
		rotation = "random",
		flags = "place_center_x, place_center_z",
	})

	-- Oak
	-- Large oaks
	for i=1, 4 do
		minetest.register_decoration({
			deco_type = "schematic",
			place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
			sidelen = 80,
			noise_params = {
				offset = 0.000545,
				scale = 0.0011,
				spread = {x = 250, y = 250, z = 250},
				seed = 3 + 5 * i,
				octaves = 3,
				persist = 0.66
			},
			biomes = {"Forest"},
			y_min = 1,
			y_max = mcl_vars.mg_overworld_max,
			schematic = mod_mcl_core.."/schematics/mcl_core_oak_large_"..i..".mts",
			flags = "place_center_x, place_center_z",
			rotation = "random",
		})

		minetest.register_decoration({
			deco_type = "schematic",
			place_on = {"group:grass_block", "mcl_core:dirt", },
			sidelen = 80,
			noise_params = {
				offset = -0.0007,
				scale = 0.001,
				spread = {x = 250, y = 250, z = 250},
				seed = 3,
				octaves = 3,
				persist = 0.6
			},
			biomes = {"ExtremeHills", "ExtremeHillsM", "ExtremeHills+", "ExtremeHills+_snowtop"},
			y_min = 1,
			y_max = mcl_vars.mg_overworld_max,
			schematic = mod_mcl_core.."/schematics/mcl_core_oak_large_"..i..".mts",
			flags = "place_center_x, place_center_z",
			rotation = "random",
		})
	end
	-- Small “classic” oak (many biomes)
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 16,
		noise_params = {
			offset = 0.025,
			scale = 0.0022,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.66
		},
		biomes = {"Forest"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 16,
		noise_params = {
			offset = 0.01,
			scale = 0.0022,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.66
		},
		biomes = {"FlowerForest"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block", "mcl_core:dirt", },
		sidelen = 16,
		noise_params = {
			offset = 0.0,
			scale = 0.002,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.7
		},
		biomes = {"ExtremeHills", "ExtremeHillsM", "ExtremeHills+", "ExtremeHills+_snowtop"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})

	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block", "mcl_core:dirt"},
		sidelen = 16,
		noise_params = {
			offset = 0.006,
			scale = 0.002,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.7
		},
		biomes = {"ExtremeHills+", "ExtremeHills+_snowtop"},
		y_min = 50,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_core:dirt_with_grass", "mcl_core:dirt"},
		sidelen = 16,
		noise_params = {
			offset = 0.015,
			scale = 0.002,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.7
		},
		biomes = {"MesaPlateauF_grasstop"},
		y_min = 30,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_core:dirt_with_grass", "mcl_core:dirt"},
		sidelen = 16,
		noise_params = {
			offset = 0.008,
			scale = 0.002,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.7
		},
		biomes = {"MesaPlateauFM_grasstop"},
		y_min = 30,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})

	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block", "mcl_core:dirt", },
		sidelen = 16,
		noise_params = {
			offset = 0.0,
			scale = 0.0002,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.7
		},
		biomes = {"IcePlains"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.004,
		biomes = {"Jungle", "JungleM"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.0004,
		biomes = {"BambooJungle", "JungleEdge", "JungleEdgeM", "Savanna"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})

	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt", "mcl_mud:mud"},
		fill_ratio = 0.004,
		height = 7,
		height_max = 15,
		biomes = {"BambooJungle", "Jungle", "JungleM", "JungleEdge", "MangroveSwamp"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		param2 = 0,
		param2_max = 3,
		decoration = "mcl_bamboo:bamboo" ,
	})
	for i=1,3 do
		minetest.register_decoration({
			deco_type = "simple",
			place_on = {"group:grass_block_no_snow", "mcl_core:dirt", "mcl_mud:mud"},
			fill_ratio = 0.004+(i*0.001),
			height = 7,
			height_max = 15,
			param2 = 0,
			param2_max = 3,
			biomes = {"BambooJungle", "Jungle", "JungleM", "JungleEdge", "MangroveSwamp"},
			y_min = 1,
			y_max = mcl_vars.mg_overworld_max,
			decoration = "mcl_bamboo:bamboo"..i,
		})
	end

	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt", "mcl_mud:mud"},
		fill_ratio = 0.1,
		height = 7,
		height_max = 15,
		biomes = { "BambooJungle" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		param2 = 0,
		param2_max = 3,
		decoration = "mcl_bamboo:bamboo" ,
	})
	for i=1,3 do
		minetest.register_decoration({
			deco_type = "simple",
			place_on = {"group:grass_block_no_snow", "mcl_core:dirt", "mcl_mud:mud"},
			fill_ratio = 0.1+(i*0.001),
			height = 7,
			height_max = 15,
			param2 = 0,
			param2_max = 3,
			biomes = { "BambooJungle" },
			y_min = 1,
			y_max = mcl_vars.mg_overworld_max,
			decoration = "mcl_bamboo:bamboo"..i,
		})
	end

	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 16,
		--[[noise_params = {
			offset = 0.01,
			scale = 0.00001,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.33
		},]]--
		fill_ratio = 0.0002,
		biomes = {"FlowerForest"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic_bee_nest.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
		spawn_by = "group:flower",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 16,
		--[[noise_params = {
			offset = 0.01,
			scale = 0.00001,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.33
		},]]--
		fill_ratio = 0.00002,
		biomes = {"Forest"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_classic_bee_nest.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
		spawn_by = "group:flower",
	})

	-- Rare balloon oak
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 16,
		noise_params = {
			offset = 0.002083,
			scale = 0.0022,
			spread = {x = 250, y = 250, z = 250},
			seed = 3,
			octaves = 3,
			persist = 0.6,
		},
		biomes = {"Forest"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_balloon.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})

	-- Swamp oak
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		noise_params = {
			offset = 0.0055,
			scale = 0.0011,
			spread = {x = 250, y = 250, z = 250},
			seed = 5005,
			octaves = 5,
			persist = 0.6,
		},
		biomes = {"Swampland", "Swampland_shore"},
		y_min = 0,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_oak_swamp.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})

	minetest.register_decoration({
		name = "mcl_biomes:mangrove_tree_1",
		deco_type = "schematic",
		place_on = {"mcl_mud:mud"},
		sidelen = 80,
		fill_ratio = 0.0065,
		biomes = {"MangroveSwamp","MangroveSwamp_shore"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mangrove.."/schematics/mcl_mangrove_tree_1.mts",
		flags = "place_center_x, place_center_z, force_placement",
		rotation = "random",
	})
	minetest.register_decoration({
		name = "mcl_biomes:mangrove_tree_2",
		deco_type = "schematic",
		place_on = {"mcl_mud:mud"},
		sidelen = 80,
		fill_ratio = 0.0045,
		biomes = {"MangroveSwamp","MangroveSwamp_shore"},
		y_min = -1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mangrove.."/schematics/mcl_mangrove_tree_2.mts",
		flags = "place_center_x, place_center_z, force_placement",
		rotation = "random",
	})
	minetest.register_decoration({
		name = "mcl_biomes:mangrove_tree_3",
		deco_type = "schematic",
		place_on = {"mcl_mud:mud"},
		sidelen = 80,
		fill_ratio = 0.023,
		biomes = {"MangroveSwamp","MangroveSwamp_shore"},
		y_min = -1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mangrove.."/schematics/mcl_mangrove_tree_3.mts",
		flags = "place_center_x, place_center_z, force_placement",
		rotation = "random",
	})
	minetest.register_decoration({
		name = "mcl_biomes:mangrove_tree_4",
		deco_type = "schematic",
		place_on = {"mcl_mud:mud"},
		sidelen = 80,
		fill_ratio = 0.023,
		biomes = {"MangroveSwamp","MangroveSwamp_shore"},
		y_min = -1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mangrove.."/schematics/mcl_mangrove_tree_4.mts",
		flags = "place_center_x, place_center_z, force_placement",
		rotation = "random",
	})
	minetest.register_decoration({
		name = "mcl_biomes:mangrove_tree_5",
		deco_type = "schematic",
		place_on = {"mcl_mud:mud"},
		sidelen = 80,
		fill_ratio = 0.023,
		biomes = {"MangroveSwamp","MangroveSwamp_shore"},
		y_min = -1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mangrove.."/schematics/mcl_mangrove_tree_5.mts",
		flags = "place_center_x, place_center_z, force_placement",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_mud:mud"},
		sidelen = 80,
		--[[noise_params = {
			offset = 0.01,
			scale = 0.00001,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.33
		},]]--
		fill_ratio = 0.0005,
		biomes = {"MangroveSwamp"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mangrove.."/schematics/mcl_mangrove_bee_nest.mts",
		flags = "place_center_x, place_center_z, force_placement",
		rotation = "random",
		spawn_by = "group:flower",
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_mud:mud"},
		sidelen = 80,
		fill_ratio = 0.045,
		biomes = {"MangroveSwamp","MangroveSwamp_shore"},
		y_min = 0,
		y_max = 0,
		decoration = "mcl_mangrove:water_logged_roots",
		flags = "place_center_x, place_center_z, force_placement",
	})

	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_mangrove:mangrove_roots"},
		spawn_by = {"group:water"},
		num_spawn_by = 2,
		sidelen = 80,
		fill_ratio = 10,
		biomes = {"MangroveSwamp","MangroveSwamp_shore"},
		y_min = 0,
		y_max = 0,
		decoration = "mcl_mangrove:water_logged_roots",
		flags = "place_center_x, place_center_z, force_placement, all_ceilings",
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_mud:mud"},
		sidelen = 80,
		fill_ratio = 0.045,
		biomes = {"MangroveSwamp","MangroveSwamp_shore"},
		place_offset_y = -1,
		decoration = "mcl_mangrove:mangrove_mud_roots",
		flags = "place_center_x, place_center_z, force_placement",
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_mud:mud"},
		sidelen = 80,
		fill_ratio = 0.008,
		biomes = {"MangroveSwamp","MangroveSwamp_shore"},
		decoration = "mcl_core:deadbush",
		flags = "place_center_x, place_center_z",
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_core:water_source"},
		sidelen = 80,
		fill_ratio = 0.035,
		biomes = {"MangroveSwamp","MangroveSwamp_shore"},
		decoration = "mcl_flowers:waterlily",
		flags = "place_center_x, place_center_z, liquid_surface",
	})

	-- Jungle tree

	-- Huge jungle tree (4 variants)
	for i=1, 4 do
		minetest.register_decoration({
			deco_type = "schematic",
			place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
			sidelen = 80,
			fill_ratio = 0.0008,
			biomes = {"Jungle"},
			y_min = 4,
			y_max = mcl_vars.mg_overworld_max,
			schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree_huge_"..i..".mts",
			flags = "place_center_x, place_center_z",
			rotation = "random",
		})
		minetest.register_decoration({
			deco_type = "schematic",
			place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
			sidelen = 80,
			fill_ratio = 0.003,
			biomes = {"JungleM"},
			y_min = 4,
			y_max = mcl_vars.mg_overworld_max,
			schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree_huge_"..i..".mts",
			flags = "place_center_x, place_center_z",
			rotation = "random",
		})
	end

	-- Common jungle tree
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.025,
		biomes = {"Jungle"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.015,
		biomes = {"Jungle"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree_2.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.005,
		biomes = {"Jungle"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree_3.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.005,
		biomes = {"Jungle"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree_4.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.025,
		biomes = {"Jungle"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.0045,
		biomes = {"BambooJungle", "JungleEdge", "JungleEdgeM"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})

	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		fill_ratio = 0.09,
		biomes = {"JungleM"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_tree_2.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})
	-- Spruce
	local function quick_spruce(seed, offset, sprucename, biomes, y)
		if not y then
			y = 1
		end
		minetest.register_decoration({
			deco_type = "schematic",
			place_on = {"group:grass_block", "mcl_core:dirt", "mcl_core:podzol"},
			sidelen = 16,
			noise_params = {
				offset = offset,
				scale = 0.0006,
				spread = {x = 250, y = 250, z = 250},
				seed = seed,
				octaves = 3,
				persist = 0.66
			},
			biomes = biomes,
			y_min = y,
			y_max = mcl_vars.mg_overworld_max,
			schematic = mod_mcl_core.."/schematics/"..sprucename,
			flags = "place_center_x, place_center_z",
		})
	end

	-- Huge spruce
	quick_spruce(3000, 0.0030, "mcl_core_spruce_huge_1.mts", {"MegaSpruceTaiga"})
	quick_spruce(4000, 0.0036, "mcl_core_spruce_huge_2.mts", {"MegaSpruceTaiga"})
	quick_spruce(6000, 0.0036, "mcl_core_spruce_huge_3.mts", {"MegaSpruceTaiga"})
	quick_spruce(6600, 0.0036, "mcl_core_spruce_huge_4.mts", {"MegaSpruceTaiga"})

	quick_spruce(3000, 0.0008, "mcl_core_spruce_huge_up_1.mts", {"MegaTaiga"})
	quick_spruce(4000, 0.0008, "mcl_core_spruce_huge_up_2.mts", {"MegaTaiga"})
	quick_spruce(6000, 0.0008, "mcl_core_spruce_huge_up_3.mts", {"MegaTaiga"})


	-- Common spruce
	quick_spruce(11000, 0.00150, "mcl_core_spruce_5.mts", {"Taiga", "ColdTaiga"})

	quick_spruce(2500, 0.00325, "mcl_core_spruce_1.mts", {"MegaSpruceTaiga", "MegaTaiga", "Taiga", "ColdTaiga"})
	quick_spruce(7000, 0.00425, "mcl_core_spruce_3.mts", {"MegaSpruceTaiga", "MegaTaiga", "Taiga", "ColdTaiga"})
	quick_spruce(9000, 0.00325, "mcl_core_spruce_4.mts", {"MegaTaiga", "Taiga", "ColdTaiga"})

	quick_spruce(9500, 0.00500, "mcl_core_spruce_tall.mts", {"MegaTaiga"})

	quick_spruce(5000, 0.00250, "mcl_core_spruce_2.mts", {"MegaSpruceTaiga", "MegaTaiga"})

	quick_spruce(11000, 0.000025, "mcl_core_spruce_5.mts", {"ExtremeHills", "ExtremeHillsM"})
	quick_spruce(2500, 0.00005, "mcl_core_spruce_1.mts", {"ExtremeHills", "ExtremeHillsM"})
	quick_spruce(7000, 0.00005, "mcl_core_spruce_3.mts", {"ExtremeHills", "ExtremeHillsM"})
	quick_spruce(9000, 0.00005, "mcl_core_spruce_4.mts", {"ExtremeHills", "ExtremeHillsM"})

	quick_spruce(11000, 0.001, "mcl_core_spruce_5.mts", {"ExtremeHills+", "ExtremeHills+_snowtop"}, 50)
	quick_spruce(2500, 0.002, "mcl_core_spruce_1.mts", {"ExtremeHills+", "ExtremeHills+_snowtop"}, 50)
	quick_spruce(7000, 0.003, "mcl_core_spruce_3.mts", {"ExtremeHills+", "ExtremeHills+_snowtop"}, 50)
	quick_spruce(9000, 0.002, "mcl_core_spruce_4.mts", {"ExtremeHills+", "ExtremeHills+_snowtop"}, 50)


	-- Small lollipop spruce
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block", "mcl_core:podzol"},
		sidelen = 16,
		noise_params = {
			offset = 0.004,
			scale = 0.0022,
			spread = {x = 250, y = 250, z = 250},
			seed = 2500,
			octaves = 3,
			persist = 0.66
		},
		biomes = {"Taiga", "ColdTaiga"},
		y_min = 2,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_spruce_lollipop.mts",
		flags = "place_center_x, place_center_z",
	})

	-- Matchstick spruce: Very few leaves, tall trunk
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block", "mcl_core:podzol"},
		sidelen = 80,
		noise_params = {
			offset = -0.025,
			scale = 0.025,
			spread = {x = 250, y = 250, z = 250},
			seed = 2566,
			octaves = 5,
			persist = 0.60,
		},
		biomes = {"Taiga", "ColdTaiga"},
		y_min = 3,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_spruce_matchstick.mts",
		flags = "place_center_x, place_center_z",
	})

	-- Rare spruce in Ice Plains
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block"},
		sidelen = 16,
		noise_params = {
			offset = -0.00075,
			scale = -0.0015,
			spread = {x = 250, y = 250, z = 250},
			seed = 11,
			octaves = 3,
			persist = 0.7
		},
		biomes = {"IcePlains"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_spruce_5.mts",
		flags = "place_center_x, place_center_z",
	})

	-- Acacia (many variants)
	for a=1, 7 do
		minetest.register_decoration({
			deco_type = "schematic",
			place_on = {"mcl_core:dirt_with_grass", "mcl_core:dirt", "mcl_core:coarse_dirt"},
			sidelen = 16,
			fill_ratio = 0.0002,
			biomes = {"Savanna", "SavannaM"},
			y_min = 1,
			y_max = mcl_vars.mg_overworld_max,
			schematic = mod_mcl_core.."/schematics/mcl_core_acacia_"..a..".mts",
			flags = "place_center_x, place_center_z",
			rotation = "random",
		})
	end

	-- Birch
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow"},
		sidelen = 16,
		noise_params = {
			offset = 0.03,
			scale = 0.0025,
			spread = {x = 250, y = 250, z = 250},
			seed = 11,
			octaves = 3,
			persist = 0.66
		},
		biomes = {"BirchForest"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_birch.mts",
		flags = "place_center_x, place_center_z",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow"},
		sidelen = 16,
		noise_params = {
			offset = 0.03,
			scale = 0.0025,
			spread = {x = 250, y = 250, z = 250},
			seed = 11,
			octaves = 3,
			persist = 0.66
		},
		biomes = {"BirchForestM"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_birch_tall.mts",
		flags = "place_center_x, place_center_z",
	})

	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 16,
		noise_params = {
			offset = 0.000333,
			scale = -0.0015,
			spread = {x = 250, y = 250, z = 250},
			seed = 11,
			octaves = 3,
			persist = 0.66
		},
		biomes = {"Forest", "FlowerForest"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_birch.mts",
		flags = "place_center_x, place_center_z",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 16,
		--[[noise_params = {
			offset = 0.01,
			scale = 0.00001,
			spread = {x = 250, y = 250, z = 250},
			seed = 2,
			octaves = 3,
			persist = 0.33
		},]]--
		fill_ratio = 0.00002,
		biomes = {"Forest", "BirchForest", "BirchForestM"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_birch_bee_nest.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
		spawn_by = "group:flower",
	})

	-- Dark Oak
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow"},
		sidelen = 16,
		noise_params = {
			offset = 0.05,
			scale = 0.0015,
			spread = {x = 125, y = 125, z = 125},
			seed = 223,
			octaves = 3,
			persist = 0.66
		},
		biomes = {"RoofedForest"},
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_dark_oak.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})

	-- Cherry
	for i=1,3 do
		minetest.register_decoration({
			deco_type = "schematic",
			place_on = {"mcl_core:dirt_with_grass"},
			sidelen = 80,
			noise_params = {
				offset = 0.007,
				scale = 0.08,
				spread = {x = 250, y = 250, z = 250},
				seed = 13+i,
				octaves = 3,
				persist = 0.6
			},
			biomes = {"CherryGrove"},
			y_min = 1,
			y_max = mcl_vars.mg_overworld_max,
			schematic = mod_cherry_blossom.."/schematics/mcl_cherry_blossom_tree_"..i..".mts",
			flags = "place_center_x, place_center_z",
			rotation = "random",
		})
		minetest.register_decoration({
			deco_type = "schematic",
			place_on = {"mcl_core:dirt_with_grass"},
			sidelen = 80,
			noise_params = {
				offset = 0.0005,
				scale = 0.0001,
				spread = {x = 250, y = 250, z = 250},
				seed = 32+i,
				octaves = 3,
				persist = 0.01
			},
			biomes = {"CherryGrove"},
			y_min = 1,
			y_max = mcl_vars.mg_overworld_max,
			schematic = mod_cherry_blossom.."/schematics/mcl_cherry_blossom_tree_beehive_"..i..".mts",
			flags = "place_center_x, place_center_z",
			rotation = "random",
		})
	end


	local ratio_mushroom = 0.0001
	local ratio_mushroom_huge = ratio_mushroom * (11/12)
	local ratio_mushroom_giant = ratio_mushroom * (1/12)
	local ratio_mushroom_mycelium = 0.002
	local ratio_mushroom_mycelium_huge = ratio_mushroom_mycelium * (11/12)
	local ratio_mushroom_mycelium_giant = ratio_mushroom_mycelium * (1/12)

	-- Huge Brown Mushroom
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = { "group:grass_block_no_snow", "mcl_core:dirt" },
		sidelen = 80,
		fill_ratio = ratio_mushroom_huge,
		biomes = { "RoofedForest" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mushrooms.."/schematics/mcl_mushrooms_huge_brown.mts",
		flags = "place_center_x, place_center_z",
		rotation = "0",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = { "group:grass_block_no_snow", "mcl_core:dirt" },
		sidelen = 80,
		fill_ratio = ratio_mushroom_giant,
		biomes = { "RoofedForest" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mushrooms.."/schematics/mcl_mushrooms_giant_brown.mts",
		flags = "place_center_x, place_center_z",
		rotation = "0",
	})

	minetest.register_decoration({
		deco_type = "schematic",
		place_on = { "mcl_core:mycelium" },
		sidelen = 80,
		fill_ratio = ratio_mushroom_mycelium_huge,
		biomes = { "MushroomIsland", "MushroomIslandShore" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mushrooms.."/schematics/mcl_mushrooms_huge_brown.mts",
		flags = "place_center_x, place_center_z",
		rotation = "0",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = { "mcl_core:mycelium" },
		sidelen = 80,
		fill_ratio = ratio_mushroom_mycelium_giant,
		biomes = { "MushroomIsland", "MushroomIslandShore" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mushrooms.."/schematics/mcl_mushrooms_giant_brown.mts",
		flags = "place_center_x, place_center_z",
		rotation = "0",
	})

	-- Huge Red Mushroom
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = { "group:grass_block_no_snow", "mcl_core:dirt" },
		sidelen = 80,
		fill_ratio = ratio_mushroom_huge,
		biomes = { "RoofedForest" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mushrooms.."/schematics/mcl_mushrooms_huge_red.mts",
		flags = "place_center_x, place_center_z",
		rotation = "0",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = { "group:grass_block_no_snow", "mcl_core:dirt" },
		sidelen = 80,
		fill_ratio = ratio_mushroom_giant,
		biomes = { "RoofedForest" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mushrooms.."/schematics/mcl_mushrooms_giant_red.mts",
		flags = "place_center_x, place_center_z",
		rotation = "0",
	})

	minetest.register_decoration({
		deco_type = "schematic",
		place_on = { "mcl_core:mycelium" },
		sidelen = 80,
		fill_ratio = ratio_mushroom_mycelium_huge,
		biomes = { "MushroomIsland", "MushroomIslandShore" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mushrooms.."/schematics/mcl_mushrooms_huge_red.mts",
		flags = "place_center_x, place_center_z",
		rotation = "0",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = { "mcl_core:mycelium" },
		sidelen = 80,
		fill_ratio = ratio_mushroom_mycelium_giant,
		biomes = { "MushroomIsland", "MushroomIslandShore" },
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_mushrooms.."/schematics/mcl_mushrooms_giant_red.mts",
		flags = "place_center_x, place_center_z",
		rotation = "0",
	})

	--Snow on snowy dirt
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_core:dirt_with_grass_snow"},
		sidelen = 80,
		fill_ratio = 10,
		flags = "all_floors",
		y_min = mcl_vars.mg_overworld_min,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_core:snow",
	})

	--Mushrooms in caves
	minetest.register_decoration({
		deco_type = "simple",
		place_on = table.merge(stonelike, {"mcl_deepslate:deepslate"}),
		sidelen = 80,
		fill_ratio = 0.009,
		noise_threshold = 2.0,
		flags = "all_floors",
		y_min = mcl_vars.mg_overworld_min,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_mushrooms:mushroom_red",
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = table.merge(stonelike, {"mcl_deepslate:deepslate"}),
		sidelen = 80,
		fill_ratio = 0.009,
		noise_threshold = 2.0,
		y_min = mcl_vars.mg_overworld_min,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_mushrooms:mushroom_brown",
	})

	-- Mossy cobblestone boulder (3×3)
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_core:podzol", "mcl_core:dirt", "mcl_core:coarse_dirt"},
		sidelen = 80,
		noise_params = {
			offset = 0.00015,
			scale = 0.001,
			spread = {x = 300, y = 300, z = 300},
			seed = 775703,
			octaves = 4,
			persist = 0.63,
		},
		biomes = {"MegaTaiga", "MegaSpruceTaiga"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_structures.."/schematics/mcl_structures_boulder.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})

	-- Small mossy cobblestone boulder (2×2)
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_core:podzol", "mcl_core:dirt", "mcl_core:coarse_dirt"},
		sidelen = 80,
		noise_params = {
			offset = 0.001,
			scale = 0.001,
			spread = {x = 300, y = 300, z = 300},
			seed = 775703,
			octaves = 4,
			persist = 0.63,
		},
		biomes = {"MegaTaiga", "MegaSpruceTaiga"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_structures.."/schematics/mcl_structures_boulder_small.mts",
		flags = "place_center_x, place_center_z",
		rotation = "random",
	})

	-- Cacti
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"group:sand"},
		sidelen = 16,
		noise_params = {
			offset = -0.012,
			scale = 0.024,
			spread = {x = 100, y = 100, z = 100},
			seed = 257,
			octaves = 3,
			persist = 0.6
		},
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_core:cactus",
		biomes = {"Desert",
			"Mesa","Mesa_sandlevel",
			"MesaPlateauF","MesaPlateauF_sandlevel",
			"MesaPlateauFM","MesaPlateauFM_sandlevel"},
		height = 1,
		height_max = 3,
	})

	-- Sugar canes
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_core:dirt", "mcl_core:coarse_dirt", "group:grass_block_no_snow", "group:sand", "mcl_core:podzol", "mcl_core:reeds"},
		sidelen = 16,
		noise_params = {
			offset = -0.3,
			scale = 0.7,
			spread = {x = 200, y = 200, z = 200},
			seed = 2,
			octaves = 3,
			persist = 0.7
		},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_core:reeds",
		height = 1,
		height_max = 3,
		spawn_by = { "mcl_core:water_source", "group:frosted_ice" },
		num_spawn_by = 1,
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_core:dirt", "mcl_core:coarse_dirt", "group:grass_block_no_snow", "group:sand", "mcl_core:podzol", "mcl_core:reeds"},
		sidelen = 16,
		noise_params = {
			offset = 0.0,
			scale = 0.5,
			spread = {x = 200, y = 200, z = 200},
			seed = 2,
			octaves = 3,
			persist = 0.7,
		},
		biomes = {"Swampland", "Swampland_shore"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_core:reeds",
		height = 1,
		height_max = 3,
		spawn_by = { "mcl_core:water_source", "group:frosted_ice" },
		num_spawn_by = 1,
	})

	-- Doubletall grass
	function mcl_biomes.register_doubletall_grass(offset, scale, biomes)

		for b=1, #biomes do
			local param2 = minetest.registered_biomes[biomes[b]]._mcl_palette_index
			minetest.register_decoration({
				deco_type = "schematic",
				schematic = {
					size = { x=1, y=3, z=1 },
					data = {
						{ name = "air", prob = 0 },
						{ name = "mcl_flowers:double_grass", param1=255, param2=param2 },
						{ name = "mcl_flowers:double_grass_top", param1=255, param2=param2 },
					},
				},
				place_on = {"group:grass_block_no_snow"},
				sidelen = 16,
				noise_params = {
					offset = offset,
					scale = scale,
					spread = {x = 200, y = 200, z = 200},
					seed = 420,
					octaves = 3,
					persist = 0.6,
				},
				y_min = 1,
				y_max = mcl_vars.mg_overworld_max,
				biomes = { biomes[b] },
			})
		end
	end

	local register_doubletall_grass = mcl_biomes.register_doubletall_grass

	register_doubletall_grass(-0.01, 0.03, {"Taiga", "Forest", "FlowerForest", "BirchForest", "BirchForestM", "RoofedForest"})
	register_doubletall_grass(-0.002, 0.03, {"Plains", "SunflowerPlains", "CherryGrove"})
	register_doubletall_grass(-0.0005, -0.03, {"Savanna", "SavannaM"})

	-- Large ferns
	function mcl_biomes.register_double_fern(offset, scale, biomes)
		for b=1, #biomes do
			local param2 = minetest.registered_biomes[biomes[b]]._mcl_palette_index
			minetest.register_decoration({
				deco_type = "schematic",
				schematic = {
					size = { x=1, y=3, z=1 },
					data = {
						{ name = "air", prob = 0 },
						{ name = "mcl_flowers:double_fern", param1=255, param2=param2 },
						{ name = "mcl_flowers:double_fern_top", param1=255, param2=param2 },
					},
				},
				place_on = {"group:grass_block_no_snow", "mcl_core:podzol"},
				sidelen = 16,
				noise_params = {
					offset = offset,
					scale = scale,
					spread = {x = 250, y = 250, z = 250},
					seed = 333,
					octaves = 2,
					persist = 0.66,
				},
				y_min = 1,
				y_max = mcl_vars.mg_overworld_max,
				biomes = biomes[b],
			})
		end
	end

	local register_double_fern = mcl_biomes.register_double_fern

	register_double_fern(0.01, 0.03, { "BambooJungle", "Jungle", "JungleM", "JungleEdge", "JungleEdgeM", "Taiga", "ColdTaiga", "MegaTaiga", "MegaSpruceTaiga" })
	register_double_fern(0.15, 0.1, { "JungleM" })

	-- Large flowers
	function mcl_biomes.register_large_flower(name, biomes, seed, offset, flower_forest_offset)
		local maxi
		if flower_forest_offset then
			maxi = 2
		else
			maxi = 1
		end
		for i=1, maxi do
			local o, b -- offset, biomes
			if i == 1 then
				o = offset
				b = biomes
			else
				o = flower_forest_offset
				b = { "FlowerForest" }
			end

			minetest.register_decoration({
				deco_type = "schematic",
				schematic = {
					size = {x = 1, y = 3, z = 1},
					data = {
						{name = "air", prob = 0},
						{name = "mcl_flowers:" .. name, param1 = 255, },
						{name = "mcl_flowers:" .. name .. "_top", param1 = 255, },
					},
				},
				place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},

				sidelen = 16,
				noise_params = {
					offset = o,
					scale = 0.01,
					spread = {x = 300, y = 300, z = 300},
					seed = seed,
					octaves = 5,
					persist = 0.62,
				},
				y_min = 1,
				y_max = mcl_vars.mg_overworld_max,
				flags = "",
				biomes = b,
			})
		end
	end

	local register_large_flower = mcl_biomes.register_large_flower

	register_large_flower("rose_bush", {"Forest"}, 9350, -0.008, 0.003)
	register_large_flower("peony", {"Forest"}, 10450, -0.008, 0.003)
	register_large_flower("lilac", {"Forest"}, 10600, -0.007, 0.003)
	register_large_flower("sunflower", {"SunflowerPlains"}, 2940, 0.01)

	-- Jungle bush

	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		noise_params = {
			offset = 0.0196,
			scale = 0.015,
			spread = {x = 250, y = 250, z = 250},
			seed = 2930,
			octaves = 4,
			persist = 0.6,
		},
		biomes = {"Jungle"},
		y_min = 3,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_bush_oak_leaves.mts",
		flags = "place_center_x, place_center_z",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		noise_params = {
			offset = 0.0196,
			scale = 0.005,
			spread = {x = 250, y = 250, z = 250},
			seed = 2930,
			octaves = 4,
			persist = 0.6,
		},
		biomes = {"Jungle"},
		y_min = 3,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_bush_oak_leaves_2.mts",
		flags = "place_center_x, place_center_z",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		noise_params = {
			offset = 0.05,
			scale = 0.025,
			spread = {x = 250, y = 250, z = 250},
			seed = 2930,
			octaves = 4,
			persist = 0.6,
		},
		biomes = {"JungleM"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_bush_oak_leaves.mts",
		flags = "place_center_x, place_center_z",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
		sidelen = 80,
		noise_params = {
			offset = 0.0085,
			scale = 0.025,
			spread = {x = 250, y = 250, z = 250},
			seed = 2930,
			octaves = 4,
			persist = 0.6,
		},
		biomes = { "BambooJungle", "JungleEdge", "JungleEdgeM"},
		y_min = 3,
		y_max = mcl_vars.mg_overworld_max,
		schematic = mod_mcl_core.."/schematics/mcl_core_jungle_bush_oak_leaves.mts",
		flags = "place_center_x, place_center_z",
	})

	-- Lily pad

	local lily_schem = {
		{ name = "mcl_core:water_source" },
		{ name = "mcl_flowers:waterlily" },
	}

	-- Spawn them in shallow water at ocean level in Swampland.
	-- Tweak lilydepth to change the maximum water depth
	local lilydepth = 2

	for d=1, lilydepth do
		local height = d + 2
		local y = 1 - d
		table.insert(lily_schem, 1, { name = "air", prob = 0 })

		minetest.register_decoration({
			deco_type = "schematic",
			schematic = {
				size = { x=1, y=height, z=1 },
				data = lily_schem,
			},
			place_on = "mcl_core:dirt",
			sidelen = 16,
			noise_params = {
				offset = 0,
				scale = 0.3,
				spread = {x = 100, y = 100, z = 100},
				seed = 503,
				octaves = 6,
				persist = 0.7,
			},
			y_min = y,
			y_max = y,
			biomes = { "Swampland_shore" },
			rotation = "random",
		})
	end

	-- Melon
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"group:grass_block_no_snow"},
		sidelen = 16,
		noise_params = {
			offset = -0.01,
			scale = 0.006,
			spread = {x = 250, y = 250, z = 250},
			seed = 333,
			octaves = 3,
			persist = 0.6
		},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_farming:melon",
		biomes = { "Jungle" },
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"group:grass_block_no_snow"},
		sidelen = 16,
		noise_params = {
			offset = 0.0,
			scale = 0.006,
			spread = {x = 250, y = 250, z = 250},
			seed = 333,
			octaves = 3,
			persist = 0.6
		},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_farming:melon",
		biomes = { "JungleM" },
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"group:grass_block_no_snow"},
		sidelen = 16,
		noise_params = {
			offset = -0.005,
			scale = 0.006,
			spread = {x = 250, y = 250, z = 250},
			seed = 333,
			octaves = 3,
			persist = 0.6
		},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_farming:melon",
		biomes = { "BambooJungle", "JungleEdge", "JungleEdgeM" },
	})

	-- Lots of melons in Jungle Edge M
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"group:grass_block_no_snow"},
		sidelen = 80,
		noise_params = {
			offset = 0.013,
			scale = 0.006,
			spread = {x = 125, y = 125, z = 125},
			seed = 333,
			octaves = 3,
			persist = 0.6
		},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_farming:melon",
		biomes = { "JungleEdgeM" },
	})

	-- Pumpkin
	minetest.register_decoration({
		deco_type = "simple",
		decoration = "mcl_farming:pumpkin",
		param2 = 0,
		param2_max = 3,
		place_on = {"group:grass_block_no_snow"},
		sidelen = 16,
		noise_params = {
			offset = -0.016,
			scale = 0.01332,
			spread = {x = 125, y = 125, z = 125},
			seed = 666,
			octaves = 6,
			persist = 0.666
		},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
	})

	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_core:dirt_with_grass"},
		fill_ratio = 0.6,
		biomes = {"CherryGrove"},
		y_min = mcl_vars.mg_overworld_min,
		y_max = mcl_vars.mg_overworld_max,
		decoration = "mcl_cherry_blossom:pink_petals",
	})

	-- Grasses and ferns
	local grass_forest = {"Plains", "Taiga", "Forest", "FlowerForest", "BirchForest", "BirchForestM", "RoofedForest", "Swampland" }
	local grass_mpf = {"MesaPlateauF_grasstop"}
	local grass_plains = {"Plains", "SunflowerPlains", "BambooJungle", "JungleEdge", "JungleEdgeM", "MangroveSwamp", "CherryGrove" }
	local grass_savanna = {"Savanna", "SavannaM"}
	local grass_sparse = {"ExtremeHills", "ExtremeHills+", "ExtremeHills+_snowtop", "ExtremeHillsM", "Jungle" }
	local grass_mpfm = {"MesaPlateauFM_grasstop" }

	register_grass_decoration("tallgrass", -0.03,  0.09, grass_forest)
	register_grass_decoration("tallgrass", -0.015, 0.075, grass_forest)
	register_grass_decoration("tallgrass", 0,      0.06, grass_forest)
	register_grass_decoration("tallgrass", 0.015,  0.045, grass_forest)
	register_grass_decoration("tallgrass", 0.03,   0.03, grass_forest)
	register_grass_decoration("tallgrass", -0.03, 0.09, grass_mpf)
	register_grass_decoration("tallgrass", -0.015, 0.075, grass_mpf)
	register_grass_decoration("tallgrass", 0, 0.06, grass_mpf)
	register_grass_decoration("tallgrass", 0.01, 0.045, grass_mpf)
	register_grass_decoration("tallgrass", 0.01, 0.05, grass_forest)
	register_grass_decoration("tallgrass", 0.03, 0.03, grass_plains)
	register_grass_decoration("tallgrass", 0.05, 0.01, grass_plains)
	register_grass_decoration("tallgrass", 0.07, -0.01, grass_plains)
	register_grass_decoration("tallgrass", 0.09, -0.03, grass_plains)
	register_grass_decoration("tallgrass", 0.18, -0.03, grass_savanna)
	register_grass_decoration("tallgrass", 0.05, -0.03, grass_sparse)
	register_grass_decoration("tallgrass", 0.05, 0.05, grass_mpfm)

	local fern_minimal = { "Jungle", "JungleM", "BambooJungle", "JungleEdge", "JungleEdgeM", "Taiga", "MegaTaiga", "MegaSpruceTaiga", "ColdTaiga", "MangroveSwamp" }
	local fern_low = { "Jungle", "JungleM", "BambooJungle", "JungleEdge", "JungleEdgeM", "Taiga", "MegaTaiga", "MegaSpruceTaiga" }
	local fern_Jungle = { "Jungle", "JungleM", "BambooJungle", "JungleEdge", "JungleEdgeM" }
	--local fern_JungleM = { "JungleM" },

	register_grass_decoration("fern", -0.03,  0.09, fern_minimal)
	register_grass_decoration("fern", -0.015, 0.075, fern_minimal)
	register_grass_decoration("fern", 0,      0.06, fern_minimal)
	register_grass_decoration("fern", 0.015,  0.045, fern_low)
	register_grass_decoration("fern", 0.03,   0.03, fern_low)
	register_grass_decoration("fern", 0.01, 0.05, fern_Jungle)
	register_grass_decoration("fern", 0.03, 0.03, fern_Jungle)
	register_grass_decoration("fern", 0.05, 0.01, fern_Jungle)
	register_grass_decoration("fern", 0.07, -0.01, fern_Jungle)
	register_grass_decoration("fern", 0.09, -0.03, fern_Jungle)
	register_grass_decoration("fern", 0.12, -0.03, {"JungleM"})

	local b_seagrass = {"ColdTaiga_ocean","ExtremeHills_ocean","ExtremeHillsM_ocean","ExtremeHills+_ocean","Taiga_ocean","MegaTaiga_ocean","MegaSpruceTaiga_ocean","StoneBeach_ocean","Plains_ocean","SunflowerPlains_ocean","Forest_ocean","FlowerForest_ocean","BirchForest_ocean","BirchForestM_ocean","RoofedForest_ocean","Swampland_ocean","Jungle_ocean","JungleM_ocean","BambooJungle_ocean", "JungleEdge_ocean","JungleEdgeM_ocean","MushroomIsland_ocean","Desert_ocean","Savanna_ocean","SavannaM_ocean","Mesa_ocean","MesaBryce_ocean","MesaPlateauF_ocean","MesaPlateauFM_ocean",
"ColdTaiga_deep_ocean","ExtremeHills_deep_ocean","ExtremeHillsM_deep_ocean","ExtremeHills+_deep_ocean","Taiga_deep_ocean","MegaTaiga_deep_ocean","MegaSpruceTaiga_deep_ocean","StoneBeach_deep_ocean","Plains_deep_ocean","SunflowerPlains_deep_ocean","Forest_deep_ocean","FlowerForest_deep_ocean","BirchForest_deep_ocean","BirchForestM_deep_ocean","RoofedForest_deep_ocean","Swampland_deep_ocean","Jungle_deep_ocean","JungleM_deep_ocean","JungleEdge_deep_ocean","JungleEdgeM_deep_ocean","MushroomIsland_deep_ocean","Desert_deep_ocean","Savanna_deep_ocean","SavannaM_deep_ocean","Mesa_deep_ocean","MesaBryce_deep_ocean","MesaPlateauF_deep_ocean","MesaPlateauFM_deep_ocean",
"Mesa_sandlevel","MesaBryce_sandlevel","MesaPlateauF_sandlevel","MesaPlateauFM_sandlevel","Swampland_shore","Jungle_shore","JungleM_shore","Savanna_beach","FlowerForest_beach","ColdTaiga_beach_water","ExtremeHills_beach"}
	local b_kelp = {"ExtremeHillsM_ocean","ExtremeHills+_ocean","MegaTaiga_ocean","MegaSpruceTaiga_ocean","Plains_ocean","SunflowerPlains_ocean","Forest_ocean","FlowerForest_ocean","BirchForest_ocean","BirchForestM_ocean","RoofedForest_ocean","Swampland_ocean","Jungle_ocean","JungleM_ocean","JungleEdge_ocean","JungleEdgeM_ocean","MushroomIsland_ocean","BambooJungle_ocean",
"ExtremeHillsM_deep_ocean","ExtremeHills+_deep_ocean","MegaTaiga_deep_ocean","MegaSpruceTaiga_deep_ocean","Plains_deep_ocean","SunflowerPlains_deep_ocean","Forest_deep_ocean","FlowerForest_deep_ocean","BirchForest_deep_ocean","BirchForestM_deep_ocean","RoofedForest_deep_ocean","Swampland_deep_ocean","Jungle_deep_ocean","JungleM_deep_ocean","JungleEdge_deep_ocean","JungleEdgeM_deep_ocean","MushroomIsland_deep_ocean"
}

	register_seagrass_decoration("seagrass", 0, 0.5, b_seagrass)
	register_seagrass_decoration("kelp", -0.5, 1, b_kelp)

	-- Place tall grass on snow in Ice Plains and Extreme Hills+
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block"},
		sidelen = 16,
		noise_params = {
			offset = -0.08,
			scale = 0.09,
			spread = {x = 15, y = 15, z = 15},
			seed = 420,
			octaves = 3,
			persist = 0.6,
		},
		biomes = {"IcePlains"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = {
			size = { x=1, y=2, z=1 },
			data = {
				{ name = "mcl_core:dirt_with_grass", force_place=true, },
				{ name = "mcl_flowers:tallgrass", param2 = minetest.registered_biomes["IcePlains"]._mcl_palette_index },
			},
		},
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"group:grass_block"},
		sidelen = 16,
		noise_params = {
			offset = 0.0,
			scale = 0.09,
			spread = {x = 15, y = 15, z = 15},
			seed = 420,
			octaves = 3,
			persist = 0.6,
		},
		biomes = {"ExtremeHills+_snowtop"},
		y_min = 1,
		y_max = mcl_vars.mg_overworld_max,
		schematic = {
			size = { x=1, y=2, z=1 },
			data = {
				{ name = "mcl_core:dirt_with_grass", force_place=true, },
				{ name = "mcl_flowers:tallgrass", param2 = minetest.registered_biomes["ExtremeHills+_snowtop"]._mcl_palette_index },
			},
		},
	})


	-- Dead bushes
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"group:sand", "mcl_core:podzol", "mcl_core:dirt", "mcl_core:dirt_with_grass", "mcl_core:coarse_dirt", "group:hardened_clay"},
		sidelen = 16,
		noise_params = {
			offset = 0.0,
			scale = 0.035,
			spread = {x = 100, y = 100, z = 100},
			seed = 1972,
			octaves = 3,
			persist = 0.6
		},
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		biomes = {"Desert", "Mesa", "Mesa_sandlevel", "MesaPlateauF", "MesaPlateauF_sandlevel", "MesaPlateauF_grasstop","MesaBryce", "MegaTaiga", "MegaSpruceTaiga"},
		decoration = "mcl_core:deadbush",
		height = 1,
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"group:sand", "mcl_core:dirt", "mcl_core:dirt_with_grass", "mcl_core:coarse_dirt"},
		sidelen = 16,
		noise_params = {
			offset = 0.1,
			scale = 0.035,
			spread = {x = 100, y = 100, z = 100},
			seed = 1972,
			octaves = 3,
			persist = 0.6
		},
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		biomes = {"MesaPlateauFM_grasstop"},
		decoration = "mcl_core:deadbush",
		height = 1,
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"group:sand"},
		sidelen = 16,
		noise_params = {
			offset = 0.045,
			scale = 0.055,
			spread = {x = 100, y = 100, z = 100},
			seed = 1972,
			octaves = 3,
			persist = 0.6
		},
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		biomes = {"MesaPlateauFM","MesaPlateauFM_sandlevel"},
		decoration = "mcl_core:deadbush",
		height = 1,
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"group:hardened_clay"},
		sidelen = 16,
		noise_params = {
			offset = 0.010,
			scale = 0.035,
			spread = {x = 100, y = 100, z = 100},
			seed = 1972,
			octaves = 3,
			persist = 0.6
		},
		y_min = 4,
		y_max = mcl_vars.mg_overworld_max,
		biomes = {"MesaPlateauFM", "MesaPlateauFM_sandlevel", "MesaPlateauFM_grasstop"},
		decoration = "mcl_core:deadbush",
		height = 1,
	})


	-- Small Mushrooms
	local mushrooms = {"mcl_mushrooms:mushroom_red", "mcl_mushrooms:mushroom_brown"}
	local mseeds = { 7133, 8244 }
	for m=1, #mushrooms do
		-- Mushrooms in mushroom biome
		minetest.register_decoration({
			deco_type = "simple",
			place_on = {"mcl_core:mycelium"},
			sidelen = 80,
			fill_ratio = 0.009,
			biomes = {"MushroomIsland", "MushroomIslandShore"},
			noise_threshold = 2.0,
			y_min = mcl_vars.mg_overworld_min,
			y_max = mcl_vars.mg_overworld_max,
			decoration = mushrooms[m],
		})
		-- Mushrooms in Taiga
		minetest.register_decoration({
			deco_type = "simple",
			place_on = {"mcl_core:podzol"},
			sidelen = 80,
			fill_ratio = 0.003,
			biomes = {"MegaTaiga", "MegaSpruceTaiga"},
			y_min = mcl_vars.mg_overworld_min,
			y_max = mcl_vars.mg_overworld_max,
			decoration = mushrooms[m],
		})
		-- Mushrooms next to trees
		minetest.register_decoration({
			deco_type = "simple",
			place_on = {"group:grass_block_no_snow", "mcl_core:dirt", "mcl_core:podzol", "mcl_core:mycelium", "mcl_core:stone", "mcl_core:andesite", "mcl_core:diorite", "mcl_core:granite"},
			sidelen = 16,
			noise_params = {
				offset = 0,
				scale = 0.003,
				spread = {x = 250, y = 250, z = 250},
				seed = mseeds[m],
				octaves = 3,
				persist = 0.66,
			},
			y_min = 1,
			y_max = mcl_vars.mg_overworld_max,
			decoration = mushrooms[m],
			spawn_by = { "mcl_trees:tree_oak", "mcl_trees:tree_spruce", "mcl_trees:tree_dark_oak", "mcl_trees:tree_birch" },
			num_spawn_by = 1,
		})

		-- More mushrooms in Swampland
		minetest.register_decoration({
			deco_type = "simple",
			place_on = {"group:grass_block_no_snow", "mcl_core:dirt", "mcl_core:podzol", "mcl_core:mycelium", "mcl_core:stone", "mcl_core:andesite", "mcl_core:diorite", "mcl_core:granite"},
			sidelen = 16,
			noise_params = {
				offset = 0.05,
				scale = 0.003,
				spread = {x = 250, y = 250, z = 250},
				seed = mseeds[m],
				octaves = 3,
				persist = 0.6,
			},
			y_min = 1,
			y_max = mcl_vars.mg_overworld_max,
			decoration = mushrooms[m],
			biomes = { "Swampland"},
			spawn_by = { "mcl_trees:tree_oak", "mcl_trees:tree_spruce", "mcl_trees:tree_dark_oak", "mcl_trees:tree_birch" },
			num_spawn_by = 1,
		})
	end

	function mcl_biomes.register_flower(name, biomes, seed, is_in_flower_forest)
		if is_in_flower_forest == nil then
			is_in_flower_forest = true
		end
		if biomes then
			minetest.register_decoration({
				deco_type = "simple",
				place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
				sidelen = 16,
				noise_params = {
					offset = 0.0008,
					scale = 0.006,
					spread = {x = 100, y = 100, z = 100},
					seed = seed,
					octaves = 3,
					persist = 0.6
				},
				y_min = 1,
				y_max = mcl_vars.mg_overworld_max,
				biomes = biomes,
				decoration = "mcl_flowers:"..name,
			})
		end
		if is_in_flower_forest then
			minetest.register_decoration({
				deco_type = "simple",
				place_on = {"group:grass_block_no_snow", "mcl_core:dirt"},
				sidelen = 80,
				noise_params= {
					offset = 0.0008*40,
					scale = 0.003,
					spread = {x = 100, y = 100, z = 100},
					seed = seed,
					octaves = 3,
					persist = 0.6,
				},
				y_min = 1,
				y_max = mcl_vars.mg_overworld_max,
				biomes = {"FlowerForest"},
				decoration = "mcl_flowers:"..name,
			})
		end
	end

	local register_flower = mcl_biomes.register_flower

	local flower_biomes1 = {"Plains", "SunflowerPlains", "RoofedForest", "Forest", "BirchForest", "BirchForestM", "Taiga", "ColdTaiga", "Jungle", "JungleM", "BambooJungle", "JungleEdge", "JungleEdgeM", "Savanna", "SavannaM", "ExtremeHills", "ExtremeHillsM", "ExtremeHills+", "ExtremeHills+_snowtop", "CherryGrove" }

	register_flower("dandelion", flower_biomes1, 8)
	register_flower("poppy", flower_biomes1, 9439)

	local flower_biomes2 = {"Plains", "SunflowerPlains"}
	register_flower("tulip_red", flower_biomes2, 436)
	register_flower("tulip_orange", flower_biomes2, 536)
	register_flower("tulip_pink", flower_biomes2, 636)
	register_flower("tulip_white", flower_biomes2, 736)
	register_flower("azure_bluet", flower_biomes2, 800)
	register_flower("oxeye_daisy", flower_biomes2, 3490)

	register_flower("allium", nil, 0) -- flower Forest only
	register_flower("blue_orchid", {"Swampland"}, 64500, false)

	register_flower("lily_of_the_valley", nil, 325)
	register_flower("cornflower", flower_biomes2, 486)
end

-- Decorations in non-Overworld dimensions
local function register_dimension_decorations()
	--[[ NETHER ]]
	--NETHER WASTES (Nether)
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_nether:netherrack","mcl_nether:magma"},
		sidelen = 16,
		fill_ratio = 0.04,
		biomes = {"Nether"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		y_max = mcl_vars.mg_nether_max  - 1,
		flags = "all_floors",
		decoration = "mcl_fire:eternal_fire",
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_nether:netherrack"},
		sidelen = 16,
		fill_ratio = 0.013,
		biomes = {"Nether"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		y_max = mcl_vars.mg_nether_max  - 1,
		flags = "all_floors",
		decoration = "mcl_mushrooms:mushroom_brown",
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_nether:netherrack"},
		sidelen = 16,
		fill_ratio = 0.012,
		biomes = {"Nether"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		y_max = mcl_vars.mg_nether_max  - 1,
		flags = "all_floors",
		decoration = "mcl_mushrooms:mushroom_red",
	})

	-- WARPED FOREST
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_crimson:warped_nylium"},
		sidelen = 16,
		fill_ratio = 0.02,
		biomes = {"WarpedForest"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		y_max = mcl_vars.mg_nether_max  - 10,
		flags = "all_floors",
		decoration = "mcl_crimson:warped_fungus",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		name = "mcl_biomes:warped_tree1",
		place_on = {"mcl_crimson:warped_nylium"},
		sidelen = 16,
		fill_ratio = 0.007,
		biomes = {"WarpedForest"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		y_max = mcl_vars.mg_nether_max - 15,
		flags = "all_floors, place_center_x, place_center_z",
		schematic = mod_mcl_crimson.."/schematics/warped_fungus_1.mts",
		size = {x = 5, y = 11, z = 5},
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		name = "mcl_biomes:warped_tree2",
		place_on = {"mcl_crimson:warped_nylium"},
		sidelen = 16,
		fill_ratio = 0.005,
		biomes = {"WarpedForest"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		y_max = mcl_vars.mg_nether_max - 10,
		flags = "all_floors, place_center_x, place_center_z",
		schematic = mod_mcl_crimson.."/schematics/warped_fungus_2.mts",
		size = {x = 5, y = 6, z = 5},
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		name = "mcl_biomes:warped_tree3",
		place_on = {"mcl_crimson:warped_nylium"},
		sidelen = 16,
		fill_ratio = 0.003,
		biomes = {"WarpedForest"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		y_max = mcl_vars.mg_nether_max - 14,
		flags = "all_floors, place_center_x, place_center_z",
		schematic = mod_mcl_crimson.."/schematics/warped_fungus_3.mts",
		size = {x = 5, y = 12, z = 5},
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_crimson:warped_nylium","mcl_crimson:twisting_vines"},
		sidelen = 16,
		fill_ratio = 0.032,
		biomes = {"WarpedForest"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		flags = "all_floors",
		height = 2,
		height_max = 8,
		decoration = "mcl_crimson:twisting_vines",
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_crimson:warped_nylium"},
		sidelen = 16,
		fill_ratio = 0.0812,
		biomes = {"WarpedForest"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		flags = "all_floors",
		max_height = 5,
		decoration = "mcl_crimson:warped_roots",
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_crimson:crimson_nylium"},
		sidelen = 16,
		fill_ratio = 0.052,
		biomes = {"WarpedForest"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		flags = "all_floors",
		decoration = "mcl_crimson:nether_sprouts",
	})
	-- CRIMSON FOREST
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_crimson:crimson_nylium"},
		sidelen = 16,
		fill_ratio = 0.02,
		biomes = {"CrimsonForest"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		y_max = mcl_vars.mg_nether_max  - 10,
		flags = "all_floors",
		decoration = "mcl_crimson:crimson_fungus",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		name = "mcl_biomes:crimson_tree",
		place_on = {"mcl_crimson:crimson_nylium"},
		sidelen = 16,
		fill_ratio = 0.008,
		biomes = {"CrimsonForest"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		y_max = mcl_vars.mg_nether_max - 10,
		flags = "all_floors, place_center_x, place_center_z",
		schematic = mod_mcl_crimson.."/schematics/crimson_fungus_1.mts",
		size = {x = 5, y = 8, z = 5},
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		name = "mcl_biomes:crimson_tree2",
		place_on = {"mcl_crimson:crimson_nylium"},
		sidelen = 16,
		fill_ratio = 0.006,
		biomes = {"CrimsonForest"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		y_max = mcl_vars.mg_nether_max - 15,
		flags = "all_floors, place_center_x, place_center_z",
		schematic = mod_mcl_crimson.."/schematics/crimson_fungus_2.mts",
		size = {x = 5, y = 12, z = 5},
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		name = "mcl_biomes:crimson_tree3",
		place_on = {"mcl_crimson:crimson_nylium"},
		sidelen = 16,
		fill_ratio = 0.004,
		biomes = {"CrimsonForest"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		y_max = mcl_vars.mg_nether_max - 20,
		flags = "all_floors, place_center_x, place_center_z",
		schematic = mod_mcl_crimson.."/schematics/crimson_fungus_3.mts",
		size = {x = 7, y = 13, z = 7},
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_crimson:warped_nylium","mcl_crimson:weeping_vines","mcl_nether:netherrack"},
		sidelen = 16,
		fill_ratio = 0.063,
		biomes = {"CrimsonForest"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		y_max = mcl_vars.mg_nether_deco_max,
		flags = "all_ceilings",
		height = 2,
		height_max = 8,
		decoration = "mcl_crimson:weeping_vines",
	})
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_crimson:crimson_nylium"},
		sidelen = 16,
		fill_ratio = 0.082,
		biomes = {"CrimsonForest"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		flags = "all_floors",
		max_height = 5,
		decoration = "mcl_crimson:crimson_roots",
	})

	--SOULSAND VALLEY
	minetest.register_decoration({
		deco_type = "simple",
		place_on = {"mcl_blackstone:soul_soil","mcl_nether:soul_sand"},
		sidelen = 16,
		fill_ratio = 0.062,
		biomes = {"SoulsandValley"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		flags = "all_floors",
		max_height = 5,
		decoration = "mcl_blackstone:soul_fire",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_blackstone:soul_soil","mcl_nether:soulsand"},
		sidelen = 16,
		fill_ratio = 0.000212,
		biomes = {"SoulsandValley"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		flags = "all_floors, place_center_x, place_center_z",
		schematic = mod_mcl_blackstone.."/schematics/mcl_blackstone_nether_fossil_1.mts",
		size = {x = 5, y = 8, z = 5},
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_blackstone:soul_soil","mcl_nether:soulsand"},
		sidelen = 16,
		fill_ratio = 0.0002233,
		biomes = {"SoulsandValley"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		flags = "all_floors, place_center_x, place_center_z",
		schematic = mod_mcl_blackstone.."/schematics/mcl_blackstone_nether_fossil_2.mts",
		size = {x = 5, y = 8, z = 5},
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_blackstone:soul_soil","mcl_nether:soulsand"},
		sidelen = 16,
		fill_ratio = 0.000225,
		biomes = {"SoulsandValley"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		flags = "all_floors, place_center_x, place_center_z",
		schematic = mod_mcl_blackstone.."/schematics/mcl_blackstone_nether_fossil_3.mts",
		size = {x = 5, y = 8, z = 5},
		rotation = "random",
	})
	minetest.register_decoration({
		deco_type = "schematic",
		place_on = {"mcl_blackstone:soul_soil","mcl_nether:soulsand"},
		sidelen = 16,
		fill_ratio = 0.00022323,
		biomes = {"SoulsandValley"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		flags = "all_floors, place_center_x, place_center_z",
		schematic = mod_mcl_blackstone.."/schematics/mcl_blackstone_nether_fossil_4.mts",
		size = {x = 5, y = 8, z = 5},
		rotation = "random",
	})
	--BASALT DELTA
	minetest.register_decoration({
		deco_type = "simple",
		decoration = "mcl_blackstone:basalt",
		place_on = {"mcl_blackstone:basalt","mcl_nether:netherrack","mcl_blackstone:blackstone"},
		sidelen = 80,
		height_max = 55,
		noise_params={
			offset = -0.0085,
			scale = 0.002,
			spread = {x = 25, y = 120, z = 25},
			seed = 2325,
			octaves = 5,
			persist = 2,
			lacunarity = 3.5,
			flags = "absvalue"
		},
		biomes = {"BasaltDelta"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		y_max = mcl_vars.mg_nether_deco_max - 50,
		flags = "all_floors, all ceilings",
	})
	minetest.register_decoration({
		deco_type = "simple",
		decoration = "mcl_blackstone:basalt",
		place_on = {"mcl_blackstone:basalt","mcl_nether:netherrack","mcl_blackstone:blackstone"},
		sidelen = 80,
		height_max = 15,
		noise_params={
			offset = -0.0085,
			scale = 0.004,
			spread = {x = 25, y = 120, z = 25},
			seed = 235,
			octaves = 5,
			persist = 2.5,
			lacunarity = 3.5,
			flags = "absvalue"
		},
		biomes = {"BasaltDelta"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		y_max = mcl_vars.mg_nether_deco_max - 15,
		flags = "all_floors, all ceilings",
	})
	minetest.register_decoration({
		deco_type = "simple",
		decoration = "mcl_blackstone:basalt",
		place_on = {"mcl_blackstone:basalt","mcl_nether:netherrack","mcl_blackstone:blackstone"},
		sidelen = 80,
		height_max = 3,
		fill_ratio = 0.4,
		biomes = {"BasaltDelta"},
		y_min = mcl_vars.mg_lava_nether_max + 1,
		y_max = mcl_vars.mg_nether_deco_max - 15,
		flags = "all_floors, all ceilings",
	})
	minetest.register_decoration({
		deco_type = "simple",
		decoration = "mcl_nether:magma",
		place_on = {"mcl_blackstone:basalt","mcl_nether:netherrack","mcl_blackstone:blackstone"},
		sidelen = 80,
		fill_ratio = 0.082323,
		biomes = {"BasaltDelta"},
		place_offset_y  = -1,
		y_min = mcl_vars.mg_lava_nether_max + 1,
		flags = "all_floors, all ceilings",
	})
	minetest.register_decoration({
		deco_type = "simple",
		decoration = "mcl_nether:nether_lava_source",
		place_on = {"mcl_blackstone:basalt","mcl_nether:netherrack","mcl_blackstone:blackstone"},
		spawn_by = {"mcl_blackstone:basalt","mcl_blackstone:blackstone"},
		num_spawn_by = 14,
		sidelen = 80,
		fill_ratio = 4,
		biomes = {"BasaltDelta"},
		place_offset_y  = -1,
		y_min = mcl_vars.mg_lava_nether_max + 1,
		y_max = mcl_vars.mg_nether_max - 5,
		flags = "all_floors, force_placement",
	})

	--[[ THE END ]]

	-- Chorus plant
	minetest.register_decoration({
		name = "mcl_biomes:chorus",
		deco_type = "simple",
		place_on = {"mcl_end:end_stone"},
		flags = "all_floors",
		sidelen = 16,
		noise_params = {
			offset = -0.012,
			scale = 0.024,
			spread = {x = 100, y = 100, z = 100},
			seed = 257,
			octaves = 3,
			persist = 0.6
		},
		y_min = mcl_vars.mg_end_min,
		y_max = mcl_vars.mg_end_max,
		decoration = "mcl_end:chorus_plant",
		height = 1,
		height_max = 8,
		biomes = { "End", "EndMidlands", "EndHighlands", "EndBarrens", "EndSmallIslands" },
	})
	minetest.register_decoration({
		name = "mcl_biomes:chorus_plant",
		deco_type = "simple",
		place_on = {"mcl_end:chorus_plant"},
		flags = "all_floors",
		sidelen = 16,
		fill_ratio = 10,
		--[[noise_params = {
			offset = -0.012,
			scale = 0.024,
			spread = {x = 100, y = 100, z = 100},
			seed = 257,
			octaves = 3,
			persist = 0.6
		},--]]
		y_min = mcl_vars.mg_end_min,
		y_max = mcl_vars.mg_end_max,
		decoration = "mcl_end:chorus_flower",
		height = 1,
		biomes = { "End", "EndMidlands", "EndHighlands", "EndBarrens", "EndSmallIslands" },
	})

	deco_id_chorus_plant = minetest.get_decoration_id("mcl_biomes:chorus_plant")
	minetest.set_gen_notify({decoration=true}, { deco_id_chorus_plant })

	-- TODO: End cities

end


--
-- Detect mapgen to select functions
--
if not mcl_vars.superflat then
	register_biomes()
	register_biomelike_ores()
	register_biome_ores()
	register_decorations()
else
	-- Implementation of Minecraft's Superflat mapgen, classic style:
	-- * Perfectly flat land, 1 grass biome, no decorations, no caves
	-- * 4 layers, from top to bottom: grass block, dirt, dirt, bedrock
	minetest.clear_registered_biomes()
	minetest.clear_registered_decorations()
	minetest.clear_registered_schematics()
	register_classic_superflat_biome()
end

-- Non-overworld stuff is registered independently
register_dimension_biomes()
register_dimension_ores()
register_dimension_decorations()

local deco_ids_fungus ={
	minetest.get_decoration_id("mcl_biomes:crimson_tree1"),
	minetest.get_decoration_id("mcl_biomes:crimson_tree2"),
	minetest.get_decoration_id("mcl_biomes:crimson_tree3"),
	minetest.get_decoration_id("mcl_biomes:warped_tree1"),
	minetest.get_decoration_id("mcl_biomes:warped_tree2"),
	minetest.get_decoration_id("mcl_biomes:warped_tree3")
}
local deco_ids_trees = {
	minetest.get_decoration_id("mcl_biomes:mangrove_tree_1"),
	minetest.get_decoration_id("mcl_biomes:mangrove_tree_2"),
	minetest.get_decoration_id("mcl_biomes:mangrove_tree_3"),
}
for _,f in pairs(deco_ids_fungus) do
	minetest.set_gen_notify({decoration=true}, { f })
end
for _,f in pairs(deco_ids_trees) do
	minetest.set_gen_notify({decoration=true}, { f })
end

local function mangrove_roots_gen(gennotify, pr)
	for _, f in pairs(deco_ids_trees) do
		for _, pos in ipairs(gennotify["decoration#" .. f] or {}) do
			local nn = minetest.find_nodes_in_area(vector.offset(pos, -8, -1, -8), vector.offset(pos, 8, 0, 8), {"mcl_mangrove:mangrove_roots"})
			for _, v in pairs(nn) do
				local l = pr:next(2, 16)
				local n = minetest.get_node(vector.offset(v, 0, -1, 0)).name
				if minetest.get_item_group(n, "water") > 0 then
					local wl = "mcl_mangrove:water_logged_roots"
					if n:find("river") then
						wl = "mcl_mangrove:river_water_logged_roots"
					end
					minetest.bulk_set_node(minetest.find_nodes_in_area(vector.offset(v, 0, 0, 0), vector.offset(v, 0, -l, 0), {"group:water"}), {name = wl})
				elseif n == "mcl_mud:mud" then
					minetest.bulk_set_node(minetest.find_nodes_in_area(vector.offset(v, 0, 0, 0), vector.offset(v, 0, -l, 0), {"mcl_mud:mud"}), {name = "mcl_mangrove:mangrove_mud_roots"})
				elseif n == "air" then
					minetest.bulk_set_node(minetest.find_nodes_in_area(vector.offset(v, 0, 0, 0), vector.offset(v, 0, -l, 0), {"air"}), {name = "mcl_mangrove:mangrove_roots"})
				end
			end
		end
	end
end

local function chorus_gen (gennotify, pr)
	for _, pos in ipairs(gennotify["decoration#" .. deco_id_chorus_plant] or {}) do
		local x, y, z = pos.x, pos.y, pos.z
		if x < -10 or x > 10 or z < -10 or z > 10 then
			local realpos = {x = x, y = y + 1, z = z}
			local node = minetest.get_node(realpos)
			if node and node.name == "mcl_end:chorus_flower" then
				mcl_end.grow_chorus_plant(realpos, node, pr)
			end
		end
	end
end

local function crimson_warped_gen(gennotify)
	for _, f in pairs(deco_ids_fungus) do
		for _, pos in ipairs(gennotify["decoration#" .. f] or {}) do
			minetest.fix_light(vector.offset(pos, -8, -8, -8), vector.offset(pos, 8, 8, 8))
		end
	end
end

if deco_id_chorus_plant or deco_ids_fungus or deco_ids_trees then
	mcl_mapgen_core.register_generator("chorus_grow", nil, function(minp, maxp, blockseed)
		local gennotify = minetest.get_mapgen_object("gennotify")
		local pr = PseudoRandom(blockseed + 14)
		if not (maxp.y < mcl_vars.mg_overworld_min or minp.y > mcl_vars.mg_overworld_max) then
			local biomemap = minetest.get_mapgen_object("biomemap")
			-- get_mapgen_object returns nil with lua mapgens
			if biomemap then
				local swamp_biome_id = minetest.get_biome_id("MangroveSwamp")
				local swamp_shore_id = minetest.get_biome_id("MangroveSwamp_shore")
				local is_swamp = table.indexof(biomemap, swamp_biome_id) ~= -1
				local is_swamp_shore = table.indexof(biomemap, swamp_shore_id) ~= -1

				if is_swamp or is_swamp_shore then
					mangrove_roots_gen(gennotify, pr)
				end
			end
		end

		if not (maxp.y < mcl_vars.mg_end_min or minp.y > mcl_vars.mg_end_max) then
			chorus_gen(gennotify, pr)
		end

		if not (maxp.y < mcl_vars.mg_nether_min or minp.y > mcl_vars.mg_nether_max) then
			crimson_warped_gen(gennotify)
		end
	end)
end
