dofile ("init.lua")
dofile ("mineshaft.lua")
dofile ("beardifier_demo.lua")

local floor = math.floor
local seed = mcl_levelgen.ull (0, 3228473)
mcl_levelgen.assign_biome_ids ({})
local level = mcl_levelgen.make_overworld_preset (seed)
local overworld_terrain
	= mcl_levelgen.make_terrain_generator (level, 80, 80)
mcl_levelgen.load_carvers ()

local a, b, structuremask = {}, {}, {}
local biomes = {}
local benchblocks = {
	{13488,-32,13648,13567,47,13727,},
	{13408,-112,13648,13487,-33,13727,},
	{13408,-112,13568,13487,-33,13647,},
	{13408,-32,13568,13487,47,13647,},
	{13408,-32,13648,13487,47,13727,},
	{13408,-112,13728,13487,-33,13807,},
	{13408,-32,13728,13487,47,13807,},
	{13408,48,13568,13487,127,13647,},
	{13408,48,13648,13487,127,13727,},
	{13408,48,13728,13487,127,13807,},
	{13488,-112,13568,13567,-33,13647,},
	{13488,-112,13648,13567,-33,13727,},
	{13488,-112,13728,13567,-33,13807,},
	{13488,-32,13568,13567,47,13647,},
	{13488,-32,13728,13567,47,13807,},
	{13488,48,13568,13567,127,13647,},
	{13488,48,13648,13567,127,13727,},
	{13488,48,13728,13567,127,13807,},
	{13568,-32,13568,13647,47,13647,},
	{13568,-32,13648,13647,47,13727,},
	{13568,-112,13568,13647,-33,13647,},
	{13568,-112,13648,13647,-33,13727,},
	{13568,-112,13728,13647,-33,13807,},
	{13568,-32,13728,13647,47,13807,},
	{13568,48,13568,13647,127,13647,},
	{13568,48,13648,13647,127,13727,},
	{13568,48,13728,13647,127,13807,},
	{13568,-32,13488,13647,47,13567,},
	{13408,-32,13488,13487,47,13567,},
	{13488,-32,13488,13567,47,13567,},
	{13648,48,13648,13727,127,13727,},
	{13488,-32,13808,13567,47,13887,},
	{13488,48,13808,13567,127,13887,},
	{13568,-32,13808,13647,47,13887,},
	{13568,48,13808,13647,127,13887,},
	{13648,48,13728,13727,127,13807,},
	{13408,-32,13808,13487,47,13887,},
	{13408,48,13808,13487,127,13887,},
	{13488,-112,13808,13567,-33,13887,},
	{13568,-112,13808,13647,-33,13887,},
	{13408,-112,13808,13487,-33,13887,},
	{13648,-32,13648,13727,47,13727,},
	{13648,-32,13728,13727,47,13807,},
	{13648,-32,13808,13727,47,13887,},
	{13648,-112,13648,13727,-33,13727,},
	{13648,-112,13728,13727,-33,13807,},
	{13648,-112,13808,13727,-33,13887,},
	{13648,48,13808,13727,127,13887,},
	{13408,-32,13888,13487,47,13967,},
	{13488,-32,13888,13567,47,13967,},
	{13568,-32,13888,13647,47,13967,},
	{13488,48,13888,13567,127,13967,},
	{13568,48,13888,13647,127,13967,},
	{13408,48,13888,13487,127,13967,},
	{13488,-112,13888,13567,-33,13967,},
	{13568,-112,13888,13647,-33,13967,},
	{13408,-112,13888,13487,-33,13967,},
	{13408,-32,13968,13487,47,14047,},
	{13488,-32,13968,13567,47,14047,},
	{13488,48,13968,13567,127,14047,},
	{13568,-32,13968,13647,47,14047,},
	{13328,-32,13808,13407,47,13887,},
	{13328,-32,13888,13407,47,13967,},
	{13328,-32,13968,13407,47,14047,},
	{13328,48,13808,13407,127,13887,},
	{13328,48,13888,13407,127,13967,},
	{13328,-32,13728,13407,47,13807,},
	{13328,48,13728,13407,127,13807,},
	{13328,-112,13808,13407,-33,13887,},
	{13328,-112,13728,13407,-33,13807,},
	{13328,-112,13888,13407,-33,13967,},
	{13328,128,13808,13407,207,13887,},
	{13408,128,13728,13487,207,13807,},
	{13408,128,13808,13487,207,13887,},
	{13248,-32,13728,13327,47,13807,},
	{13248,48,13728,13327,127,13807,},
	{13248,48,13808,13327,127,13887,},
	{13248,-112,13728,13327,-33,13807,},
}

local clock = os.clock ()

local function index (x, y, z)
	return x * 80 * 80 + y * 80 + z + 1
end

print ("Starting to generate terrain...")

local function do_generate (x1, y1, z1, x2, y2, z2)
	local OVERWORLD_OFFSET = 64

	local block_x = x1 / 16
	local block_y = (OVERWORLD_OFFSET + y1) / 16
	local block_z = z1 / 16
	assert (block_x == floor (block_x))
	assert (block_y == floor (block_y))
	assert (block_z == floor (block_z))

	mcl_levelgen.generate_biomes_at_block (level, biomes,
					       block_x,
					       level.min_y / 16,
					       block_z, 5,
					       level.height / 16)
	overworld_terrain:generate (x1, OVERWORLD_OFFSET + y1,
				    -z1 - 80, a, b, structuremask,
				    index, biomes)
	mcl_levelgen.flush_structure_gen_data ()
end

jit.flush ()

for i = 0, 14 do

	do_generate (unpack (benchblocks[i * 4 + 1]))
	do_generate (unpack (benchblocks[i * 4 + 2]))
	do_generate (unpack (benchblocks[i * 4 + 3]))
	do_generate (unpack (benchblocks[i * 4 + 4]))

	print ("Generated " .. (i + 1) * 4 .. " MapChunks...")

end

print ("Generation completed in: " .. math.floor (os.clock () - clock + 0.5) .. " s")
-- print (string.format ("%.3f%%", (nwithveins / ntotal * 100)), nwithveins, ntotal)

