--Ceci est le code entier du mod : projectile ,tir , arme, mais pas textures et informations concernant le contenu ,juste indications regardant le code.
local ghostsnip_last_shot = {} --Initialisation du temps de rechargement
local technic_charge_max = 40000 --Énergie max de l'objet par rapport à Technic
local technic_cost_per_shot = 500 --Cout d'énergie de chaque tir par rapport à Technic

if minetest.get_modpath("technic") then
    technic.register_power_tool("ghostsnip_bow:ghost_snip", technic_charge_max)
end

minetest.register_tool("ghostsnip_bow:ghost_snip", { --Création et enregistrement de l'arme (Ghost snip)
    description = minetest.colorize("lightgreen",("Ghost Snip")) .. minetest.get_background_escape_sequence("purple"),
    inventory_image = "ghostsnip_weapon.png",
    light_source = minetest.LIGHT_MAX,
    stack_max = 1,
    wear_represents = "technic_RE_charge",
    technic_max_charge = technic_charge_max,
    tool_capabilities = {
        full_punch_interval = 1.0,
        max_drop_level = 0,
        groupcaps = {},
        damage_groups = {fleshy = 2},
    },
    groups = {},
    on_secondary_use = function(itemstack, user, pointed_thing)
        local pname = user:get_player_name()
        local now = minetest.get_gametime()
        local last_shot = ghostsnip_last_shot[pname] or 0
        local cooldown = 5 -- Temps de rechargement entre deux tirs 

        if now - last_shot < cooldown then
            minetest.chat_send_player(pname, "L'arme recharge ! (" .. (cooldown - (now - last_shot)) .. "s restantes)") -- Indication du temps de recharge insuffisant
            return itemstack
        end

        -- Gestion de la charge
        local meta = technic.get_stack_meta(itemstack)
        local charge = meta:get_int("technic:charge")

        if charge < technic_cost_per_shot then
            minetest.chat_send_player(pname, "Pas assez d'énergie ! Recharge l'arme dans une Battery Box.") --Indication de l'énergie trop faible de l'arme pour tirer et directive à prendre pour recharger
            return itemstack
        end

        charge = charge - technic_cost_per_shot
        meta:set_int("technic:charge", charge)
        technic.set_RE_wear(itemstack, charge, technic_charge_max)

        ghostsnip_last_shot[pname] = now

        -- Tir du projectile
        local playerpos = user:get_pos()
        local dir = user:get_look_dir()
        local obj = minetest.add_entity({ 
            x = playerpos.x, -- Position x du projectile par rapport au regard du joueur
            y = playerpos.y + 1, -- Position y du projectile par rapport au regard du joueur
            z = playerpos.z -- Position z du projectile par rapport au regard du joueur
        }, "ghostsnip_bow:projectile")
        obj:set_velocity({ -- Vélocité du projectile
            x = dir.x * 100,
            y = dir.y * 100,
            z = dir.z * 100
            })
        obj:set_acceleration({x = 0, y = 0, z = 0})--Vitesse/accélération du projectile

     -- On stocke le joueur tireur dans l'entité projectile
     local luaent = obj:get_luaentity()
     if luaent then
     luaent._shooter = user
      end

        return itemstack
    end,
})
minetest.register_entity("ghostsnip_bow:projectile", { --Création et enregistrement du projectile
    initial_properties = {
        physical = false,
        collide_with_objects = true,
        collisionbox = {-0.25, -0.25, -0.25, 0.25, 0.25, 0.25},
        visual = "sprite",
        textures = {"ghostsnip_projectile.png"},
        velocity = 10,
        damage = 10,
        pointable = false, -- On ne peut pas cliquer dessus
        visual_size = {x=0.5, y=0.5}, -- taille du sprite
        glow = 100, -- effet lumineux
    },

    -- Gestion du déplacement et des collisions
    on_step = function(self, dtime)
        local pos = self.object:get_pos()
        if not pos then
            self.object:remove()
            return
        end

        -- Collision avec joueur ou mob (hors autres projectiles/items)
        for _, obj in ipairs(minetest.get_objects_inside_radius(pos, 1)) do
            if obj ~= self.object and (
                obj:is_player() or
                (obj:get_luaentity() and obj:get_luaentity().name ~= "__builtin:item" and obj:get_luaentity().name ~= "ghostsnip_bow:projectile")
            ) then
                obj:punch(self._shooter or self.object, 1.0, {
                full_punch_interval = 1.0,
                damage_groups = {fleshy = self.initial_properties.damage}
                }, nil)

                self.object:remove()
                return
            end
        end

        -- Disparaît si touche un bloc solide
        local node = minetest.get_node(pos)
        if minetest.registered_nodes[node.name] and minetest.registered_nodes[node.name].walkable then
            self.object:remove()
        end
    end,

    -- Empêche le projectile d'être frappé ou ramassé
    on_punch = function(self, puncher, time_from_last_punch, tool_capabilities, dir)
        -- Rien
    end,
})
minetest.register_craft({ --Recette/Craft du Ghost snip
	output = "ghostsnip_bow:ghost_snip",
	recipe = {
		{"", "default:mese_block", "forgotten_monsters:spectrum_orb"},
		{"technic:hv_battery_box", "", "basic_materials:steel_bar"},
		{"", "default:mese_block", "forgotten_monsters:spectrum_orb"},
	}
})
