-- Define a constant for the description suffix
local DESCRIPTION = "embedded pot light"
local modname = minetest.get_current_modname()
embedded_lights = {}
embedded_lights.LIGHT_VAL = 10

-- Load support for MT game translation.
local S = minetest.get_translator("embedded_lights")

-- Array of potlight colors
local potlight_array = {
    {color = "red", image = "potlight_red.png"},
    {color = "blue", image = "potlight_blue.png"},
    {color = "yellow", image = "potlight_yellow.png"}
}

-- Function to create an overlay node based on an existing node
local function create_overlay_node(original_node_name, overlay_texture, potlight_color, new_node_name)
    local dyecolor = "dye:" .. potlight_color
    local original_def = minetest.registered_nodes[original_node_name]
    if not original_def then
        minetest.log("error", "Original node " .. original_node_name .. " does not exist.")
        return
    end

    -- Copy the original node definition
    local new_def = table.copy(original_def)

    -- Modify the description
    new_def.description = original_def.description .. " with " .. potlight_color .. " " .. DESCRIPTION

    -- Modify the tiles to add the overlay on top
    new_def.tiles = table.copy(original_def.tiles)

    -- Ensure this is set so that screw drivers can setup proper face direction
    new_def.paramtype2 = "facedir"

    -- -- debug 
    -- minetest.log(dump(original_def.tiles))
    -- minetest.log(type(new_def.tiles[1]))

    -- Ensure only the top texture has the overlay
    -- If several faces are defined, only modify the top one
    -- If only a single texture is defined, redefine all sides to ensure only top is modified
    if #new_def.tiles > 1 then
        new_def.tiles[1] = new_def.tiles[1] .. "^" .. overlay_texture
    else
        new_def.tiles = {
            original_def.tiles[1] .. "^" .. overlay_texture, -- top
            original_def.tiles[1], -- bottom
            original_def.tiles[1], -- side1
            original_def.tiles[1], -- side2
            original_def.tiles[1], -- side3
            original_def.tiles[1]  -- side4
        }    
    end

    -- Set light-emitting properties
    new_def.paramtype = "light"
    new_def.sunlight_propagates = true
    new_def.is_ground_content = false
    new_def.light_source = embedded_lights.LIGHT_VAL

    -- Register the new node
    minetest.register_node(new_node_name, new_def)

    -- Swap non-craftable items with other for recipe:
    if original_node_name == "default:dirt_with_snow" then original_node_name = "default:snow" end
    if original_node_name == "default:dirt_with_grass" then original_node_name = "default:grass_1" end
    
     -- Register a crafting recipe for the new node
     minetest.register_craft({
        output = new_node_name,
        recipe = {
            {"default:mese_crystal_fragment", "default:steel_ingot", dyecolor},
            {"", original_node_name, ""},
            {"", "", ""}
        }
    })
end


-- Add embedded pot lights for default nodes.
if minetest.get_modpath("default") then
    local modifymod = "default"
    local default_nodes = {
        {mod = modifymod, node = "dirt_with_grass"},
        {mod = modifymod, node = "dirt"},
        {mod = modifymod, node = "sandstone"},
        {mod = modifymod, node = "silver_sandstone"},
        {mod = modifymod, node = "dirt_with_snow"},
        {mod = modifymod, node = "stonebrick"}
    }
    for _, potlight in ipairs(potlight_array) do
        for _, default_node in ipairs(default_nodes) do
            create_overlay_node(default_node.mod .. ":" .. default_node.node, potlight.image, potlight.color, modname .. ":" .. modifymod .. "_" ..  default_node.node .. "_" .. potlight.color .. "_pot_light")
        end
    end
else
    minetest.log("error", "[embedded_lights] The default mod is not loaded. The overlay node will not be registered.")
end

-- Add embedded pot lights for default nodes.
if minetest.get_modpath("quartz") then
    local modifymod = "quartz"
    local default_nodes = {
        {mod = modifymod, node = "block"}
    }
    for _, potlight in ipairs(potlight_array) do
        for _, default_node in ipairs(default_nodes) do
            create_overlay_node(default_node.mod .. ":" .. default_node.node, potlight.image, potlight.color, modname .. ":" .. modifymod .. "_" ..  default_node.node .. "_" .. potlight.color .. "_pot_light")
        end
    end
end

-- Add embedded pot lights for bakedclay nodes.
if minetest.get_modpath("bakedclay") then
    local modifymod = "bakedclay"
    local default_nodes = {
        {mod = modifymod, node = "white"},
        {mod = modifymod, node = "black"},
        {mod = modifymod, node = "dark_grey"},
        {mod = modifymod, node = "grey"},
        {mod = modifymod, node = "blue"},
        {mod = modifymod, node = "cyan"},
        {mod = modifymod, node = "brown"},
        {mod = modifymod, node = "green"},
        {mod = modifymod, node = "dark_green"},
        {mod = modifymod, node = "magenta"},
        {mod = modifymod, node = "natural"},
        {mod = modifymod, node = "orange"},
        {mod = modifymod, node = "pink"},
        {mod = modifymod, node = "red"},
        {mod = modifymod, node = "terracotta_blue"}
    }
    for _, potlight in ipairs(potlight_array) do
        for _, default_node in ipairs(default_nodes) do
            create_overlay_node(default_node.mod .. ":" .. default_node.node, potlight.image, potlight.color, modname .. ":" .. modifymod .. "_" .. default_node.node .. "_" .. potlight.color .. "_pot_light")
        end
    end
end
