local open = {}
local function search_doors_to_open(pos,player)
	for i=0,5 do
		local v = ((i>2) and 1 or -1)
		local i = i%3
		local vec = vector.new()
		vec[i+1] = v
		local pos = pos + vec
		local d = doors.get(pos)
		if d then
			if not d:state() then
				d:open(player)
				table.insert(open, {player:get_player_name(),pos})
			end
		end
	end
end
local function check_collision(player)
	local pos = vector.round(player:get_pos())
	local player_properties = player:get_properties()
	local collisionbox = player_properties.collisionbox
	
	local positions_to_check = {
		{x = pos.x, y = pos.y, z = pos.z}, -- center
		{x = pos.x +1, y = pos.y, z = pos.z},
		{x = pos.x -1, y = pos.y, z = pos.z},
		{x = pos.x, y = pos.y, z = pos.z +1},
		{x = pos.x, y = pos.y, z = pos.z -1},
		{x = pos.x, y = pos.y + collisionbox[2] - 0.01, z = pos.z},
		{x = pos.x, y = pos.y + collisionbox[5]+0.5, z = pos.z},
	}
	for _, pos in ipairs(positions_to_check) do
		local nodename = core.get_node(pos).name
		local d = doors.get(pos)
		if d or nodename == "doors:hidden" then
			if nodename == "doors:hidden" then
				pos = pos + vector.new(0,-1,0)
				d = doors.get(pos)
			end
			
			if d then
				if not d:state() then
					d:open(player)
					table.insert(open, {player:get_player_name(),pos})
					search_doors_to_open(pos,player)
				end
				break
			end
		end
	end
end
local function close_at_pos(pos,player,i)
	local d = doors.get(pos)
	if d then
		d:close(player)
	end
	table.remove(open, i)
	
end

local timer = 0
core.register_globalstep(function(dtime)
	timer = timer + dtime
	if timer >= 0.2 then
		timer = 0
		for i = #open, 1, -1 do
			local v = open[i]
			local player = core.get_player_by_name(v[1])
			if vector.distance(player:get_pos(),v[2]) > 3 then
				close_at_pos(v[2],player,i)
			end
		end
		for _, player in ipairs(core.get_connected_players()) do
			check_collision(player)
		end
	end
end)

core.register_on_leaveplayer(function(player)
	local name = player:get_player_name()
	for i = #open, 1, -1 do
		local v = open[i]
		if v[1] == name then
			close_at_pos(v[2],player,i)
		end
	end
end)
