local open = {}
local function is_door(node)
	local node_def = core.registered_nodes[node.name]
	if node_def and node_def.groups.door or node_def.groups.trapdoor then
		return true
	end
end
local function is_open(pos)
	local meta = core.get_meta(pos)
	local node = core.get_node(pos)
	local node_def = core.registered_nodes[node.name]
	if node_def.groups.door then
		if meta:get_int("is_open") == 1 then
			return true
		end
	else
		return string.find(node.name,"_open$")
	end
end
local function simulate_rightclick(pos, player)
	local node = core.get_node(pos)
	local node_def = core.registered_nodes[node.name]
	if node_def and node_def.on_rightclick then
		node_def.on_rightclick(pos, node, player, nil, {type = "node", under = pos, above = pos})
	end
end
local function close_at_pos(pos,player,i)
	if is_door(core.get_node(pos)) and is_open(pos) then
		simulate_rightclick(pos, player)
	end
	table.remove(open, i)
end

local function search_doors_to_open(pos,player)
	for i=0,5 do
		local v = ((i>2) and 1 or -1)
		local i = i%3
		local vec = vector.new()
		vec[i+1] = v
		local pos = pos + vec
		if is_door(core.get_node(pos)) and not is_open(pos) then
			simulate_rightclick(pos, player)
			table.insert(open, {player:get_player_name(),pos})
		end
	end
end


local function check_collision(player)
	local pos = vector.round(player:get_pos())
	local player_properties = player:get_properties()
	local collisionbox = player_properties.collisionbox
	
	local positions_to_check = {
		{x = pos.x, y = pos.y, z = pos.z}, -- center
		{x = pos.x +1, y = pos.y, z = pos.z},
		{x = pos.x -1, y = pos.y, z = pos.z},
		{x = pos.x, y = pos.y, z = pos.z +1},
		{x = pos.x, y = pos.y, z = pos.z -1},
		{x = pos.x, y = pos.y + collisionbox[2] - 0.01, z = pos.z},
		{x = pos.x, y = pos.y + collisionbox[5]+0.5, z = pos.z},
	}
	for _, pos in ipairs(positions_to_check) do
		local node = core.get_node(pos)
		if is_door(node) then
			if not is_open(pos) then
				simulate_rightclick(pos, player)
				table.insert(open, {player:get_player_name(),pos})
				search_doors_to_open(pos,player)
			end
			break
		end
	end
end


local timer = 0
core.register_globalstep(function(dtime)
	timer = timer + dtime
	if timer >= 0.2 then
		timer = 0
		for i = #open, 1, -1 do
			local v = open[i]
			local player = core.get_player_by_name(v[1])
			if vector.distance(player:get_pos(),v[2]) > 3 then
				close_at_pos(v[2],player,i)
			end
		end
		for _, player in ipairs(core.get_connected_players()) do
			check_collision(player)
		end
	end
end)

local function leaveplayer(player)
	local name = player:get_player_name()
	for i = #open, 1, -1 do
		local v = open[i]
		if v[1] == name then
			close_at_pos(v[2],player,i)
		end
	end
end

core.register_on_leaveplayer(leaveplayer)
core.register_on_shutdown(function()
	for _,p in ipairs(core.get_connected_players()) do
		leaveplayer(p)
	end
end)