-- this file was written by shaft and is licensed CC0

local shared = {}
local setting_decal = core.settings:get_bool("blood_splatter.decal",true)
local setting_particle = core.settings:get_bool("blood_splatter.particle",true)
shared.decalLifetime = tonumber(core.settings:get("blood_splatter.decalLifetime")) or 300

-- For the largest available spray size (3×3=9 pixels), this results in 33.33 seconds.
shared.SPRAY_DURATION = 5 * 60
-- Clients send the position of their player every 0.1 seconds.
-- https://github.com/minetest/minetest/blob/5.6.1/src/client/client.h#L563
-- https://github.com/minetest/minetest/blob/5.6.1/src/client/client.cpp#L528
shared.SPRAY_STEP_INTERVAL = 0.1
shared.NUM_SPRAY_STEPS = 5

shared.MAX_SPRAY_DISTANCE = 4
shared.DESIRED_PIXEL_SIZE = 1/16
shared.TRANSPARENT = "#00000000"

shared.EPSILON = 0.0001


local basepath = core.get_modpath("blood_splatter")
assert(loadfile(basepath .. "/aabb.lua"))(shared)
assert(loadfile(basepath .. "/canvas.lua"))(shared)
assert(loadfile(basepath .. "/spraycast.lua"))(shared)

local function bleed_any(actor, pos, color, damage, selectionbox)
	local spray_def = {size=3,color="#800000ff"}
	if color then spray_def.color = color end
	
	local selectionbox = selectionbox or actor:get_properties().selectionbox
	local length_x = math.abs(selectionbox[4] - selectionbox[1])
	local length_y = math.abs(selectionbox[5] - selectionbox[2])
	local length_z = math.abs(selectionbox[6] - selectionbox[3])
	local average_length = (length_x + length_y + length_z) / 3
	--~ core.chat_send_all(average_length)
	--~ core.chat_send_player("singleplayer", damage)
	
	--~ pos.y = pos.y + length_y/2
	if setting_decal then
		shared.MAX_SPRAY_DISTANCE = average_length*2
		local spray_pos = vector.new(pos.x, pos.y + length_y/2, pos.z)
		for i=1,damage*20 do
			spray_def.size=math.ceil(math.random()*6)
			local dir = vector.new(0,0,0)
			for j=1,3 do
				dir[j] = math.random()*2-1
			end
			shared.spraycast(actor, spray_pos, dir, spray_def) --actor was core.get_connected_players()[1]
		end
		shared.after_spraycasts()
	end
	if setting_particle and not color then
		local particle_pos = vector.new(pos.x, pos.y + length_y/2, pos.z)
		for i=1, damage do
			local vel = vector.new(
					(math.random()-0.5)*2,
					2+math.random()*2,
					(math.random()-0.5)*2
				)
			local dir = vector.normalize(vel)
			local end_pos = vector.add(pos, vector.multiply(dir, average_length))
			local particle_pos = particle_pos
			for pointed_thing in core.raycast(end_pos, particle_pos) do
				if pointed_thing.type == "object" and pointed_thing.ref == actor then
					particle_pos = pointed_thing.intersection_point
					break
				end
			end
			core.add_particle({
				pos = particle_pos,
				velocity = vel,
				acceleration = vector.new(0, -9.8, 0),
				expirationtime = 1,
				size = 2 + math.random(),
				texture = "blood_splatter_particle.png",
				animation = {type = "vertical_frames", aspect_w = 8, aspect_h = 8, length = 0.8},
			})
		end
	end
end

local blood_color = {
["mobs_monster:dirt_monster"]="#594E2E",
["mobs_monster:sand_monster"]="#c2b280",
["mobs_monster:tree_monster"]="#C0D036",
["mobs_monster:stone_monster"]=false,
["mobs_monster:lava_flan"]=false,
["mobs_monster:obsidian_flan"]=false,
["mobs_monster:fire_spirit"]=false,
["mobs_ghost_redo:ghost"]=false,
["mobs_skeletons:skeleton"]=false,
["mobs_skeletons:skeleton_archer"]=false,
["mobs_skeletons:skeleton_archer_dark"]=false,

["mobs_mc:ghast"]=false,
["mobs_mc:skeleton_horse"]=false,
["mobs_mc:skeleton"]=false,
["mobs_mc:witherskeleton"]=false,
["mobs_mc:wither"]=false,
["mobs_mc:iron_golem"]=false,
["mobs_mc:vex"]=false,
["mobs_mc:creeper"]="#C0D036",
["mobs_mc:slime_small"]="#C0D036",
["mobs_mc:slime_big"]="#C0D036",
}

local function bleed_player(player, hp_change, reason)
	if hp_change < 0 then
		local pos = player:get_pos()
		bleed_any(player,pos, nil, -hp_change)
		--shared.set_hud_damage(player)
	end
end

core.register_on_mods_loaded(function()
	for k,v in pairs(core.registered_entities) do
		if v.is_mob or v._creatura_mob or v._cmi_is_mob then --mcl, creatura, mobs
			--~ print(k)
			local old_on_punch = v.on_punch
			v.on_punch = function(self, puncher, time_from_last_punch, tool_capabilities, dir, damage, ...)
					--mcl_mobs and mobs_api use health, creatura uses hp for whatever reason
					--get information that may be unobtainable after death for some mobs mobs_monster:spider
					local obj = self.object
					local selectionbox = obj:get_properties().selectionbox
					local pos = obj:get_pos()
					
					local hp_before = math.max(self.health or self.hp or 0,0)
					local r = old_on_punch(self, puncher, time_from_last_punch, tool_capabilities, dir, damage, ...)
					local hp_after = math.max(self.health or self.hp or 0,0)
					local hp_diff = hp_before - hp_after
					if hp_diff > 0 then damage = hp_diff end
					
					local color = blood_color[self.name]
					if color == false then return end
					bleed_any(obj,pos,color,damage,selectionbox)
					
					return r
				end
			core.register_entity(":"..k,v)
		end
	end
end)

core.register_on_player_hpchange(bleed_player)
