local game = core.get_game_info().id
local S = core.get_translator("cbeds")
--Do not change what overlays what. I've specifically done it this way to prevent weird edges because overlays hover slightly above the actual node.
local tiles = {
	bottom = {
		"cbeds_foot.png",
		{name="cbeds_bottom.png^[transform2", color="#ffffff"},
		{name="cbeds_foot_side.png", color="#ffffff"},
		{name="cbeds_foot_side.png^[transform4", color="#ffffff"},
		{name="cbeds_end.png", color="#ffffff"},
		{name="cbeds_end.png", color="#ffffff"},
	},
	top = {
		"cbeds_head.png",
		{name="cbeds_bottom.png", color="#ffffff"},
		{name="cbeds_head_side.png", color="#ffffff"},
		{name="cbeds_head_side.png^[transform4", color="#ffffff"},
		{name="cbeds_end.png", color="#ffffff"},
		{name="cbeds_end.png", color="#ffffff"},
	}
}

local overlay_tiles = {
	bottom = {
		"",
		"",
		"cbeds_foot_side_overlay.png",
		"cbeds_foot_side_overlay.png^[transform4",
		"",
		"cbeds_foot_end_overlay.png"
	},
	top = {
		{name="cbeds_head_pillow.png", color="#ffffff"},
		"",
		"cbeds_head_side_overlay.png",
		"cbeds_head_side_overlay.png^[transform4",
		"",
		"",
	}
}

local nodebox = {
	bottom = {
		{-0.5, -5/16, -0.5, 0.5, 1/16, 0.5},
		{-8/16,-8/16,-8/16,-5/16,-5/16,-5/16},
		{5/16,-8/16,-8/16,8/16,-5/16,-5/16},
		
	},
	top = {
		{-0.5, -5/16, -0.5, 0.5, 1/16, 0.5},
		{-8/16,-8/16,5/16,-5/16,-5/16,8/16},
		{5/16,-8/16,5/16,8/16,-5/16,8/16},
	},
}


if game == "mineclone2" or game == "mineclonia" then
	local mcl_bed_colors = {
		black="#3d3737",
		blue="#295993",
		brown="#704933",
		cyan="#287781",
		green="#336b31",
		grey="#6b5f5f",
		light_blue="#5495ce",
		lime="#73a54c",
		magenta="#a25da5",
		orange="#c37a35",
		pink="#ce7d8a",
		purple="#65448e",
		red="#a32e2a",
		silver="#a29190",
		white="#ede0cc",
		yellow="#d3ba47",
	}
	for v,_ in pairs(mcl_bed_colors) do
		core.override_item("mcl_beds:bed_"..v.."_bottom", {
			color = mcl_bed_colors[v],
			inventory_image = "cbeds_inv.png",
			wield_image = "cbeds_inv.png",
			inventory_overlay = "cbeds_inv_overlay.png",
			wield_overlay = "cbeds_inv_overlay.png",
			drawtype = "nodebox",
			tiles = tiles.bottom,
			overlay_tiles = overlay_tiles.bottom,
			node_box = {
				type = "fixed",
				fixed = nodebox.bottom
			},
			--~ mesh=false,
		})
		core.override_item("mcl_beds:bed_"..v.."_top", {
			color = mcl_bed_colors[v],
			drawtype = "nodebox",
			tiles = tiles.top,
			overlay_tiles = overlay_tiles.top,
			node_box = {
				type = "fixed",
				fixed = nodebox.top
			},
			--~ mesh=false,
		})
	end
else
	core.clear_craft({output="beds:bed_bottom"})
	core.clear_craft({output="beds:fancy_bed_bottom"})
	core.register_alias_force("beds:bed_bottom", "cbeds:red_bottom")
	core.register_alias_force("beds:bed_top", "cbeds:red_top")
	core.register_alias_force("beds:fancy_bed_bottom", "cbeds:red_bottom")
	core.register_alias_force("beds:fancy_bed_top", "cbeds:red_top")
	local mtg_bed_colors = {
		black="#2a2a2a",
		blue="#00428e",
		brown="#693500",
		cyan="#00939b",
		dark_green="#156500",
		dark_grey="#3c3c3c",
		green="#61e516",
		grey="#898989",
		magenta="#d2007b",
		orange="#df5f19",
		pink="#ffabab",
		red="#b40303",
		violet="#46047e",
		white="#ebebeb",
		yellow="#f8f20d",
	}
	local desc_map = {
		["Green"]="Lime",
		["Dark Green"]="Green",
		["Dark Grey"]="Grey",
		["Grey"]="Light Grey",
		["Violet"]="Purple",
	}
	local function bed(color)
		local wool = ("wool:" .. color)
		local desc = color:gsub("_"," "):gsub(" %l", string.upper):gsub("^%l", string.upper)
		if desc_map[desc] then desc = desc_map[desc] end
		beds.register_bed("cbeds:"..color, {
			description = S(desc.." Bed"),
			inventory_image = "cbeds_inv.png",
			wield_image = "cbeds_inv.png",
			
			
			tiles = tiles,
			nodebox = nodebox,
			selectionbox = {-0.5, -0.5, -0.5, 0.5, 0.0625, 1.5},
			recipe = {
				{wool, wool, wool},
				{"group:wood", "group:wood", "group:wood"}
			}
		})
	end
	local function override_item(node_name, t)
		local node = core.registered_nodes[node_name]
		t.groups = node.groups
		t.groups.bouncy=33
		local wool = core.registered_nodes["wool:white"]
		if wool then
			t.makes_footstep_sound = wool.makes_footstep_sound
			t.sounds = wool.sounds
		end
		core.override_item(node_name, t)
	end
	for v,_ in pairs(mtg_bed_colors) do
		bed(v)
		override_item("cbeds:"..v.."_bottom", {
			color = mtg_bed_colors[v],
			inventory_overlay = "cbeds_inv_overlay.png",
			wield_overlay = "cbeds_inv_overlay.png",
			overlay_tiles = overlay_tiles.bottom,
		})
		override_item("cbeds:"..v.."_top", {
			color = mtg_bed_colors[v],
			overlay_tiles = overlay_tiles.top,
		})
		core.register_alias_force("colorful_beds:"..v.."_bed_bottom", "cbeds:"..v.."_bottom")
		core.register_alias_force("colorful_beds:"..v.."_bed_top", "cbeds:"..v.."_top")
		core.register_alias_force("colorful_beds:"..v.."_fancy_bed_bottom", "cbeds:"..v.."_bottom")
		core.register_alias_force("colorful_beds:"..v.."_fancy_bed_top", "cbeds:"..v.."_top")
	end
end
