#!/bin/ruby
require 'json'

# Define paths
output_dir = '.'
ruby_output_file = "#{output_dir}/characters.rb"
lua_output_file = "#{output_dir}/characters.lua"

# Create output directory if it doesn't exist
Dir.mkdir(output_dir) unless Dir.exist?(output_dir)

# Define character ranges
basic_latin = ("A".."Z").to_a + ("a".."z").to_a + ("0".."9").to_a + [" ", "!", "?", "-", "+", ",", ".", ":"]
german_extra = ["Ä", "ä", "Ö", "ö", "Ü", "ü", "ß", "ſ"]
scandinavian_extra = ["Å", "å", "Æ", "æ", "Ø", "ø"]
english_extra = ['’']

# Combine characters
characters = (basic_latin + german_extra + scandinavian_extra + english_extra).uniq
#~ characters = (basic_latin + latin_1_supplement + latin_extended_a + latin_extended_b).uniq

# Generate filesystem-safe representations
filesystem_safe_characters = {}
characters.each do |char|
	filesystem_safe_characters[char] = char.ord.to_s(16)
	# ligatures
	filesystem_safe_characters["ck"] = "ck";
	filesystem_safe_characters["ch"] = "ch";
	filesystem_safe_characters["tz"] = "tz";
	filesystem_safe_characters["ſt"] = "st";
	filesystem_safe_characters["ſs"] = "ss"; # English
end

# Write Ruby table
File.open(ruby_output_file, 'w') do |file|
	file.puts "characters = {"
	filesystem_safe_characters.each do |char, rep|
		file.puts "	'#{char}' => '#{rep}',"
	end
	file.puts "}"
end

# Write Lua table
File.open(lua_output_file, 'w') do |file|
	file.puts "local characters = {"
	filesystem_safe_characters.each do |char, rep|
		file.puts "	['#{char}'] = '#{rep}',"
	end
	file.puts "}"
	file.puts "return characters"
end

puts "Ruby and Lua tables generated successfully in #{output_dir}!"
