local modpath = core.get_modpath(core.get_current_modname())

local characters = dofile(modpath .. "/characters.lua")

local list_extra = {
"ſ",
"ch",
"ck",
"ſt",
"ß",
"tz",
"ſs",
"’",
}


local function show_formspec(player_name, pos, current_input)
	local formspec =
	"formspec_version[5]size[5,3]" ..
	"field_close_on_enter[input;true]" ..
	"field[0,2;8,1;input;;" .. current_input .. "]" ..
	"field[0,0;0,0;metadata;;" .. core.pos_to_string(pos) .. "]"
	for i, entry in ipairs(list_extra) do
		local row = math.floor((i - 1) / 5)
		local col = (i - 1) % 5
		formspec = formspec .. "image_button[" .. (col) .. "," .. (row) .. ";1,1;"..";entry_" .. entry .. ";" .. entry .. "]"
	end

	core.show_formspec(player_name, "fraktur:formspec", formspec)
end

core.register_node("fraktur:node_with_formspec", {
	description = "Node with Formspec",
	tiles = {"default_wood.png"},
	groups = {cracky = 3},

	on_rightclick = function(pos, node, player, itemstack, pointed_thing)
		show_formspec(player:get_player_name(), "")
	end,
})

core.register_on_player_receive_fields(function(player, formname, fields)
	if formname == "fraktur:formspec" then
		local pos
		if fields.metadata then
			pos = core.string_to_pos(fields.metadata)
		end
		if not pos then return end
		
		local entry
		for field_name, _ in pairs(fields) do
			if field_name:find("^entry_") then
				entry = field_name:gsub("^entry_","")
				core.close_formspec(player:get_player_name(),"fraktur:formspec")
			end
		end

		if not entry and fields.input then
			entry = fields.input
			
		end
		
		if characters[entry] then
			node = core.get_node(pos)
			if node.name == "fraktur:20" then
				node.name = "fraktur:"..characters[entry]
				core.swap_node(pos,node)
				--~ core.chat_send_all(entry)
			end
		else
			show_formspec(player:get_player_name(), pos, "")
		end
	end
end)


for char,name in pairs(characters) do
	core.register_node("fraktur:"..name,{
		description = char,
		tiles = {
			"fraktur_20.png",
			"fraktur_20.png",
			"fraktur_20.png",
			"fraktur_20.png",
			"fraktur_20.png",
			"fraktur_"..name..".png",
		},
		groups = {dig_immediate=2,not_in_creative_inventory=(name ~= "46") and 1 or nil,},
		paramtype2 = "facedir",
		on_place = (name == "46") and function(itemstack, placer, pointed_thing)
			local pos = pointed_thing.under
			local node = core.get_node(pos)
			if not (core.registered_nodes[node.name] and core.registered_nodes[node.name].buildable_to) then
				pos = pointed_thing.above
				node = core.get_node(pos)
			end
			local param2 = core.dir_to_facedir(placer:get_look_dir(), true)
			local player_name = placer:get_player_name()
			if not core.is_protected(pos, player_name) then
				core.set_node(pos, {name = "fraktur:20", param2 = param2})
				if not core.is_creative_enabled(player_name) then itemstack:take_item(1) end
				show_formspec(player_name, pos, "")
			end
			return itemstack
		end or nil,
		drop = "fraktur:46",
	})
end

if core.get_modpath("default") then
	core.register_craft({
		output = "fraktur:46 33",
		recipe = {
			{"default:paper", "default:paper", "default:paper"},
			{"default:paper", "dye:black", "default:paper"},
			{"default:paper", "default:paper", "default:paper"}
		},
	})
elseif core.get_modpath("mcl_core") then
	core.register_craft({
		output = "fraktur:46 32",
		recipe = {
			{"mcl_core:paper", "mcl_core:paper", "mcl_core:paper"},
			{"mcl_core:paper", "mcl_dye:black", "mcl_core:paper"},
			{"mcl_core:paper", "mcl_core:paper", "mcl_core:paper"}
		},
	})
end