#!/bin/ruby
require 'fileutils'

# Define paths
font_file = 'path_to_your_font_file.ttf'
output_dir = 'textures'

# Create output directory if it doesn't exist
FileUtils.mkdir_p(output_dir)

# Define characters to export and their filesystem-safe filenames
characters = eval(File.read("characters.rb"))

characters.each do |char, filename|
  # Create SVG file for each character
  svg_content = <<-SVG
  <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32">
    <rect width="100%" height="100%" fill="white" />
    <text x="50%" y="25" text-anchor="middle" alignment-baseline="middle" font-family="UnifrakturCook" font-size="34">#{char}</text>
  </svg>
  SVG

  File.write("#{output_dir}/#{filename}.svg", svg_content)

  # Convert SVG to PNG using Inkscape
  system("inkscape #{output_dir}/#{filename}.svg --export-type=png --export-filename=#{output_dir}/fraktur_#{filename}.png --export-width=32 --export-height=32")
end
