local S = core.get_translator(core.get_current_modname())

local function process_nodes(pos, nodename, action, owner, source_pos, original_node)
	local visited = {}
	local directions = {
		{x=1, y=0, z=0}, {x=-1, y=0, z=0},
		{x=0, y=1, z=0}, {x=0, y=-1, z=0},
		{x=0, y=0, z=1}, {x=0, y=0, z=-1}
	}
	local queue = {pos}
	local node_count = 0
	local max_nodes = 100
	local found_nodes = {}

	-- First pass to find and count the nodes
	while #queue > 0 do
		local current_pos = table.remove(queue, 1)
		local pos_str = core.pos_to_string(current_pos)

		if not visited[pos_str] then
			visited[pos_str] = true

			local node = core.get_node(current_pos)
			if node.name == "ignore" then
				return
			elseif node.name == nodename then
				local meta = core.get_meta(current_pos)
				if (nodename ~= "hidestone:hidden" or meta:get_string("hidestone:pos") == source_pos) then
					node_count = node_count + 1
					if node_count > max_nodes or core.is_protected(current_pos, owner) then
						return
					end
					table.insert(found_nodes, current_pos)
					for _, dir in ipairs(directions) do
						table.insert(queue, vector.add(current_pos, dir))
					end
				end
			end
		end
	end

	-- Second pass to process the nodes found
	for _, current_pos in ipairs(found_nodes) do
		local node = core.get_node(current_pos)
		action(current_pos, node, original_node or source_pos)
	end
	return true
end

local function node_to_hidden(pos, node, source_pos)
	local original_name = node.name
	local old_meta = core.get_meta(pos):to_table()
	node.name = "hidestone:hidden"
	core.set_node(pos, node)
	local meta = core.get_meta(pos)
	meta:from_table(old_meta)
	meta:set_string("hidestone:pos", source_pos)
end
local function hidden_to_node(pos, node, original_node)
	local meta = core.get_meta(pos)
	node.name = original_node
	local old_meta = meta:to_table()
	core.set_node(pos, node)
	meta = core.get_meta(pos)
	old_meta.fields["hidestone:pos"]=nil
	meta:from_table(old_meta)
end

local function hide(pos, node)
	local facedir = vector.multiply(core.facedir_to_dir(node.param2),-1)
	local faced_pos = vector.add(pos, facedir)
	
	
	local faced_node = core.get_node(faced_pos)
	local original_name = faced_node.name
	if original_name ~= "air" and original_name ~= "hidestone:hidden" and not mesecon.mvps_stoppers[original_name] and core.registered_nodes[original_name] then
		local meta = core.get_meta(pos)
		local owner = meta:get_string("owner")
		if process_nodes(faced_pos, original_name, node_to_hidden, owner, vector.to_string(pos)) then
			meta:set_string("node",faced_node.name)
		end
	end
end
local function reveal(pos, node)
	local facedir = vector.multiply(core.facedir_to_dir(node.param2),-1)
	local faced_pos = vector.add(pos, facedir)
	
	
	local faced_node = core.get_node(faced_pos)
	
	if faced_node.name == "hidestone:hidden" then
		local meta = core.get_meta(pos)
		local owner = meta:get_string("owner")
		if process_nodes(faced_pos, "hidestone:hidden", hidden_to_node, owner, vector.to_string(pos), meta:get_string("node")) then
			meta:set_string("node","")
		end
	end
end
core.register_node("hidestone:hidestone", {
	description = S("Hidestone"),
	tiles = {"hidestone_side.png","hidestone_side.png","hidestone_side.png","hidestone_side.png","hidestone_side.png","hidestone_front.png"},
	paramtype2 = "facedir",
	groups = {cracky=3,pickaxey=1},
	_mcl_blast_resistance = 6,
	_mcl_hardness = 1.5,
	on_place = function(itemstack, placer, pointed_thing)
		local pos = pointed_thing.under
		local node = core.get_node(pos)
		if not (core.registered_nodes[node.name] and core.registered_nodes[node.name].buildable_to) then
			pos = pointed_thing.above
			node = core.get_node(pos)
		end
		local param2 = core.dir_to_facedir(placer:get_look_dir(), true)
		local player_name = placer:get_player_name()
		if not core.is_protected(pos, player_name) then
			core.set_node(pos, {name = "hidestone:hidestone", param2 = param2})
			local meta = core.get_meta(pos)
			meta:set_string("owner",placer:get_player_name())
			if not core.is_creative_enabled(player_name) then itemstack:take_item(1) end
		end
		return itemstack
	end,
	on_destruct = function(pos)
		local node = core.get_node(pos)
		reveal(pos, node)
	end,
	mesecons = {effector={
		action_on = hide,
		action_off = reveal,
		rules = function(node)
			local dir = core.facedir_to_dir(node.param2)
			for k, v in pairs(dir) do
				if v ~= 0 then
					dir = {k, -v}
					break
				end
			end
			local rules = table.copy(mesecon.rules.alldirs)
			for i, rule in ipairs(rules) do
				if rule[dir[1]] == dir[2] then
					table.remove(rules, i)
				end
			end
			return rules
		end
	}},
})
core.register_node("hidestone:hidden", {
	drawtype = "airlike",
	pointable = false,
	walkable = false,
	diggable = false,
	is_ground_content = false,
	sunlight_propagates = true,
	paramtype = "light",
	drop = "",
	groups = {unbreakable = 1},
    on_dig = function(pos, node, digger)
        return false
    end,
    on_blast = function()
        return
    end,
})
mesecon.register_mvps_stopper("hidestone:hidden")

core.register_craft({
	output = 'hidestone:hidestone',
	recipe = {
		{"mesecons_gamecompat:cobble", "mesecons_gamecompat:steel_ingot", "mesecons_gamecompat:cobble"},
		{"mesecons_gamecompat:steel_ingot", "group:mesecon_conductor_craftable", "mesecons_gamecompat:steel_ingot"},
		{"mesecons_gamecompat:cobble", "mesecons_gamecompat:steel_ingot", "mesecons_gamecompat:cobble"},
	}
})
