local shared = ...
shared.reload_animation["rifles:aa12"] = {{
	load_sound = "rifles_rifle_clip_in",
	inventory_image = "rifles_aa12_rld.png",
},{
	load_sound = "rifles_reload_a",
	inventory_image = "rifles_aa12.png",
},{
	load_sound = "rifles_reload_b",
	inventory_image = "rifles_aa12.png",
}}
shared.register_rifle("rifles:aa12", {
	wield_scale = {x=1.9,y=1.9,z=1.4},
	description = "AA-12",
	inventory_image = "rifles_aa12.png",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy=1,knockback=5},
		crit = 5,
		critEffc = 2.0,
		round = "rifles:shell",
		clip_size = 20,
		skill = {"shotgun_skill",40},
		magazine = "rifles:drum_mag",
		velocity = 25,
		accuracy = 40,
		cooldown = 0.2,
		reload = 1.5/4,
		has_shell = 1,
		durability = 750,
		smokeSize = 8,
		projectiles = 5,
		gravity = 4,
		unload_sound = "rifles_rifle_clip_out",
		sound = "rifles_shotgun_shot",
	},
})
shared.reload_animation["rifles:ak47"] = {{
	load_sound = "rifles_rifle_clip_in",
	inventory_image = "rifles_ak47_rld.png",
},{
	load_sound = "rifles_rifle_reload_a",
	inventory_image = "rifles_ak47.png",
},{
	load_sound = "rifles_rifle_reload_b",
	inventory_image = "rifles_ak47.png",
}}
shared.register_rifle("rifles:ak47", {
	wield_scale = {x=1.75,y=1.75,z=1.3},
	description = "AK-47",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy=7,knockback=5},
		crit = 12,
		critEffc = 2.9,
		round = "rifles:762mm",
		clip_size = 30,
		skill = {"arifle_skill",50},
		magazine = "rifles:assaultrifle_mag",
		velocity = 40,
		accuracy = 77,
		cooldown = 0.1,
		reload = 1.4/4,
		has_shell = 1,
		gravity = 0,
		durability = 1200,
		smokeSize = 5,
		mob_penetration = 15,
		node_penetration = 5,
		unload_sound = "rifles_rifle_clip_out",
		sound = "rifles_ak",
	},
	inventory_image = "rifles_ak47.png",
})
shared.reload_animation["rifles:awp"] = {{
	load_sound = "rifles_rifle_clip_in",
	inventory_image = "rifles_awp_noclip.png",
},{
	load_sound = "rifles_rifle_reload_a",
	inventory_image = "rifles_awp.png",
},{
	load_sound = "rifles_rifle_reload_b",
	inventory_image = "rifles_awp_rld.png",
}}
shared.register_rifle("rifles:awp", {
	description = "AWP",
	weapon_zoom = 7.5,
	wield_scale = {x=1.9,y=1.9,z=1.1},
	inventory_image = "rifles_awp.png",
_rifle_traits = {
		rld_sound = "rifles_rifle_reload_a",
		rld_time = 1.0,
		loaded_sound = "rifles_rifle_reload_b",
		loaded_gun = "rifles_awp_rld.png",
		damage = {fleshy=18,knockback=15},
		crit = 30,
		critEffc = 3.0,
		round = "rifles:762mm",
		clip_size = 10,
		skill = {"rifle_skill",20},
		magazine = "rifles:rifle_mag",
		cooling = "uld",
		velocity = 75,
		accuracy = 100,
		cooldown = 1.0,
		reload = 2.0/4,
		has_shell = 0,
		durability = 700,
		smokeSize = 8,
		dps = 35,
		mob_penetration = 30,
		node_penetration = 10,
		unload_sound = "rifles_rifle_clip_out",
		sound = "rifles_rifle_b",
	},
})
shared.register_rifle("rifles:benelli", {
	description = "Benelli M3",
	wield_scale = {x=1.9,y=1.9,z=1.1},
	inventory_image = "rifles_benelli.png",
_rifle_traits = {
		rld_sound = "rifles_shotgun_reload_a",
		rld_time = 0.6,
		loaded_sound = "rifles_shotgun_reload_b",
		loaded_gun = "rifles_benelli_rld.png",
		damage = {fleshy=2,knockback=6},
		crit = 6,
		critEffc = 2.0,
		round = "rifles:shell",
		clip_size = 7,
		skill = {"shotgun_skill",20},
		cooling = "uld",
		velocity = 25,
		accuracy = 48,
		cooldown = 0.6,
		gravity = 4,
		reload = 0.25,
		projectiles = 5,
		has_shell = 0,
		durability = 325,
		smokeSize = 14,
		sound = "rifles_shotgun_shot",
		unload_sound = "rifles_shell_insert",
		load_single_bullet = true,
	},
})
shared.reload_animation["rifles:beretta"] = {{
	load_sound = "rifles_handgun_mag_in",
	inventory_image = "rifles_beretta_rld.png",
}}
shared.register_rifle("rifles:beretta", {
	description = "Beretta M9",
	wield_scale = {x=1.1,y=1.1,z=1.05},
	inventory_image = "rifles_beretta.png",
_rifle_traits = {
		damage = {fleshy=4,knockback=4},
		crit = 15,
		critEffc = 2.1,
		round = "rifles:9mm",
		clip_size = 15,
		skill = {"handgun_skill",43},
		magazine = "rifles:handgun_mag_black",
		cooling = "rifles_beretta_rld.png",
		velocity = 25,
		accuracy = 94,
		cooldown = 0.4,
		reload = 0.5,
		has_shell = 1,
		durability = 1150,
		smokeSize = 5,
		unload_sound = "rifles_handgun_mag_out",
		sound = "rifles_beretta",
	},
})
shared.reload_animation["rifles:deagle"] = {{
		load_sound = "rifles_handgun_mag_in",
		inventory_image = "rifles_deagle_rld.png"
,
}}
shared.register_rifle("rifles:deagle", {
	description = "Desert Eagle",
		wield_scale = {x = 1.25, y = 1.25, z = 1.5},
		inventory_image = "rifles_deagle.png",
		_rifle_traits = {
			damage = {fleshy = 11, knockback = 6},
			crit = 20,
			critEffc = 2.2,
			round = "rifles:9mm",
		clip_size =  8,
			skill = {"revolver_skill", 40},
			magazine = "rifles:handgun_mag_white",
			cooling = "rifles_deagle_rld.png",
			velocity = 50,
			accuracy = 85,
			cooldown = 0.7,
			reload = 0.6 / 1,
			has_shell = 1,
			durability = 900,
			smokeSize = 7,
			mob_penetration = 15,
			node_penetration = 5,
			unload_sound = "rifles_handgun_mag_out",
			sound = "rifles_deagle"
		},
	}
)
shared.reload_animation["rifles:g36"] = {{
	load_sound = "rifles_handgun_mag_in",
	inventory_image = "rifles_g36_rld.png",
},{
	load_sound = "rifles_rifle_reload_a",
	inventory_image = "rifles_g36.png",
},{
	load_sound = "rifles_rifle_reload_b",
	inventory_image = "rifles_g36.png",
}}
shared.register_rifle("rifles:g36", {
	wield_scale = {x=1.75,y=1.75,z=1.3},
	description = "G36",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy=7,knockback=5},
		crit = 12,
		critEffc = 2.9,
		round = "rifles:556mm",
		clip_size = 30,
		skill = {"arifle_skill",55},
		magazine = "rifles:assaultrifle_mag",
		velocity = 40,
		accuracy = 80,
		cooldown = 0.08,
		reload = 1.2/4,
		has_shell = 1,
		gravity = 0,
		durability = 1500,
		smokeSize = 5,
		mob_penetration = 17,
		node_penetration = 6,
		unload_sound = "rifles_handgun_mag_out",
		sound = "rifles_smg",
	},
	inventory_image = "rifles_g36.png",
})
shared.reload_animation["rifles:glock17"] = {{
	load_sound = "rifles_handgun_mag_in",
	inventory_image = "rifles_glock17.png",
},{
	load_sound = "rifles_reload_a",
	inventory_image = "rifles_glock17.png",
},{
	load_sound = "rifles_reload_b",
	inventory_image = "rifles_glock17_rld.png",
}}
shared.register_rifle("rifles:glock17", {
	description = "Glock 17",
	wield_scale = {x=1.2,y=1.2,z=1.2},
	inventory_image = "rifles_glock17.png",
_rifle_traits = {
		damage = {fleshy=5,knockback=4},
		crit = 15,
		critEffc = 2.2,
		round = "rifles:9mm",
		clip_size = 17,
		skill = {"handgun_skill",45},
		magazine = "rifles:handgun_mag_black",
		cooling = "rifles_glock17_rld.png",
		velocity = 30,
		accuracy = 96,
		cooldown = 0.35,
		reload = 0.9/4,
		has_shell = 1,
		durability = 1400,
		smokeSize = 5,
		unload_sound = "rifles_handgun_mag_out",
		sound = "rifles_glock",
	},
})
shared.reload_animation["rifles:jackhammer"] = {{
	load_sound = "rifles_rifle_clip_in",
	inventory_image = "rifles_jackhammer_rld.png",
},{
	load_sound = "rifles_reload_a",
	inventory_image = "rifles_jackhammer.png",
},{
	load_sound = "rifles_reload_b",
	inventory_image = "rifles_jackhammer.png",
}}
shared.register_rifle("rifles:jackhammer", {
	wield_scale = {x=2.6,y=2.6,z=1.8},
	description = "Jackhammer",
	inventory_image = "rifles_jackhammer.png",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy=3,knockback=6},
		crit = 7,
		critEffc = 2.2,
		round = "rifles:shell",
		clip_size = 10,
		skill = {"shotgun_skill",35},
		magazine = "rifles:drum_mag",
		velocity = 30,
		accuracy = 35,
		cooldown = 0.25,
		reload = 1.6/4,
		has_shell = 1,
		durability = 825,
		smokeSize = 9,
		projectiles = 8,
		gravity = 3,
		unload_sound = "rifles_rifle_clip_out",
		sound = "rifles_shotgun_shot",
	},
})
shared.reload_animation["rifles:kriss"] = {{
	load_sound = "rifles_handgun_mag_in",
	inventory_image = "rifles_kriss_rld.png",
},{
	load_sound = "rifles_reload_a",
	inventory_image = "rifles_kriss.png",
},{
	load_sound = "rifles_reload_b",
	inventory_image = "rifles_kriss.png",
}}
shared.register_rifle("rifles:kriss", {
	wield_scale = {x=1.75,y=1.75,z=1.15},
	description = "Kriss Super V",
	inventory_image = "rifles_kriss.png",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy=1,knockback=0},
		crit = 6,
		critEffc = 1.95,
		round = "rifles:9mm",
		clip_size = 33,
		skill = {"mp_skill",90},
		magazine = "rifles:machinepistol_mag",
		velocity = 20,
		accuracy = 60,
		cooldown = 0.05,
		reload = 0.9/4,
		has_shell = 1,
		gravity = 0,
		durability = 1750,
		smokeSize = 4,
		unload_sound = "rifles_handgun_mag_out",
		sound = "rifles_machine_pistol",
	},
})
shared.reload_animation["rifles:m16"] = {{
	load_sound = "rifles_handgun_mag_in",
	inventory_image = "rifles_m16_rld.png",
},{
	load_sound = "rifles_rifle_reload_a",
	inventory_image = "rifles_m16.png",
},{
	load_sound = "rifles_rifle_reload_b",
	inventory_image = "rifles_m16.png",
}}
shared.register_rifle("rifles:m16", {
	wield_scale = {x=1.75,y=1.75,z=1.3},
	description = "M16",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy=6,knockback=4},
		crit = 11,
		critEffc = 2.75,
		round = "rifles:556mm",
		clip_size = 20,
		skill = {"arifle_skill",55},
		magazine = "rifles:assaultrifle_mag",
		velocity = 35,
		accuracy = 75,
		cooldown = 0.067,
		reload = 1.0/4,
		has_shell = 1,
		gravity = 0,
		durability = 1350,
		smokeSize = 5,
		mob_penetration = 10,
		unload_sound = "rifles_handgun_mag_out",
		sound = "rifles_smg",
	},
	inventory_image = "rifles_m16.png",
})
shared.reload_animation["rifles:m1991"] = {{
	load_sound = "rifles_handgun_mag_in",
	inventory_image = "rifles_m1991.png",
},{
	load_sound = "rifles_reload_a",
	inventory_image = "rifles_m1991.png",
},{
	load_sound = "rifles_reload_b",
	inventory_image = "rifles_m1991_rld.png",
}}
shared.register_rifle("rifles:m1991", {
	description = "M1991",
	wield_scale = {x=1.1,y=1.1,z=1.05},
	inventory_image = "rifles_m1991.png",
_rifle_traits = {
		damage = {fleshy=4,knockback=4},
		crit = 15,
		critEffc = 2.1,
		round = "rifles:9mm",
		clip_size = 8,
		skill = {"handgun_skill",40},
		magazine = "rifles:handgun_mag_black",
		cooling = "rifles_m1991_rld.png",
		velocity = 25,
		accuracy = 92,
		cooldown = 0.4,
		reload = 1.0/4,
		has_shell = 1,
		durability = 1000,
		smokeSize = 5,
		unload_sound = "rifles_handgun_mag_out",
		sound = "rifles_beretta",
	},
})
shared.reload_animation["rifles:m200"] = {{
	load_sound = "rifles_rifle_clip_in",
	inventory_image = "rifles_m200_noclip.png",
},{
	load_sound = "rifles_rifle_reload_a",
	inventory_image = "rifles_m200.png",
},{
	load_sound = "rifles_rifle_reload_b",
	inventory_image = "rifles_m200_rld.png",
}}
shared.register_rifle("rifles:m200", {
	description = "M200 Intervention ",
	weapon_zoom = 6,
	wield_scale = {x=2.1,y=2.1,z=1.2},
	inventory_image = "rifles_m200.png",
_rifle_traits = {
		rld_sound = "rifles_rifle_reload_a",
		rld_time = 1.0,
		loaded_sound = "rifles_rifle_reload_b",
		loaded_gun = "rifles_m200_rld.png",
		damage = {fleshy=22,knockback=20},
		crit = 33,
		critEffc = 3.25,
		round = "rifles:408ct",
		clip_size = 7,
		skill = {"rifle_skill",12},
		magazine = "rifles:rifle_mag",
		cooling = "uld",
		velocity = 80,
		accuracy = 100,
		cooldown = 1.5,
		reload = 2.5/4,
		has_shell = 0,
		durability = 900,
		smokeSize = 8,
		dps = 75,
		mob_penetration = 45,
		node_penetration = 15,
		unload_sound = "rifles_rifle_clip_out",
		sound = "rifles_rifle_b",
	},
})
shared.reload_animation["rifles:m60"] = {{
	load_sound = "rifles_rifle_clip_in",
	inventory_image = "rifles_m60_rld.png",
}}
shared.register_rifle("rifles:m60", {
	wield_scale = {x=2.0,y=2.0,z=1.4},
	description = "M60",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy=9,knockback=7},
		crit = 13,
		critEffc = 3.0,
		round = "rifles:762mm",
		clip_size = 100,
		skill = {"heavy_skill",60},
		velocity = 64,
		accuracy = 65,
		cooldown = 0.09,
		reload = 1.0,
		has_shell = 1,
		gravity = 0,
		durability = 2750,
		smokeSize = 5,
		mob_penetration = 27,
		node_penetration = 12,
		unload_sound = "rifles_rifle_clip_out",
		sound = "rifles_machinegun",
	},
	inventory_image = "rifles_m60.png",
})
shared.reload_animation["rifles:m79"] = {{
	load_sound = "rifles_reload_a",
	inventory_image = "rifles_m79_rld.png",
}}
shared.register_rifle("rifles:m79", {
	description = "M79",
	wield_scale = {x=2.0,y=2.0,z=2.5},
	inventory_image = "rifles_m79.png",
	_rifle_traits = {
		damage = {fleshy=10,knockback=25},
		crit = 8,
		critEffc = 3.0,
		round = "rifles:40mm",
		clip_size = 1,
		skill = {"",1},
		magazine = "rifles:shell_grenadedrop",
		velocity = 20,
		accuracy = 92,
		cooldown = 0.0,
		reload = 0.9,
		smokeSize = 15,
		durability = 100,
		gravity = 5,
		unload_sound = "rifles_handgun_mag_out",
		sound = "rifles_rocket",
	},
})
shared.reload_animation["rifles:makarov"] = {{
	load_sound = "rifles_handgun_mag_in",
	inventory_image = "rifles_makarov.png",
},{
	load_sound = "rifles_reload_a",
	inventory_image = "rifles_makarov.png",
},{
	load_sound = "rifles_reload_b",
	inventory_image = "rifles_makarov_rld.png",
}}
shared.register_rifle("rifles:makarov", {
	description = "Makarov Pistol",
	wield_scale = {x=0.9,y=0.9,z=1.0},
	inventory_image = "rifles_makarov.png",
	_rifle_traits = {
		damage = {fleshy=3,knockback=3},
		crit = 10,
		critEffc = 2.0,
		round = "rifles:9mm",
		clip_size = 8,
		skill = {"handgun_skill",40},
		magazine = "rifles:handgun_mag_black",
		cooling = "rifles_makarov_rld.png",
		velocity = 20,
		accuracy = 90,
		cooldown = 0.5,
		reload = 1.1/4,
		smokeSize = 5,
		has_shell = 1,
		durability = 450,
		unload_sound = "rifles_handgun_mag_out",
		sound = "rifles_glock",
	},
})
shared.register_rifle("rifles:milkor", {
	description = "Milkor MGL",
	wield_scale = {x=1.75,y=1.75,z=2.0},
	inventory_image = "rifles_milkor.png",
_rifle_traits = {
		loaded_gun = "rifles_milkor_rld.png",
		damage = {fleshy=15,knockback=25},
		crit = 9,
		critEffc = 3.0,
		round = "rifles:40mm",
		clip_size = 6,
		skill = {"",1},
		magazine = "rifles:shell_grenadedrop",
		velocity = 30,
		accuracy = 96,
		cooldown = 0.35,
		reload = 0.75,
		durability = 225,
		smokeSize = 15,
		gravity = 1,
		unload_sound = "rifles_shell_insert",
		sound = "rifles_rocket",
		load_single_bullet = true,
	},
})
shared.reload_animation["rifles:minigun"] = {{
	load_sound = "rifles_rifle_clip_in",
	inventory_image = "rifles_minigun_rld.png",
}}
shared.register_rifle("rifles:minigun", {
	wield_scale = {x = 2, y = 2.0, z = 2.0},
	description = "Minigun",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy = 10, knockback = 8},
		crit = 14,
		critEffc = 3.0,
		round = "rifles:762mm",
		clip_size =  200,
		skill = {"heavy_skill", 100},
		velocity = 70,
		accuracy = 50,
		cooldown = 0.04,
		reload = 2.0,
		has_shell = 1,
		gravity = 0,
		durability = 4000,
		smokeSize = 5,
		mob_penetration = 33,
		node_penetration = 15,
		unload_sound = "rifles_rifle_clip_out",
		sound = "rifles_machinegun"
	},
	inventory_image = "rifles_minigun.png"
})
shared.reload_animation["rifles:mp40"] = {{
	load_sound = "rifles_handgun_mag_in",
	inventory_image = "rifles_mp40_rld.png"
},{
	load_sound = "rifles_reload_a",
	inventory_image = "rifles_mp40.png"
},{
	inventory_image = "rifles_mp40.png",
	load_sound = "rifles_reload_b",
}}
shared.register_rifle("rifles:mp40", {
	wield_scale = {x=1.75,y=1.75,z=1.5},
	description = "MP-40",
	inventory_image = "rifles_mp40.png",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy=2,knockback=1},
		crit = 8,
		critEffc = 2.0,
		round = "rifles:9mm",
		clip_size = 32,
		skill = {"smg_skill",75},
		magazine = "rifles:machinepistol_mag",
		velocity = 25,
		accuracy = 75,
		cooldown = 0.14,
		reload = 1.3/4,
		has_shell = 1,
		gravity = 0,
		durability = 1500,
		smokeSize = 4,
		unload_sound = "rifles_handgun_mag_out",
		sound = "rifles_machine_pistol",
	},
})
shared.reload_animation["rifles:mp5"] = {{
	load_sound = "rifles_handgun_mag_in",
	inventory_image = "rifles_mp5_rld.png",
},{
	load_sound = "rifles_reload_a",
	inventory_image = "rifles_mp5.png",
},{
	load_sound = "rifles_reload_b",
	inventory_image = "rifles_mp5.png",
}}
shared.register_rifle("rifles:mp5", {
	wield_scale = {x=1.75,y=1.75,z=1.20},
	description = "MP5",
	inventory_image = "rifles_mp5.png",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy=3,knockback=1},
		crit = 7,
		critEffc = 2.0,
		round = "rifles:9mm",
		clip_size = 40,
		skill = {"smg_skill",75},
		magazine = "rifles:machinepistol_mag",
		velocity = 25,
		accuracy = 74,
		cooldown = 0.075,
		reload = 1.0/4,
		has_shell = 1,
		gravity = 0,
		durability = 1600,
		smokeSize = 4,
		unload_sound = "rifles_handgun_mag_out",
		sound = "rifles_machine_pistol",
	},
})
shared.register_rifle("rifles:python", {
	description = "Colt Python",
	wield_scale = {x=1.25,y=1.25,z=1.1},
	inventory_image = "rifles_python.png",
_rifle_traits = {
		loaded_gun = "rifles_python_rld.png",
		damage = {fleshy=10,knockback=6},
		crit = 19,
		critEffc = 2.2,
		round = "rifles:9mm",
		clip_size = 6,
		skill = {"revolver_skill",40},
		velocity = 55,
		accuracy = 95,
		cooldown = 0.2,
		reload = 0.4,
		durability = 1000,
		smokeSize = 7,
		mob_penetration = 15,
		node_penetration = 5,
		unload_sound = "rifles_shell_insert",
		sound = "rifles_deagle",
		load_single_bullet = true,
	},
})
shared.register_rifle("rifles:remington", {
	description = "Remington 870",
	wield_scale = {x=1.9,y=1.9,z=1.1},
	inventory_image = "rifles_remington.png",
_rifle_traits = {
		rld_sound = "rifles_shotgun_reload_a",
		rld_time = 0.8,
		loaded_sound = "rifles_shotgun_reload_b",
		loaded_gun = "rifles_remington_rld.png",
		damage = {fleshy=1,knockback=5},
		crit = 4,
		critEffc = 2.0,
		round = "rifles:shell",
		clip_size = 4,
		skill = {"shotgun_skill",20},
		cooling = "uld",
		velocity = 18,
		accuracy = 40,
		cooldown = 0.8,
		gravity = 5,
		reload = 0.25,
		projectiles = 4,
		has_shell = 0,
		durability = 275,
		smokeSize = 14,
		sound = "rifles_shotgun_shot",
		unload_sound = "rifles_shell_insert",
		load_single_bullet = true,
	},
})
shared.register_rifle("rifles:rpg", {
	description = "RPG7",
	wield_scale = {x=2.5,y=2.5,z=3.75},
	inventory_image = "rifles_rpg.png",
	_rifle_traits = {
		loaded_gun = "rifles_rpg_rld.png",
		cooling = "rifles_rpg.png",
		damage = {fleshy=20,knockback=35},
		crit = 10,
		critEffc = 3.0,
		round = "rifles:rocket",
		clip_size = 1,
		skill = {"",1},
		velocity = 25,
		accuracy = 100,
		cooldown = 1.0,
		reload = 1.0,
		smokeSize = 15,
		durability = 150,
		sound = "rifles_rocket",
		unload_sound = "rifles_shell_insert",
		load_single_bullet = true,
	},
})
shared.reload_animation["rifles:rpk"] = {{
	load_sound = "rifles_rifle_clip_in",
	inventory_image = "rifles_rpk_rld.png",
},{
	load_sound = "rifles_rifle_reload_a",
	inventory_image = "rifles_rpk.png",
},{
	load_sound = "rifles_rifle_reload_b",
	inventory_image = "rifles_rpk.png",
}}
shared.register_rifle("rifles:rpk", {
	wield_scale = {x=1.75,y=1.75,z=1.3},
	description = "RPK",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy=7,knockback=6},
		crit = 12,
		critEffc = 3.0,
		round = "rifles:762mm",
		clip_size = 75,
		skill = {"heavy_skill",55},
		magazine = "rifles:drum_mag",
		velocity = 55,
		accuracy = 70,
		cooldown = 0.1,
		reload = 2.0/4,
		has_shell = 1,
		gravity = 0,
		durability = 2250,
		smokeSize = 5,
		mob_penetration = 25,
		node_penetration = 10,
		unload_sound = "rifles_rifle_clip_out",
		sound = "rifles_ak",
	},
	inventory_image = "rifles_rpk.png",
})
shared.reload_animation["rifles:scar"] = {{
	load_sound = "rifles_rifle_clip_in",
	inventory_image = "rifles_scar_rld.png",
},{
	load_sound = "rifles_rifle_reload_a",
	inventory_image = "rifles_scar.png",
},{
	load_sound = "rifles_rifle_reload_b",
	inventory_image = "rifles_scar.png",
}}
shared.register_rifle("rifles:scar", {
	wield_scale = {x=1.7,y=1.7,z=1.25},
	description = "FN SCAR 16",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy=9,knockback=6},
		crit = 11,
		critEffc = 2.75,
		round = "rifles:556mm",
		clip_size = 30,
		skill = {"arifle_skill",50},
		magazine = "rifles:assaultrifle_mag",
		velocity = 45,
		accuracy = 85,
		cooldown = 0.15,
		reload = 1.2/4,
		has_shell = 1,
		gravity = 0,
		durability = 1600,
		smokeSize = 5,
		mob_penetration = 20,
		node_penetration = 7,
		unload_sound = "rifles_rifle_clip_out",
		sound = "rifles_ak",
	},
	inventory_image = "rifles_scar.png",
})
shared.register_rifle("rifles:spas12", {
	description = "SPAS-12",
	wield_scale = {x=1.9,y=1.9,z=1.1},
	inventory_image = "rifles_spas12.png",
_rifle_traits = {
		rld_sound = "rifles_shotgun_reload_a",
		rld_time = 0.6,
		loaded_sound = "rifles_shotgun_reload_b",
		loaded_gun = "rifles_spas12_rld.png",
		damage = {fleshy=3,knockback=7},
		crit = 7,
		critEffc = 2.1,
		round = "rifles:shell",
		clip_size = 8,
		skill = {"shotgun_skill",20},
		cooling = "uld",
		velocity = 32,
		accuracy = 52,
		cooldown = 0.45,
		gravity = 3,
		reload = 0.25,
		projectiles = 6,
		has_shell = 0,
		durability = 550,
		smokeSize = 15,
		sound = "rifles_shotgun_shot",
		unload_sound = "rifles_shell_insert",
		load_single_bullet = true,
	},
})
shared.reload_animation["rifles:svd"] = {{
	load_sound = "rifles_rifle_clip_in",
	inventory_image = "rifles_svd_noclip.png",
},{
	load_sound = "rifles_rifle_reload_a",
	inventory_image = "rifles_svd.png",
},{
	load_sound = "rifles_rifle_reload_b",
	inventory_image = "rifles_svd_rld.png",
}}
shared.register_rifle("rifles:svd", {
	description = "SVD",
	weapon_zoom = 9,
	wield_scale = {x=1.9,y=1.9,z=1.1},
	inventory_image = "rifles_svd.png",
_rifle_traits = {
		rld_sound = "rifles_rifle_reload_a",
		rld_time = 1.0,
		loaded_sound = "rifles_rifle_reload_b",
		loaded_gun = "rifles_svd_rld.png",
		damage = {fleshy=17,knockback=14},
		crit = 30,
		critEffc = 3.0,
		round = "rifles:762mm",
		clip_size = 10,
		skill = {"rifle_skill",20},
		magazine = "rifles:rifle_mag",
		cooling = "uld",
		velocity = 75,
		accuracy = 100,
		cooldown = 1.0,
		reload = 2.0/4,
		has_shell = 0,
		durability = 700,
		smokeSize = 8,
		dps = 30,
		mob_penetration = 30,
		node_penetration = 10,
		unload_sound = "rifles_rifle_clip_out",
		sound = "rifles_rifle_b",
	},
})
shared.register_rifle("rifles:taurus", {
	description = "Taurus Raging Bull ",
	wield_scale = {x=1.25,y=1.25,z=1.1},
	inventory_image = "rifles_taurus.png",
_rifle_traits = {
		loaded_gun = "rifles_taurus_rld.png",
		damage = {fleshy=14,knockback=8},
		crit = 22,
		critEffc = 3.1,
		round = "rifles:9mm",
		clip_size = 6,
		skill = {"revolver_skill",40},
		velocity = 55,
		accuracy = 97,
		cooldown = 0.2,
		reload = 0.4,
		durability = 1750,
		smokeSize = 7,
		mob_penetration = 24,
		node_penetration = 8,
		unload_sound = "rifles_shell_insert",
		sound = "rifles_deagle",
		load_single_bullet = true,
	},
})
shared.reload_animation["rifles:tec9"] = {{
	load_sound = "rifles_handgun_mag_in",
	inventory_image = "rifles_tec9_rld.png",
},{
	load_sound = "rifles_reload_a",
	inventory_image = "rifles_tec9.png",
},{
	load_sound = "rifles_reload_b",
	inventory_image = "rifles_tec9.png",
}}
shared.register_rifle("rifles:tec9", {
	wield_scale = {x=1.25,y=1.25,z=1.50},
	description = "TEC-9",
	inventory_image = "rifles_tec9.png",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy=1,knockback=0},
		crit = 9,
		critEffc = 1.9,
		round = "rifles:9mm",
		clip_size = 50,
		skill = {"mp_skill",80},
		magazine = "rifles:machinepistol_mag",
		velocity = 20,
		accuracy = 75,
		cooldown = 0.2,
		reload = 1.0/4,
		has_shell = 1,
		gravity = 0,
		durability = 1100,
		smokeSize = 4,
		unload_sound = "rifles_handgun_mag_out",
		sound = "rifles_machine_pistol",
	},
})
shared.reload_animation["rifles:thompson"] = {{
	load_sound = "rifles_handgun_mag_in",
	inventory_image = "rifles_thompson_rld.png",
},{
	load_sound = "rifles_reload_a",
	inventory_image = "rifles_thompson.png",
},{
	load_sound = "rifles_reload_b",
	inventory_image = "rifles_thompson.png",
}}
shared.register_rifle("rifles:thompson", {
	wield_scale = {x=1.9,y=1.9,z=1.25},
	description = "Thompson SMG",
	inventory_image = "rifles_thompson.png",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy=4,knockback=1},
		crit = 8,
		critEffc = 2.0,
		round = "rifles:9mm",
		clip_size = 30,
		skill = {"smg_skill",65},
		magazine = "rifles:machinepistol_mag",
		velocity = 30,
		accuracy = 75,
		cooldown = 0.1,
		reload = 1.4/4,
		has_shell = 1,
		gravity = 0,
		durability = 1250,
		smokeSize = 4,
		unload_sound = "rifles_handgun_mag_out",
		sound = "rifles_smg",
	},
})
shared.reload_animation["rifles:tmp"] = {{
	load_sound = "rifles_handgun_mag_in",
	inventory_image = "rifles_tmp_rld.png",
},{
	load_sound = "rifles_reload_a",
	inventory_image = "rifles_tmp.png",
},{
	load_sound = "rifles_reload_b",
	inventory_image = "rifles_tmp.png",
}}
shared.register_rifle("rifles:tmp", {
	wield_scale = {x=1.15,y=1.15,z=1.15},
	description = "Steyr TMP",
	inventory_image = "rifles_tmp.png",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy=1,knockback=0},
		crit = 4,
		critEffc = 1.85,
		round = "rifles:9mm",
		clip_size = 30,
		skill = {"mp_skill",85},
		magazine = "rifles:machinepistol_mag",
		velocity = 20,
		accuracy = 64,
		cooldown = 0.066,
		reload = 1.0/4,
		has_shell = 1,
		gravity = 0,
		durability = 1200,
		smokeSize = 4,
		unload_sound = "rifles_handgun_mag_out",
		sound = "rifles_machine_pistol",
	},
})
shared.reload_animation["rifles:ump"] = {{
	load_sound = "rifles_handgun_mag_in",
	inventory_image = "rifles_ump_rld.png",
},{
	load_sound = "rifles_reload_a",
	inventory_image = "rifles_ump.png",
},{
	load_sound = "rifles_reload_b",
	inventory_image = "rifles_ump.png",
}}
shared.register_rifle("rifles:ump", {
	wield_scale = {x=1.9,y=1.9,z=1.25},
	description = "UMP-9",
	inventory_image = "rifles_ump.png",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy=5,knockback=1},
		crit = 9,
		critEffc = 2.0,
		round = "rifles:9mm",
		clip_size = 25,
		skill = {"smg_skill",60},
		magazine = "rifles:machinepistol_mag",
		velocity = 32,
		accuracy = 79,
		cooldown = 0.115,
		reload = 1.25/4,
		has_shell = 1,
		gravity = 0,
		durability = 1500,
		smokeSize = 4,
		unload_sound = "rifles_handgun_mag_out",
		sound = "rifles_smg",
	},
})
shared.reload_animation["rifles:uzi"] = {{
	load_sound = "rifles_handgun_mag_in",
	inventory_image = "rifles_uzi_rld.png",
},{
	load_sound = "rifles_reload_a",
	inventory_image = "rifles_uzi.png",
},{
	load_sound = "rifles_reload_b",
	inventory_image = "rifles_uzi.png",
}}
shared.register_rifle("rifles:uzi", {
	wield_scale = {x=1.6,y=1.6,z=1.10},
	description = "UZI",
	inventory_image = "rifles_uzi.png",
	_rifle_traits = {
		automatic_gun = true,
		damage = {fleshy=2,knockback=0},
		crit = 5,
		critEffc = 1.9,
		round = "rifles:9mm",
		clip_size = 40,
		skill = {"mp_skill",80},
		magazine = "rifles:machinepistol_mag",
		velocity = 25,
		accuracy = 72,
		cooldown = 0.08,
		reload = 1.2/4,
		has_shell = 1,
		gravity = 0,
		durability = 1500,
		smokeSize = 4,
		unload_sound = "rifles_handgun_mag_out",
		sound = "rifles_machine_pistol",
	},
})
shared.reload_animation["rifles:luger"] = {{
	load_sound = "rifles_handgun_mag_in",
	inventory_image = "rifles_luger.png",
},{
	load_sound = "rifles_reload_a",
	inventory_image = "rifles_luger.png",
},{
	load_sound = "rifles_reload_b",
	inventory_image = "rifles_luger_rld.png",
}}
shared.register_rifle("rifles:luger", {
	description = "Luger P08",
	wield_scale = {x=0.9,y=0.9,z=1.0},
	inventory_image = "rifles_luger.png",
	_rifle_traits = {
		damage = {fleshy=4,knockback=3},
		crit = 10,
		critEffc = 2.0,
		round = "rifles:9mm",
		clip_size = 8,
		skill = {"handgun_skill",40},
		magazine = "rifles:handgun_mag_black",
		cooling = "rifles_luger_rld.png",
		velocity = 20,
		accuracy = 92,
		cooldown = 0.625,
		reload = 1.0/4,
		has_shell = 1,
		durability = 600,
		smokeSize = 5,
		unload_sound = "rifles_handgun_mag_out",
		sound = "rifles_glock",
	},
})
