local S = core.get_translator(core.get_current_modname())

local rangedweapons_shot_bullet = {
	timer = 0,
	initial_properties = {
		static_save = false,
		pointable = false,
		physical = false,
		hp_max = 420,
		visual = "wielditem",
		visual_size = {x = 0.75, y = 0.75},
		--~ textures = {"shuriken:shot_bullet_visual"},
		lastpos = {},
		selectionbox = {-0.5, -0.5, -0.0025, 0.5, 0.5, 0.0025, rotate=true},
	},
	_rotation_timer = 0,
	_ricochet = 0,
	on_activate = function (self, staticdata, dtime_s)
		self._old_pos = self.object:get_pos()
	end,
	--~ on_deactivate = function(self, removal)
		--~ core.add_item(self.object:get_pos(), self._drop)
	--~ end,
	on_punch = function (self, puncher, time_from_last_punch, tool_capabilities, dir, damage)
		if self._attached and puncher:is_player() then
			local inv = puncher:get_inventory()
			if inv:room_for_item("main",self._drop) then
				inv:add_item("main",self._drop)
				self.object:remove()
				return
			end
		end
	end,
	_attach = function(self,node_pos,hit_pos,pointed_thing)
		self._ricochet = self._ricochet + 1
		self._attached = true
		self._attach_pos = node_pos
		
		-- Move the bullet slightly above the hit position
		local new_pos = vector.add(hit_pos, vector.multiply(((pointed_thing.intersection_normal or vector.new())), 0.3)) -- adjust the 0.1 value as needed
		self.object:set_pos(new_pos)
		
	
		
		local o = self.object
		o:set_pos(new_pos)
		o:set_properties({pointable = true})
		o:set_acceleration(vector.new())
		o:set_velocity(vector.new())
	end,
	_unattach = function(self)
		self._attached = false
		local o = self.object
		o:set_properties({pointable = false})
		o:set_acceleration(vector.new(0,-9.81,0))
	end,
on_step = function(self, dtime, moveresult)
	if self.owner == nil then
		self.object:remove()
		return
	end
	
	self.timer = self.timer + dtime
	if self.timer > 900 then
		self.object:remove()
		return
	end
	
	if self._attached then 
		if core.get_node(self._attach_pos).name == "air" then
			self:_unattach()
		end
		return
	end
	
	self._rotation_timer = self._rotation_timer + dtime
	if self._rotation_timer >= 0.2 then
		self._rotation_timer = 0
		local rotation_speed = math.pi * 3  -- Rotation speed (radians per second)
		local current_rotation = self.object:get_rotation()

		-- Update rotation
		current_rotation.z = current_rotation.z + rotation_speed * -0.2
		self.object:set_rotation(current_rotation)
	end

	local pos = self.object:get_pos()

	for pointed_thing in core.raycast(self._old_pos, self.object:get_pos(), true, true) do
		local hit_pos = pointed_thing.intersection_point

		if pointed_thing.type == "node" then
			local node_pos = pointed_thing.under
			local node = core.get_node(node_pos)
			local node_def = core.registered_nodes[node.name]
			if node_def and node_def.walkable then
				core.check_for_falling(node_pos)

				local nodedef = minetest.registered_nodes[node.name]
				if nodedef and nodedef.sounds and nodedef.sounds.dig then
					core.sound_play(nodedef.sounds.dig.name, {pos = hit_pos}, true)
				end

				self:_attach(node_pos,hit_pos,pointed_thing)
				break
			end
		elseif pointed_thing.type == "object" and (
				(pointed_thing.ref:is_player() and (pointed_thing.ref:get_player_name() ~= self.owner or self._ricochet > 0))
				or
				(pointed_thing.ref:get_luaentity() and pointed_thing.ref:get_properties().physical and pointed_thing.ref:get_luaentity().name ~= '__builtin:item')
			) then
			local actualDamage = self.damage or {fleshy = 1}
			local damage = {}
			local crit = self.crit or 0
			local critEffc = self.critEffc or 1
			local owner = core.get_player_by_name(self.owner)
			local hit_texture = "rangedweapons_hit.png"
			local dps = self.dps or 0
			local skill = self.skill_value or 1

			for k, dmg in pairs(actualDamage) do
				damage[k] = actualDamage[k]
			end

			--headshot bonus
			if pointed_thing.ref:is_player() then
				if hit_pos.y - pointed_thing.ref:get_pos().y > 1.5 then
					for k, hs_dmg in pairs(damage) do
						damage[k] = damage[k] * 1.75
					end
				end
			end
			-- put bullet in front of object before punching in order to get correct engine knockback
			self.object:set_pos(self._old_pos)
			pointed_thing.ref:punch(
				self.object,
				1.0,
				{
					full_punch_interval = 1.0,
					damage_groups = damage
				},
				nil
			)

			self.object:remove()
			break
		end
	end
	
	
	self._old_pos = self.object:get_pos()
end
}
core.register_entity("shuriken:shot_bullet", rangedweapons_shot_bullet)

local function launch_projectile(itemstack,
	player,
	projDmg)

	local pos = player:get_pos()
	local dir = player:get_look_dir()
	local yaw = player:get_look_horizontal()
	local svertical = player:get_look_vertical()
	
	core.sound_play("shuriken_throw", {pos = pos}, true)
	pos.y = pos.y + 1.45

	local projectiles = projNum or 1
	for i = 1, projectiles do
		local obj = core.add_entity(pos, "shuriken:shot_bullet")
		obj:set_properties({textures = {itemstack:get_name()}})
		local ent = obj:get_luaentity()

		local combined_velocity = 20
		ent.owner = player:get_player_name()
		if obj then
			ent.damage = projDmg
			ent._drop = itemstack:get_name()
			ent.timer = 0 + (combined_velocity / 2000)
			local acc = (0.4 + itemstack:get_definition()._rifle_traits.accuracy/100*3)
			obj:set_velocity(vector.new(
					dir.x * combined_velocity + math.random(-acc, acc),
					dir.y * combined_velocity + math.random(-acc, acc),
					dir.z * combined_velocity + math.random(-acc, acc)
			))
			obj:set_acceleration({x = 0, y = -9.81, z = 0})
			obj:set_rotation({x = 0, y = yaw - math.pi / 2, z = -svertical})
		end
	end
end
local player_cooldowns = {}
local rangedweapons_yeet = function(itemstack, player)
	local ThrowCaps = itemstack:get_definition()._rifle_traits
	local player_name = player:get_player_name()
	local current_time = os.clock()
	if player_cooldowns[player_name] then
		local cooldown_end_time = player_cooldowns[player_name]
		if current_time < cooldown_end_time then
			return
		end
	end
	player_cooldowns[player_name] = current_time + 0.5
	local throw_damage = ThrowCaps.damage or {fleshy = 1}
	launch_projectile(itemstack, player, throw_damage)
	itemstack:take_item()
end

local rifle_traits = {
	stone = {
		damage = {fleshy=4,knockback=8},
		velocity = 20,
		accuracy = 75,
	},
	steel = {
		damage = {fleshy=6,knockback=3},
		velocity = 30,
		accuracy = 85,
	},
	bronze = {
		damage = {fleshy=6,knockback=3},
		velocity = 30,
		accuracy = 85,

	},
	gold = {
		damage = {fleshy=8,knockback=10},
		velocity = 25,
		accuracy = 75,
	},
	mese = {
		damage = {fleshy=7,knockback=2},
		velocity = 35,
		accuracy = 90,
	},
	diamond = {
		damage = {fleshy=8,knockback=2},
		velocity = 40,
		accuracy = 95,
	},
}
local shuriken_recipe = function(variant, ingredient, amount)
	core.register_craft({
		output = "shuriken:"..variant.." "..amount,
		recipe = {
			{"", ingredient, ""},
			{ingredient, "", ingredient},
			{"", ingredient, ""},
		}
	})
	core.register_craftitem("shuriken:"..variant, {
		description = S(variant:gsub("^%l", string.upper).." shuriken"),
		range = 0,
		stack_max= 200,
		--~ on_use = function() end,
		wield_scale = {x=0.6,y=0.6,z=0.5},
		inventory_image = "shuriken_"..variant..".png",
		_rifle_traits = rifle_traits[variant],
		on_use = function(itemstack, user, pointed_thing)
			rangedweapons_yeet(itemstack, user) return itemstack
		end,
	})
end

if minetest.get_modpath("mcl_core") then
	shuriken_recipe("stone","mcl_core:cobble", 10)
	shuriken_recipe("steel","mcl_core:iron_ingot", 30)
	shuriken_recipe("bronze","mcl_core:bronze_ingot", 35)
	shuriken_recipe("gold","mcl_core:gold_ingot", 42)
	shuriken_recipe("diamond","mcl_core:diamond", 69)
else
	shuriken_recipe("stone","default:cobble", 10)
	shuriken_recipe("steel","default:steel_ingot", 30)
	shuriken_recipe("bronze","default:bronze_ingot", 35)
	shuriken_recipe("gold","default:gold_ingot", 42)
	shuriken_recipe("mese","default:mese_crystal", 55)
	shuriken_recipe("diamond","default:diamond", 69)
end