local S = core.get_translator("simple_crafting")
local game = core.get_game_info().id
local items = {}
local stacksize = 99
local only_show_craftable_items=true
local player_state = {}
local state_template = {
	scrollpos_craftables = 0,
	scrollpos_recipes = 0,
	allow_update = true
	}
local mod_sfinv = core.get_modpath("sfinv")
function itemname_matcher(group) --group or node
	if string.find(group, "^group:") then
		local groups = string.split(group:sub(7), ",")
		return function(nodename)
			for _, groupname in pairs(groups) do
				if core.get_item_group(nodename, groupname) == 0 then
					return false
				end
			end
			return true
		end
	else
		return function(nodename)
			return nodename == group
		end
	end
	
end

local function first_registered_item_of_group(group)
	for name, def in pairs(core.registered_items) do
		if itemname_matcher(group)(name) then
			return name
		end
	end
end

local function is_group(s)
	if s:find("^group:") then return true end
end

local function simplerecipe(r)
	local newrecipe = {}
	for i=1,9 do
		local v = r[i]
		if v then newrecipe[v] = newrecipe[v] and newrecipe[v]+1 or 1 end
	end
	return newrecipe
end

local function sortinv(r)
	local temp = {}
	for i,v in ipairs(r) do
		v = v:to_table()
		if v then temp[v.name] = temp[v.name] and temp[v.name]+v.count or v.count end
	end
	local sortedinv = {}
	for k,v in pairs(temp) do
		table.insert(sortedinv,{k,v})
	end
	
	return sortedinv
end

local function sortedinv_has_material(inv,mat,count)
	local found = 0
	local materials = {}
	for k,v in ipairs(inv) do
		if itemname_matcher(mat)(v[1]) then
			found = found+v[2]
			materials[v[1]] = materials[v[1]] and materials[v[1]] + v[2] or v[2]
			
			if found >= count then
				--remove overallocated items from matials
				materials[v[1]]=materials[v[1]]-(found-count)
				
				return materials
			end
		end
	end

	
end

local function sortedinv_has_recipe(inv,recipe)
	local materials = {}
	for k,v in pairs(recipe) do
		local found_mats = sortedinv_has_material(inv,k,v)
		if found_mats then
			for k,v in pairs(found_mats) do
				materials[k] = found_mats[k]
			end
		else
			return false
		end
	end
	return materials
end


local function make_scrollbaroptions(scrollbar_l, scrollable_l)
	local max = scrollable_l - scrollbar_l
	return "scrollbaroptions[min=0;max=",max / 0.1,";thumbsize=",(scrollbar_l / scrollable_l) * max / 0.1,"]"
end
local function insert(t,...)
	for _,v in ipairs({...}) do
		table.insert(t,v)
	end
end
local left_container_width = 5
local left_container_height = 6
local right_container_width = 9.5-left_container_width
local right_container_height = 5.5
local function update_inventory(player)
	local state = player_state[player:get_player_name()]
	local form = {}
	
	
	local inv
	local shownitems=items
	
	if only_show_craftable_items or state.search then
		shownitems={}
		
		inv = sortinv(player:get_inventory():get_list("main"))
		for _,v in ipairs(items) do
			if not state.search or v.name:find(state.search) or core.get_translated_string(state.lang, v.description):lower():find(state.search) then
				local recipes = core.get_all_craft_recipes(v.name)
				for _,r in ipairs(recipes) do
					if sortedinv_has_recipe(inv,simplerecipe(r.items)) and r.method == "normal" then
						table.insert(shownitems,v)
						break
					end
				end
			end
		end
	end
	
	local length_left_inv = (math.floor((#shownitems-1)/left_container_width)+1)+0.5
	
	table.insert(form,"size[5,5]real_coordinates[true]style[*;noclip=false]")
	insert(form,"scroll_container[0,0;",left_container_width,",",left_container_height,";scrollbar_craftables;vertical;0.1]")
	for k,v in ipairs(shownitems) do
		insert(form,"item_image_button[", (k-1)%left_container_width, ",", math.floor((k-1)/left_container_width), ";1,1;", v.name, ";page_", v.name, ";]")
	end
	table.insert(form,"scroll_container_end[]")
	
	if tonumber(state.scrollpos_craftables) > length_left_inv/0.1 then state.scrollpos_craftables = length_left_inv/0.1 end
	insert(form,make_scrollbaroptions(left_container_height,length_left_inv))
	insert(form,"scrollbar[",left_container_width,",0;0.5,",left_container_height,";vertical;scrollbar_craftables;",state.scrollpos_craftables,"]")
	
	if state.page then
		local l = 0 --line for layout
		insert(form,"scroll_container[",(left_container_width+0.5),",0;",right_container_width,",",right_container_height,";scrollbar_recipes;vertical;0.1]")
		local recipes = core.get_all_craft_recipes(state.page)
		
		for i,v in ipairs(recipes) do
			local r = simplerecipe(v.items)
			if ( not only_show_craftable_items or sortedinv_has_recipe(inv,r) ) and (v.method == "normal") then
				local j = 1
				local function checkwrap()
					if j>4 then
						j=1
						l=l+1
					end
				end
				for k,w in pairs(r) do
					local g = is_group(k)
					insert(form,"item_image_button[", j-1, ",", l, ";1,1;",core.formspec_escape(g and first_registered_item_of_group(k) or k)," ",w,";ignore_", k, g and ";G" or ";","]")
					j=j+1
					checkwrap()
				end
				
				j=1
				l=l+1
				
				insert(form,"image[", j-1 ,",", l ,";1,1;simple_crafting_arrow.png;]")
				j=j+1
				
				insert(form,"item_image_button[", j-1 ,",", l ,";1,1;", core.formspec_escape(v.output) ,";ignore_",v.output,";]")
				j=j+1
				insert(form,"image_button[", j-1+0.5 ,",", l ,";1,1;simple_crafting_craft.png;craftbtn_", i ,";]")
				insert(form,"tooltip[craftbtn_", i ,";",S("Craft"),"]")
				j=j+1
				insert(form,"image_button[", j-1+0.5 ,",", l ,";1,1;simple_crafting_craft10.png;craftbtn10_", i ,";]")
				l=l+1.2
			end
		end
	
		table.insert(form,"scroll_container_end[]")
		
		insert(form,make_scrollbaroptions(right_container_height,l+1))
		insert(form,"scrollbar[",(left_container_width+0.5+right_container_width),",0;0.5,",right_container_height,";vertical;scrollbar_recipes;",state.scrollpos_recipes,"]")
	end
	insert(form,"field[",(left_container_width+0.5),",",right_container_height,";",right_container_width,",",left_container_height-right_container_height,";sr_search;;]field_close_on_enter[sr_search;false]")
	insert(form,"image_button[",(left_container_width+0.5+right_container_width),",",right_container_height,";0.5,",left_container_height-right_container_height,";simple_crafting_search.png;sr_searchbtn;]")
	insert(form,"tooltip[sr_searchbtn;",S("Search"),"]")
	
	if mod_sfinv then
		local S = core.get_translator("sfinv")
		sfinv.override_page("sfinv:crafting", {title = S("Crafting"),
			get = function(self, player, context)
				return sfinv.make_formspec(player, context,table.concat(form,""), true)
			end
		})
		if player then
			sfinv.set_player_inventory_formspec(player)
		end
	else
	
	end
end

core.register_on_mods_loaded(function()
	
	local i=0
	for k,v in pairs(core.registered_items) do
		local r = core.get_all_craft_recipes(v.name)
		if r and #r ~= 0 then
			local is_normal_crafting
			for k,v in pairs(r) do
				if v.method == "normal" then is_normal_crafting=true end
			end
			if is_normal_crafting then
				i=i+1
				table.insert(items,v)
			end
		end
	end
end)

core.register_on_joinplayer(function(player)
	local state = table.copy(state_template)
	local name = player:get_player_name()
	state.lang = core.get_player_information(name).lang_code
	player_state[name] = state
	update_inventory(player)
end)
core.register_on_leaveplayer(function(player)
	player_state[player:get_player_name()] = nil
end)

local function player_craft_recipe(player,recipe_id)
	local inv = player:get_inventory()
	local state = player_state[player:get_player_name()]
	local recipe = core.get_all_craft_recipes(state.page)[recipe_id]
	
	local craftresult = recipe.output
	local ingredients = simplerecipe(recipe.items)
	
	if recipe.method ~= "normal" then return true end
	
	if not inv:room_for_item("main",craftresult) then
		core.chat_send_player(player:get_player_name(), S("Your pockets are full."))
		return true
	end
	
	local found_ingredients = sortedinv_has_recipe(sortinv(inv:get_list("main")),ingredients)
	
	if found_ingredients then
		for k,v in pairs(found_ingredients) do
			inv:remove_item("main",k.." "..v)
		end
		
	else
		core.chat_send_player(player:get_player_name(), S("You're lacking materials."))
		return true
	end
	
	inv:add_item("main",craftresult)
	
	local _,d=core.get_craft_result(recipe)
	if d.method == "normal" then
		local items = d.items
		for i=1,9 do
			--usually unstackable like a filled bucket, so there should be enough room
			core.spawn_item(player:get_pos(),inv:add_item("main",items[i]))
		end
	end
end

core.register_on_player_receive_fields(function(player, formname, fields)
	if formname ~= "" then
		return
	end
	local state = player_state[player:get_player_name()]
	for k,_ in pairs(fields) do
		if k:find("^craftbtn") then
			k=k:split("_")
			if k[1]=="craftbtn" then
				player_craft_recipe(player,tonumber(k[2]))
				update_inventory(player)
				return
			elseif k[1]=="craftbtn10" then
				for i=1,10 do
					if player_craft_recipe(player,tonumber(k[2])) then break end
				end
				update_inventory(player)
				return
			end
		end
		if k:find("^page_") then
			k=k:gsub("^page_","")
			state.page = k
			update_inventory(player)
			return
		end
	end
	if fields.scrollbar_craftables then
		state.scrollpos_craftables=fields.scrollbar_craftables:split(":")[2]
	end
	if fields.scrollbar_recipes then
		state.scrollpos_recipes=fields.scrollbar_recipes:split(":")[2]
	end
	if fields.quit then
		state.allow_update = true
		update_inventory(player)
	else
		state.allow_update = false
	end
	
	if fields.sr_search or fields.sr_searchbtn then
		if fields.sr_search == "" then
			fields.sr_search = nil
		else
			fields.sr_search = fields.sr_search:lower()
		end
		if fields.sr_search ~= state.search then
			state.search = fields.sr_search
			update_inventory(player)
			return
		end
	end
end)

local t=math.random()
core.register_globalstep(function(dtime)
	if only_show_craftable_items then
		if t > 1 then
			for _,v in ipairs(core.get_connected_players()) do
				if player_state[v:get_player_name()].allow_update then update_inventory(v) end
			end
			t=t-1
		end
		t=t+dtime
	end
end)