local S = core.get_translator("target")

local function get_entity(pos)
	local objects = core.get_objects_inside_radius(pos, 0.5)
	local found
	for _, obj in ipairs(objects) do
		if obj and obj:get_luaentity() and obj:get_luaentity().name == "target:entity" then
			found = obj
			break
		end
	end
	return found
end

core.register_node("target:node", {
	description = S("Target"),
	tiles = {"wool_white.png^target_node.png"},
	groups = {oddly_breakable_by_hand = 1},
	walkable = false,
	on_destruct = function(pos)
		local o = get_entity(pos)
		if o then o:remove() end
	end,
	on_construct = function(pos)
		core.add_entity(pos, "target:entity")
	end,
	
	mesecon = {receptor = {
		state = mesecon.state.off,
		rules = mesecon.rules.alldirs,
		},
	},

	on_timer = function(pos, elapsed)
		mesecon.receptor_off(pos, mesecon.rules.alldirs)
		return false
	end,
})

core.register_entity("target:entity", {
	initial_properties = {
		hp_max = 1000000,
		physical = true,
		visual_size = vector.new(0,0,0),
		collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
		selectionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},--{0, 0, 0, 0, 0, 0},
		mesecon = {mvps_unmov = true}
	},
	_hittable_by_projectile = true, --mcl compatibility

	on_activate = function(self, staticdata, dtime_s)
		if core.get_node(self.object:get_pos()).name ~= "target:node" then
			self.object:remove()
		end
	end,

	on_punch = function(self, puncher, time_from_last_punch, tool_capabilities, dir)
		if puncher then
			local pos = self.object:get_pos()
			
			if core.get_node(pos).name == "target:node" then
				core.get_node_timer(pos):start(0.5)
				mesecon.receptor_on(pos, mesecon.rules.alldirs)
			end
		end
		self.object:set_hp(1000000)
	end,
	
	on_rightclick = function(self, clicker)
		if clicker and clicker:is_player() and not clicker:get_wielded_item():is_empty() then
			return
		end
			core.dig_node(self.object:get_pos(),clicker)
			self.object:remove()
	end,
	
	
	on_death = function(self)
		local pos = self.object:get_pos()
		core.add_entity(pos, "target:entity")
	end,
})
if core.get_modpath("mesecons_mvps") then
	mesecon.register_mvps_unmov("target:entity")
end
core.register_craft({
    output = "target:node",
    recipe = {
        {"",           "mesecons:mesecon", ""},
        {"mesecons:mesecon", "group:wool", "mesecons:mesecon"},
        {"",           "mesecons:mesecon", ""}
    }
})
