local resistor_box = {fixed = {{(-3 / 16), (-1 / 2), (-1 / 2), (3 / 16), ((-1 / 2) + (6 / 16)), (1 / 2)}}, type = "fixed"}
local capacitor_box = {fixed = {{(-3 / 16), (-1 / 2), (-1 / 2), (3 / 16), (1 / 2), (1 / 2)}}, type = "fixed"}
local function register_consumer(conf)
  local name = string.format("electricity:%s_%s", conf["elem-name"], conf.idx)
  minetest.register_node(name, {description = string.format("%s (%s)", capitalization(conf["elem-name"]), conf.desc), drawtype = "nodebox", groups = {conductor = 1, crumbly = 3}, node_box = conf.box, on_destruct = reset_current, paramtype = "light", paramtype2 = "facedir", selection_box = conf.box, tiles = {string.format("%s^[colorize:%sf0", conf.tiles["top-bottom"], conf.color), string.format("%s^[colorize:%sf0", conf.tiles["top-bottom"], conf.color), string.format("%s^[colorize:%sf0", conf.tiles.side, conf.color), string.format("%s^[colorize:%sf0", conf.tiles.side, conf.color), string.format("%s^[colorize:%sf0", conf.tiles.connector, conf.color), string.format("%s^[colorize:%sf0", conf.tiles.connector, conf.color)}, use_texture_alpha = conf["use-texture-alpha"]})
  do end (model)[name] = consumer(conf.R, conf.X)
  return nil
end
local color_code = {{color = "#663333", desc = "10"}, {color = "#ff0000", desc = "100"}, {color = "#ff6600", desc = "1K"}, {color = "#ffff00", desc = "10K"}, {color = "#33cc33", desc = "100K"}, {color = "#6666ff", desc = "1M"}, {color = "#cc66ff", desc = "10M"}, [-1] = {color = "#baa932", desc = "0.1"}, [-2] = {color = "#cccccc", desc = "0.01"}, [0] = {color = "#3684ff", desc = "1"}}
for exp_power, conf in pairs(color_code) do
  local idx = (exp_power + 2)
  register_consumer({R = math.pow(10, exp_power), ["elem-name"] = "resistor", ["use-texture-alpha"] = "blend", box = resistor_box, color = conf.color, desc = string.format("%s Ohm", conf.desc), idx = idx, tiles = {["top-bottom"] = "electricity_resistor.png", connector = "electricity_resistor_connect_side.png", side = "electricity_resistor_side.png"}})
  register_consumer({X = math.pow(10, (exp_power - 9)), ["elem-name"] = "capacitor", ["use-texture-alpha"] = "blend", box = capacitor_box, color = conf.color, desc = string.format("%s nF", conf.desc), idx = idx, tiles = {["top-bottom"] = "electricity_capacitor.png", connector = "electricity_capacitor_connect_side.png", side = "electricity_capacitor_side.png"}})
end
local heavy_inductance = 1
local heavy_inductor_box
do
  local _ce_b1 = ((-1 / 2) + (2 / 16))
  local _ce_b2 = ((1 / 2) - (2 / 16))
  heavy_inductor_box = {fixed = {{(-1 / 2), (-1 / 2), (-1 / 2), (1 / 2), _ce_b1, (1 / 2)}, {(-1 / 2), _ce_b2, (-1 / 2), (1 / 2), (1 / 2), (1 / 2)}, {_ce_b1, _ce_b1, _ce_b1, _ce_b2, _ce_b2, _ce_b2}}, type = "fixed"}
end
minetest.register_node("electricity:heavy_inductor", {description = "Heavy inductor (1 H)", drawtype = "nodebox", groups = {conductor = 1, crumbly = 3}, node_box = heavy_inductor_box, on_destruct = reset_current, paramtype = "light", paramtype2 = "facedir", selection_box = heavy_inductor_box, tiles = {"electricity_heavy_inductor_top_bottom.png", "electricity_heavy_inductor_top_bottom.png", "electricity_heavy_inductor.png", "electricity_heavy_inductor.png", "electricity_heavy_inductor_connect_side.png", "electricity_heavy_inductor_connect_side.png"}, use_texture_alpha = "blend"})
do end (model)["electricity:heavy_inductor"] = consumer(0, 1)
return nil
