local refiner_box = {fixed = {{(-1 / 2), (-1 / 2), (-1 / 2), (1 / 2), (1 / 2), (3 / 2)}}, type = "fixed"}
minetest.register_node("furnace:barrier", {description = "Barrier", drawtype = "airlike", groups = {not_in_creative_inventory = 1}, paramtype = "light", paramtype2 = "facedir", pointable = false})
local gases_list = {["loria:oxygen_balloon"] = (balloon_coeff * 3)}
local function furnace_ready_3f(pos)
  local meta = minetest.get_meta(pos)
  local inv = meta:get_inventory()
  local gas = ((inv:get_list("gas"))[1]):get_name()
  local fuel = ((inv:get_list("fuel"))[1]):get_name()
  return (gases_list[gas] and fuel_list[fuel] and (meta:get_int("switch") == 1))
end
local function reset_sound(pos)
  minetest.sound_stop(minetest.get_meta(pos):get_int("sound"))
  return minetest.get_meta(pos):set_int("sound", minetest.sound_play("refiner", {pos = pos}))
end
local conf
local function _1_(meta)
  return ("label[0,1.5;Gas]" .. "list[context;gas;0,2;1,1;]" .. "label[2,1.5;Fuel]" .. "list[context;fuel;2,2;1,1;]" .. "button[7,3;1,1;switch;On/off]")
end
local function _2_(pos)
  minetest.get_meta(pos):set_int("switch", 0)
  return minetest.sound_stop(minetest.get_meta(pos):get_int("sount"))
end
local function _3_(pos)
  local node = minetest.get_node(pos)
  local back = vector.add(pos, minetest.facedir_to_dir(node.param2))
  local node_e2_80_b2 = minetest.get_node(back)
  if ((minetest.get_node(back).name == "furnace:barrier") and (node.param2 == node_e2_80_b2.param2)) then
    return minetest.set_node(back, {name = "air"})
  end
end
conf = {additional_formspec = _1_, after_stop = _2_, collision_box = refiner_box, crafts = refiner_crafts, description = "Refiner", drawtype = "mesh", drop = "furnace:refiner_item", groups = {cracky = 2, not_in_creative_inventory = 1}, is_furnace_ready = furnace_ready_3f, lists = {fuel = 1, gas = 1}, mesh = "doubled.obj", name = "refiner", on_destruct = _3_, on_tick = {update_fuel(fuel_list), update_gas, andthen(reset_sound, const(true))}, paramtype = "light", selection_box = refiner_box, textures = {active = {{animation = {aspect_h = 64, aspect_w = 64, length = 1.5, type = "vertical_frames"}, backface_culling = false, image = "furnace_refiner_active.png"}}, inactive = {"furnace_refiner.png"}}, use_texture_alpha = "blend"}
conf.on_receive_fields = function(pos, formname, fields, sender)
  if fields.switch then
    local meta = minetest.get_meta(pos)
    local active = meta:get_int("switch")
    if (active == 1) then
      meta:set_int("switch", 0)
      return check_and_stop_furnace(conf, pos)
    else
      meta:set_int("switch", 1)
      return check_and_run_furnace(conf, pos)
    end
  end
end
register_furnace(conf)
local rolled_refiner_box = {fixed = {{(-7 / 16), (-1 / 2), (-7 / 16), (7 / 16), (6 / 16), (7 / 16)}}, type = "fixed"}
local function buildable_3f(pos)
  local name = minetest.get_node(pos).name
  return (minetest.registered_nodes[name].buildable_to or (name == "furnace:refiner_item"))
end
local function _7_(pos)
  return minetest.get_meta(pos):set_string("infotext", "Right click to unroll")
end
local function _8_(pos, node, clicker, itemstack, pointed_thing)
  if (pointed_thing and (pointed_thing.type == "node")) then
    do
      local param2 = minetest.dir_to_facedir(clicker:get_look_dir())
      local dir = minetest.facedir_to_dir(param2)
      local back = vector.add(pos, dir)
      if (buildable_3f(pos) and buildable_3f(back)) then
        minetest.set_node(pos, {name = "furnace:refiner", param2 = param2})
        minetest.set_node(back, {name = "furnace:barrier", param2 = param2})
      end
    end
    return {}
  end
end
return minetest.register_node("furnace:refiner_item", {description = "Refiner (rolled)", drawtype = "nodebox", groups = {cracky = 2}, node_box = rolled_refiner_box, on_construct = _7_, on_rightclick = _8_, paramtype = "light", selection_box = rolled_refiner_box, tiles = {"furnace_rolled_refiner_top.png", "furnace_rolled_refiner_top.png", "furnace_rolled_refiner.png", "furnace_rolled_refiner.png", "furnace_rolled_refiner.png", "furnace_rolled_refiner.png"}, use_texture_alpha = "blend"})
