local gases_list = {["loria:oxygen_balloon"] = (balloon_coeff * 3)}
local function furnace_ready_3f(pos)
  local meta = minetest.get_meta(pos)
  local inv = meta:get_inventory()
  local gas = ((inv:get_list("gas"))[1]):get_name()
  local fuel = ((inv:get_list("fuel"))[1]):get_name()
  return (gases_list[gas] and fuel_list[fuel])
end
local function _1_(pos, elapsed)
  local meta = minetest.get_meta(pos)
  local inv = meta:get_inventory()
  local gas = (inv:get_list("gas"))[1]
  local _ce_94wear = gases_list[gas:get_name()]
  local wear = (gas:get_wear() + _ce_94wear)
  if (wear >= 65535) then
    inv:set_stack("gas", 1, {name = "loria:empty_balloon"})
    return false
  else
    gas:set_wear(wear)
    inv:set_stack("gas", 1, gas)
    return true
  end
end
update_gas = _1_
local function process_liquid_fuel(pos, meta, inv, fuel, burning_time, elapsed)
  local wear = fuel:get_wear()
  local _ce_94wear = ((elapsed / burning_time) * 65535)
  if ((wear + _ce_94wear) >= 65535) then
    add_or_drop(inv, "output", {name = "loria:bucket_empty"}, above(pos))
    inv:set_list("fuel", {})
    return false
  else
    fuel:add_wear(_ce_94wear)
    inv:set_stack("fuel", 1, fuel)
    meta:set_float("cycle", ((1 - (wear / 65535)) * burning_time))
    return true
  end
end
local function process_solid_fuel(pos, meta, inv, fuel, burning_time, elapsed)
  local cycle = (meta:get_float("cycle") + elapsed)
  if (cycle > burning_time) then
    local count = (fuel:get_count() - 1)
    fuel:set_count(count)
    inv:set_stack("fuel", 1, fuel)
    if (count == 0) then
      return false
    else
      meta:set_float("cycle", 0)
      return true
    end
  else
    meta:set_float("cycle", cycle)
    return true
  end
end
local function _6_(fuel_list)
  local function _7_(pos, elapsed)
    local meta = minetest.get_meta(pos)
    local inv = meta:get_inventory()
    local fuel = (inv:get_list("fuel"))[1]
    local fuel_name = fuel:get_name()
    local burning_time = fuel_list[fuel_name]
    local handler
    if bucket.is_bucket[fuel_name] then
      handler = process_liquid_fuel
    else
      handler = process_solid_fuel
    end
    return handler(pos, meta, inv, fuel, burning_time, elapsed)
  end
  return _7_
end
update_fuel = _6_
local function gas_furnace_formspec(meta)
  return ("label[0,1.5;Gas]" .. "list[context;gas;0,2;1,1;]" .. "label[2,1.5;Fuel]" .. "list[context;fuel;2,2;1,1;]")
end
local function register_gas_furnace(name, desc, crafts)
  local furnace_side = ("furnace_" .. name .. "_side.png")
  local furnace_front = ("furnace_" .. name .. "_front.png")
  local furnace_front_active = ("furnace_" .. name .. "_front_active.png")
  local function _9_(pos)
    return minetest.get_meta(pos):set_float("cycle", 0)
  end
  return register_furnace({additional_formspec = gas_furnace_formspec, after_stop = _9_, crafts = crafts, description = desc, groups = {cracky = 2}, is_furnace_ready = furnace_ready_3f, light_source = 10, lists = {fuel = 1, gas = 1}, name = name, on_tick = {update_fuel(fuel_list), update_gas}, textures = {active = {furnace_side, furnace_side, furnace_side, furnace_side, furnace_side, {animation = {aspect_h = 16, aspect_w = 16, length = 1.5, type = "vertical_frames"}, backface_culling = false, image = furnace_front_active}}, inactive = {furnace_side, furnace_side, furnace_side, furnace_side, furnace_side, furnace_front}}})
end
register_gas_furnace("gas", "Gas furnace (PbSe)", furnace_crafts)
return register_gas_furnace("thorium", "Gas furnace (ThO2)", high_temperature_furnace_crafts)
