complex = {}
local function number_3f(x)
  return (type(x) == "number")
end
local function complex_3f(z)
  if fallback then
    return (getmetatable(z) == complex)
  else
    return isctype(complex["\207\132"], z)
  end
end
if not fallback then
  complex["\207\132"] = metatype("complex", complex)
end
local function _3_(cls, x, y)
  if fallback then
    local z = {y, [0] = x, im = y, re = x}
    setmetatable(z, complex)
    return z
  else
    return complex["\207\132"](x, y)
  end
end
setmetatable(complex, {__call = _3_})
complex.both = function(z)
  if number_3f(z) then
    return z, 0
  elseif complex_3f(z) then
    return z[0], z[1]
  else
    return error("expected number/complex")
  end
end
complex.__add = function(z_e2_82_81, z_e2_82_82)
  local a, b = complex.both(z_e2_82_81)
  local c, d = complex.both(z_e2_82_82)
  return complex((a + c), (b + d))
end
complex.__sub = function(z_e2_82_81, z_e2_82_82)
  local a, b = complex.both(z_e2_82_81)
  local c, d = complex.both(z_e2_82_82)
  return complex((a - c), (b - d))
end
complex.__mul = function(z_e2_82_81, z_e2_82_82)
  local a, b = complex.both(z_e2_82_81)
  local c, d = complex.both(z_e2_82_82)
  return complex(((a * c) - (b * d)), ((b * c) + (a * d)))
end
complex.__div = function(z_e2_82_81, z_e2_82_82)
  local a, b = complex.both(z_e2_82_81)
  local c, d = complex.both(z_e2_82_82)
  local den = ((c ^ 2) + (d ^ 2))
  return complex((((a * c) + (b * d)) / den), (((b * c) - (a * d)) / den))
end
complex.__unm = function(z)
  local a, b = complex.both(z)
  return complex(( - a), ( - b))
end
complex.__eq = function(z_e2_82_81, z_e2_82_82)
  local a, b = complex.both(z_e2_82_81)
  local c, d = complex.both(z_e2_82_82)
  return ((a == c) and (b == d))
end
complex.__pow = function(z, n)
  local _7cz_7c = complex.abs(z)
  local _7cz_7c_e2_81_bf = (_7cz_7c ^ n)
  local _cf_86 = complex.arg(z)
  return complex((_7cz_7c_e2_81_bf * math.cos((n * _cf_86))), (_7cz_7c_e2_81_bf * math.sin((n * _cf_86))))
end
complex.inv = function(z)
  return (1 / z)
end
complex.conj = function(z)
  return complex(z.re, ( - z.im))
end
complex.arg = function(z)
  return math.atan2(z.im, z.re)
end
complex.abs = function(z)
  return math.sqrt(((z.re ^ 2) + (z.im ^ 2)))
end
local function angular_freq(T)
  return ((2 * math.pi) / T)
end
local _cf_89 = angular_freq(50)
local function _6_(R)
  return complex(R, 0)
end
real = _6_
local function _7_(L)
  return complex(0, (_cf_89 * L))
end
inductance = _7_
local function _8_(C)
  return complex(0, (( - 1) / (_cf_89 * C)))
end
capacitance = _8_
return nil
