loria = {}
dofile((minetest.get_modpath("loria") .. "/" .. "basic.lua"))
dofile((minetest.get_modpath("loria") .. "/" .. "prelude.lua"))
import("loria", "greet", "conf", "inv_crafts", "creative", "tint", "biomes", "ores", "mushrooms_nodes", "small_mushrooms", "mapgen", "liquids", "nodes", "gases_arch", "gases", "items", "craft", "mushrooms", "hud", "sky", "player", "compatibility", "pickaxe", "radio", "mold")
local start_items_default = ("furnace:refiner_item 1,loria:oxygen_balloon 1," .. "loria:empty_balloon 1,loria:bucket_empty 2," .. "loria:silicon_box 1,radiation:sign 15")
local start_items = {}
do
  local words = ((minetest.settings):get("start_items") or start_items_default)
  for word in string.gmatch(words, "([^,]+)") do
    table.insert(start_items, ItemStack(word))
  end
end
local max_height = 31000
local space_suit_strength = 20
player_api.register_model("player.b3d", {animation_speed = 30, animations = {lay = {x = 162, y = 166}, mine = {x = 189, y = 198}, sit = {x = 81, y = 160}, stand = {x = 0, y = 79}, walk = {x = 168, y = 187}, walk_mine = {x = 200, y = 219}}, collisionbox = {-0.3, 0, -0.3, 0.3, 1.7, 0.3}, eye_height = 1.47, stepheight = 0.6})
oxygen_hud = {}
local function _1_(player)
  local name = player:get_player_name()
  player:hud_set_flags({healthbar = false})
  do end (oxygen_hud)[name] = player:hud_add({alignment = "right", hud_elem_type = "text", number = 16777215, offset = {x = 150, y = 0}, position = {x = 0, y = 0.9}, text = "N/A"})
  player:set_clouds({density = 0})
  do end (loria)["enough-fresh?"] = (player.set_sun and player.set_moon and player.set_stars)
  if loria["enough-fresh?"] then
    player:set_sun({scale = 0.5, sunrise_visible = false, texture = "star.png"})
    player:set_moon({scale = 7, texture = "gas_giant.png"})
    player:set_stars({scale = 0.5, star_color = "#ffffffff"})
  end
  player_api.set_model(player, "player.b3d")
  player:set_local_animation({x = 0, y = 79}, {x = 168, y = 187}, {x = 189, y = 198}, {x = 200, y = 219}, 30)
  return minetest.chat_send_player(name, "Welcome to Loria!")
end
minetest.register_on_joinplayer(_1_)
local function _3_(player, hp_change, reason)
  local meta = player:get_meta()
  local space_suit = meta:get_int("space_suit")
  if (reason.type == "set_hp") then
    return hp_change
  elseif (space_suit > 0) then
    if (reason.type ~= "node_damage") then
      local new = (space_suit + math.floor((hp_change / 2)))
      if (new > 0) then
        meta:set_int("space_suit", new)
      else
        meta:set_int("space_suit", 0)
      end
    end
    return 0
  else
    return hp_change
  end
end
minetest.register_on_player_hpchange(_3_, true)
local function init_inv(player)
  local name = player:get_player_name()
  local inv = player:get_inventory()
  inv:set_size("oxygen", 1)
  inv:set_size("antiradiation", 1)
  inv:set_size("input", 9)
  inv:set_size("output", 9)
  inv:add_item("main", {count = 1, name = "loria:drill"})
  inv:add_item("oxygen", {name = "loria:oxygen_balloon"})
  local pos = player:get_pos()
  for index, stack in ipairs(start_items) do
    add_or_drop(inv, "main", stack, pos)
  end
  return nil
end
local function _7_(player)
  init_inv(player)
  local meta = player:get_meta()
  meta:set_int("oxygen", 0)
  meta:set_float("radiation", 0)
  meta:set_float("received_dose", 0)
  meta:set_float("dose_damage_limit", 1)
  return meta:set_int("space_suit", space_suit_strength)
end
minetest.register_on_newplayer(_7_)
local function _8_(player)
  local meta = player:get_meta()
  player:set_hp(20)
  meta:set_float("received_dose", 0)
  meta:set_float("dose_damage_limit", 1)
  return meta:set_int("space_suit", space_suit_strength)
end
minetest.register_on_respawnplayer(_8_)
local function _9_(_)
  for _0, player in ipairs(minetest.get_connected_players()) do
    local pos = player:get_pos()
    if (pos.y ~= ( - max_height)) then
      local h = player:get_pos().y
      local gravity = ((max_height / (h + max_height)) ^ 2)
      player:set_physics_override({gravity = gravity})
    else
      player:set_physics_override({gravity = 1})
    end
  end
  return nil
end
minetest.register_globalstep(_9_)
local clear_radius = 500
local function _11_(name)
  local player = minetest.get_player_by_name(name)
  if player then
    local pos = player:get_pos()
    local name0 = player:get_player_name()
    local objs = minetest.get_objects_inside_radius(pos, clear_radius)
    for _, obj in pairs(objs) do
      local entity = obj:get_luaentity()
      if (entity and (entity.name == "__builtin:item")) then
        obj:remove()
      end
    end
    return nil
  end
end
minetest.register_chatcommand("clearitems", {description = ("Deletes all items in " .. clear_radius .. " meters"), func = _11_, params = "", privs = {}})
minetest.register_privilege("kill", {description = "Allow to use \226\128\156/kill\226\128\157 command"})
local function _14_(name_e2_82_81, name_e2_82_82)
  local name
  if (name_e2_82_81 ~= "") then
    name = name_e2_82_81
  else
    name = name_e2_82_82
  end
  local player = minetest.get_player_by_name(name)
  if player then
    return player:set_hp(0)
  end
end
return minetest.register_chatcommand("kill", {description = "Kills player", func = _14_, params = "[name]", privs = {kill = true}})
