minetest.register_tool("electricity:accumulator", {description = "Accumulator", groups = {item_source = 4, rechargeable = 1}, inventory_image = "electricity_accumulator.png"})
local charger_box_resis = 0.1
local charge_speed = 500
local voltage_delta = 4
local charger_formspec = ("size[8,6.5]" .. "label[3.5,0;Charger box]" .. "list[context;place;3.5,0.5;1,1;]" .. "list[current_player;main;0,2;8,1;]" .. "list[current_player;main;0,3.5;8,3;8]")
local function _1_(pos, listname, index, stack, player)
  local inv = minetest.get_meta(pos):get_inventory()
  if (inv:get_stack(listname, index):get_count() == 1) then
    return 0
  else
    return 1
  end
end
local function _3_(pos)
  local meta = minetest.get_meta(pos)
  local inv = meta:get_inventory()
  inv:set_size("place", 1)
  meta:set_string("formspec", charger_formspec)
  return minetest.get_node_timer(pos):start(0.5)
end
local function _4_(pos, elapsed)
  do
    local meta = minetest.get_meta(pos)
    local inv = meta:get_inventory()
    local stack = inv:get_stack("place", 1)
    local name = stack:get_name()
    local emf = minetest.get_item_group(name, "item_source")
    if ((minetest.get_item_group(name, "rechargeable") > 0) and (emf > 0)) then
      local I = meta:get_float("I")
      local U = meta:get_float("U")
      local wear = stack:get_wear()
      local _ce_94wear = (charge_speed * I * (U / emf) * elapsed)
      if (math.abs((U - emf)) <= voltage_delta) then
        if (wear > _ce_94wear) then
          stack:set_wear((wear - _ce_94wear))
        elseif (wear >= 65536) then
          stack:set_wear(65536)
        elseif (wear <= _ce_94wear) then
          stack:set_wear(0)
        else
          nope()
        end
        inv:set_stack("place", 1, stack)
      end
    end
  end
  return true
end
minetest.register_node("electricity:charger_box", {allow_metadata_inventory_put = _1_, description = "Charger box", groups = {conductor = 1, cracky = 3}, on_construct = _3_, on_destruct = andthen(reset_current, drop_everything), on_timer = _4_, paramtype2 = "facedir", tiles = {"electricity_charger_box.png", "electricity_charger_box.png", "electricity_charger_box_side.png", "electricity_charger_box_side.png", "electricity_charger_box_connect_side.png", "electricity_charger_box_connect_side.png"}})
do end (model)["electricity:charger_box"] = consumer(charger_box_resis)
return nil
