import("radiation", "conf")
local radiation_vect = vector.new(16, 16, 16)
local radiation_effects_timeout = 1
local lethal_dose = 1500
local maximum_dose = 5
local height_coeff = (5 / 10000)
local function cosmic_rays(height)
  local res = null()
  if (height > 0) then
    res["X-ray"] = (height_coeff * height)
  end
  return res
end
local function get_activity(name)
  local function _2_()
    if minetest.registered_nodes[name] then
      return activity[minetest.get_content_id(name)]
    else
      return activity[name]
    end
  end
  return (_2_() or null())
end
local function hypot_sqr(pos_e2_82_81, pos_e2_82_82)
  return (((pos_e2_82_81.x - pos_e2_82_82.x) ^ 2) + ((pos_e2_82_81.y - pos_e2_82_82.y) ^ 2) + ((pos_e2_82_81.z - pos_e2_82_82.z) ^ 2))
end
local function radiation_summary(A, source, pos)
  local dist_c2_b2 = hypot_sqr(source, pos)
  local res = {}
  for kind, handler in pairs(ionizing) do
    res[kind] = handler(A[kind], dist_c2_b2)
  end
  return res
end
local function add(A_e2_82_81, A_e2_82_82)
  local res = {}
  for kind, _ in pairs(ionizing) do
    res[kind] = ((A_e2_82_81)[kind] + (A_e2_82_82)[kind])
  end
  return res
end
local function mult(k, A)
  local res = {}
  for kind, _ in pairs(ionizing) do
    res[kind] = (A[kind] * k)
  end
  return res
end
local function _3_(A)
  local res = 0
  for kind, _ in pairs(ionizing) do
    res = (res + A[kind])
  end
  return res
end
total = _3_
local function calculate_inventory_radiation(inv)
  local radiation = null()
  for listname, lst in pairs(inv:get_lists()) do
    if (listname ~= "creative_inv") then
      for _, stack in ipairs(lst) do
        local A = get_activity(stack:get_name())
        local stack_count = stack:get_count()
        for kind, _0 in pairs(ionizing) do
          if (kind ~= "alpha") then
            radiation[kind] = (radiation[kind] + (A[kind] * stack_count))
          end
        end
      end
    end
  end
  return radiation
end
local function _6_(vm, pos)
  local radiation = null()
  local minp, maxp = vm:read_from_map(vector.subtract(pos, radiation_vect), vector.add(pos, radiation_vect))
  local area = VoxelArea:new({MaxEdge = maxp, MinEdge = minp})
  local data = vm:get_data()
  for i = 1, #data do
    local cid = data[i]
    local A = activity[cid]
    if A then
      local source = vector.add(area:position(i), vector.new(0, (-1 / 2), 0))
      radiation = add(radiation, radiation_summary(A, pos, source))
    end
    if has_inventory[cid] then
      local source = area:position(i)
      local inv = minetest.get_meta(source):get_inventory()
      local A0 = calculate_inventory_radiation(inv)
      radiation = add(radiation, radiation_summary(A0, pos, vector.add(source, vector.new(0, (-1 / 2), 0))))
    end
  end
  radiation = add(cosmic_rays(pos.y), radiation)
  return radiation
end
calculate_radiation = _6_
local function calculate_player_radiation(player, vm)
  local pos = player:get_pos()
  local objs = minetest.get_objects_inside_radius(pos, vector.length(radiation_vect))
  local radiation = calculate_radiation(vm, pos)
  for _, obj in pairs(objs) do
    local name = player:get_player_name()
    local entity = obj:get_luaentity()
    if (entity and (entity.name == "__builtin:item")) then
      local stack = ItemStack(entity.itemstring)
      local A = get_activity(stack:get_name())
      radiation = add(radiation, mult(stack:get_count(), radiation_summary(A, pos, obj:get_pos())))
    end
  end
  do
    local wielded = player:get_wielded_item()
    do end (radiation)["alpha"] = (radiation.alpha + (get_activity(wielded:get_name()).alpha * wielded:get_count()))
    radiation = add(radiation, calculate_inventory_radiation(player:get_inventory()))
  end
  return radiation
end
local function reset_tint(player)
  return tint(player, transparent)
end
local effect_list
local function _10_(player)
  return tint(player, {a = 255, b = 0, g = 0, r = 0})
end
local function _11_(player)
  return tint(player, {a = 240, b = 0, g = 0, r = 0})
end
effect_list = {blindness = {["min-dose"] = 0.9, action = _10_, priority = {"semiblindness"}, prob = 0.05, revert = reset_tint}, semiblindness = {["min-dose"] = 0.85, action = _11_, conflicts = {"blindness"}, prob = 0.1, revert = reset_tint}}
local function applied_3f(meta, name)
  return (meta:get_int(name) > 0)
end
local function drop_effect(player, meta)
  local function _12_(name)
    local effect = effect_list[name]
    local revert = effect.revert
    meta:set_int(name, 0)
    return revert(player)
  end
  return _12_
end
local function _13_(player)
  return foreach2(drop_effect(player, player:get_meta()), effect_list)
end
minetest.register_on_respawnplayer(_13_)
local function _14_(player)
  local meta = player:get_meta()
  for name, effect in pairs(effect_list) do
    if applied_3f(meta, name) then
      effect.action(player)
    end
  end
  return nil
end
minetest.register_on_joinplayer(_14_)
local function radiation_effects(player, radiation)
  local meta = player:get_meta()
  local dose_e2_82_80 = meta:get_float("received_dose")
  local dose = (dose_e2_82_80 + (radiation_effects_timeout * (radiation / 3600)))
  if (dose < 0) then
    dose = 0
  end
  meta:set_float("received_dose", dose)
  local dose_damage_limit = meta:get_float("dose_damage_limit")
  if (dose > dose_damage_limit) then
    local inv = player:get_inventory()
    local drug_stack = (inv:get_list("antiradiation"))[1]
    local drug_value = antiradiation_drugs[drug_stack:get_name()]
    if (drug_value and (dose <= maximum_dose)) then
      meta:set_float("dose_damage_limit", (dose_damage_limit + drug_value))
      drug_stack:set_count((drug_stack:get_count() - 1))
      inv:set_stack("antiradiation", 1, drug_stack)
    else
      player:set_hp((player:get_hp() - math.floor(dose)))
    end
  end
  local meta0 = player:get_meta()
  for effect_name, effect in pairs(effect_list) do
    if ((dose >= effect["min-dose"]) and (math.random() <= effect.prob)) then
      local conflicts = (effect.conflicts or {})
      local priority = (effect.priority or {})
      local function _19_(x)
        return not applied_3f(meta0, x)
      end
      if (all(_19_, conflicts) and not applied_3f(meta0, effect_name)) then
        foreach(drop_effect(player, meta0), priority)
        meta0:set_int(effect_name, 1)
        effect.action(player)
      end
    end
  end
  return nil
end
local special_inventory = {"creative_inv", "oxygen"}
local function drop_inventory(player)
  local inv = player:get_inventory()
  local pos = player:get_pos()
  for listname, lst in pairs(inv:get_lists()) do
    if not contains(special_inventory, listname) then
      for _, stack in ipairs(lst) do
        minetest.add_item(pos, stack)
      end
      inv:set_list(listname, {})
    end
  end
  return nil
end
local radiation_timer = 0
local function _23_(_ce_94t)
  radiation_timer = (radiation_timer + _ce_94t)
  local vm = minetest.get_voxel_manip()
  for _, player in ipairs(minetest.get_connected_players()) do
    local meta = player:get_meta()
    local radiation_e2_82_80 = meta:get_float("radiation")
    local radiation = total(calculate_player_radiation(player, vm))
    local radiation_e2_80_b2 = ((radiation_e2_82_80 + radiation) / 2)
    meta:set_float("radiation", radiation_e2_80_b2)
    if (radiation_timer > radiation_effects_timeout) then
      if (radiation > lethal_dose) then
        drop_inventory(player)
        player:set_hp(0)
      end
      radiation_effects(player, radiation)
    end
  end
  if (radiation_timer > radiation_effects_timeout) then
    radiation_timer = 0
    return nil
  end
end
minetest.register_globalstep(_23_)
local function get_danger_texture(color)
  return string.format("radiation_danger.png^[multiply:%s", minetest.rgba(color.r, color.g, color.b))
end
local danger_texture = "radiation_danger.png"
minetest.register_node("radiation:danger", {description = "Radiation source", groups = {cracky = 1}, tiles = {get_danger_texture({b = 0, g = 0, r = 255})}})
local texture = get_danger_texture({b = 40, g = 191, r = 232})
return minetest.register_node("radiation:sign", {description = "Radiation hazard warning sign", drawtype = "nodebox", groups = {dig_immediate = 3}, inventory_image = texture, is_ground_content = false, node_box = {type = "wallmounted", wall_bottom = {-0.5, -0.5, -0.5, 0.5, -0.4375, 0.5}, wall_side = {-0.5, -0.5, -0.5, -0.4375, 0.5, 0.5}, wall_top = {-0.5, 0.4375, -0.5, 0.5, 0.5, 0.5}}, paramtype = "light", paramtype2 = "wallmounted", sunlight_propagates = true, tiles = {texture}, walkable = false, wield_image = texture})
