local function get_sparks_amount()
  return math.random(5, 15)
end
local function spawn_sparks(pos)
  return minetest.add_particlespawner({amount = get_sparks_amount(), collisiondetection = true, glow = 14, maxacc = {x = 0, y = -1, z = 0}, maxexptime = 3, maxpos = pos, maxsize = 0.3, maxvel = {x = 5, y = 5, z = 5}, minacc = {x = 0, y = -2, z = 0}, minexptime = 0.5, minpos = pos, minsize = 0.1, minvel = {x = -5, y = -5, z = -5}, texture = "electricity_spark.png", time = 0.2})
end
local function lamp_burn(burn_to)
  local function _1_(pos)
    swap_node(pos, burn_to)
    return spawn_sparks(pos)
  end
  return _1_
end
local function register_lamp(conf)
  local broken_name = ("electricity:" .. conf.name .. "_broken")
  local disabled_name = ("electricity:" .. conf.name .. "_off")
  local active_name = ("electricity:" .. conf.name .. "_on")
  local burn = lamp_burn(broken_name)
  minetest.register_node(broken_name, {description = (capitalization(conf.name) .. " (broken)"), groups = {cracky = 3}, paramtype2 = "facedir", tiles = conf["tiles-broken"]})
  minetest.register_node(disabled_name, {description = capitalization(conf.name), groups = {conductor = 1, cracky = 3}, on_destruct = reset_current, paramtype2 = "facedir", tiles = conf.tiles})
  minetest.register_node(active_name, {description = (capitalization(conf.name) .. " (active)"), drop = disabled_name, groups = {conductor = 1, cracky = 3}, light_source = conf["light-source"], on_destruct = reset_current, on_timer = reset_consumer(active_name), paramtype2 = "facedir", tiles = conf.tiles})
  local function _2_(pos)
    return swap_node(pos, active_name)
  end
  consumers[disabled_name] = {["I\226\130\152\226\130\144\226\130\147"] = conf["I\226\130\152\226\130\144\226\130\147"], ["P\226\130\152\225\181\162\226\130\153"] = conf["P\226\130\152\225\181\162\226\130\153"], burn = burn, on_activate = _2_}
  local function _3_(pos)
    return swap_node(pos, disabled_name)
  end
  consumers[active_name] = {["I\226\130\152\226\130\144\226\130\147"] = conf["I\226\130\152\226\130\144\226\130\147"], ["P\226\130\152\225\181\162\226\130\153"] = conf["P\226\130\152\225\181\162\226\130\153"], burn = burn, on_deactivate = _3_}
  model[disabled_name] = consumer(10, 0.1)
  do end (model)[active_name] = consumer(10, 0.1)
  return nil
end
return register_lamp({["I\226\130\152\226\130\144\226\130\147"] = 5, ["P\226\130\152\225\181\162\226\130\153"] = 50, ["light-source"] = 14, ["tiles-broken"] = {"electricity_lamp_broken.png", "electricity_lamp_broken.png", "electricity_lamp_broken.png", "electricity_lamp_broken.png", "electricity_lamp_broken_connect_side.png", "electricity_lamp_broken_connect_side.png"}, name = "lamp", tiles = {"electricity_lamp.png", "electricity_lamp.png", "electricity_lamp.png", "electricity_lamp.png", "electricity_lamp_connect_side.png", "electricity_lamp_connect_side.png"}})
