local function get_number(src, patt)
  return tonumber(string.match(src, patt))
end
local function get_spawnpoint(player, name)
  local meta = player:get_meta()
  return minetest.string_to_pos(meta:get_string("spawnpoint"))
end
local function teleport_to_spawnpoint(name)
  local player = minetest.get_player_by_name(name)
  if player then
    local pos = get_spawnpoint(player, name)
    if pos then
      return player:setpos(pos)
    else
      return minetest.chat_send_player(name, "You do not have a spawnpoint.")
    end
  end
end
local function set_spawnpoint(name)
  local player = minetest.get_player_by_name(name)
  if player then
    local meta = player:get_meta()
    local pos = player:get_pos()
    local spawnpoint = minetest.pos_to_string(pos)
    meta:set_string("spawnpoint", spawnpoint)
    return minetest.chat_send_player(name, string.format("%s\226\128\153s spawnpaint was set to %s", name, spawnpoint))
  end
end
minetest.register_chatcommand("setspawnpoint", {description = "Sets spawnpoint.", func = set_spawnpoint, params = "", privs = {creative = true}})
return minetest.register_chatcommand("tpspawnpoint", {description = "Teleports to spawnpoint.", func = teleport_to_spawnpoint, params = "", privs = {creative = true}})
