local no_top_neighbors = {vector.new(1, 0, 0), vector.new(-1, 0, 0), vector.new(0, -1, 0), vector.new(0, 0, 1), vector.new(0, 0, -1)}
local function get_neighbors(pos, heavy)
  local add_pos = nil
  local function _0_(...)
    return vector.add(pos, ...)
  end
  add_pos = _0_
  local function _1_()
    if heavy then
      return no_top_neighbors
    else
      return neighbors
    end
  end
  return map(add_pos, _1_())
end
local heavy_3f = {}
local function _0_(name)
  return ((minetest.get_item_group(name, "gas") > 0) and minetest.registered_nodes[name].description)
end
detect_gas = _0_
local function process_gas(gas, pos)
  local node = minetest.get_node(pos)
  local accepted = {pos}
  for _, v in ipairs(get_neighbors(pos, heavy_3f[gas.name])) do
    local neighbor = minetest.get_node(v)
    local reaction = gas.reactions[neighbor.name]
    if (reaction ~= nil) then
      minetest.swap_node(v, {name = reaction.result, param1 = neighbor.param1, param2 = neighbor.param2})
      if reaction.gas then
        minetest.swap_node(pos, {name = reaction.gas, param1 = node.param1, param2 = node.param2})
      else
        minetest.set_node(pos, {name = "air"})
      end
    elseif ((neighbor.name == node.name) or (neighbor.name == "air") or gas.destroys(neighbor.name)) then
      table.insert(accepted, v)
    elseif _ then
      nope()
    end
  end
  node["param2"] = (node.param2 - #accepted - -1)
  if (node.param2 >= 128) then
    for _, v in ipairs(accepted) do
      minetest.swap_node(v, node)
    end
    return nil
  else
    return minetest.set_node(pos, {name = "air"})
  end
end
local gas_levels = 255
local function _1_(gas)
  heavy_3f[gas.name] = gas.heavy
  local _2_
  if gas.transparent then
    _2_ = "airlike"
  else
    _2_ = "glasslike"
  end
  minetest.register_node(("default:" .. gas.name), {buildable_to = true, damage_per_second = gas.damage, description = gas.name, drawtype = _2_, drop = {}, groups = {gas = 1, not_in_creative_inventory = 1}, light_source = (gas.light_source or 0), palette = gas.palette, paramtype = "light", paramtype2 = "color", pointable = false, post_effect_color = gas.post_effect_color, sunlight_propagates = true, tiles = {("default_gas.png^[opacity:" .. (gas.alpha or 128))}, use_texture_alpha = true, walkable = false})
  local function _4_(...)
    return process_gas(gas, ...)
  end
  minetest.register_abm({action = _4_, chance = 2, interval = 1, nodenames = {("default:" .. gas.name)}})
  if not gas.no_balloon then
    local function _5_(itemstack, user, pointed_thing)
      if (pointed_thing.type == "node") then
        local wear = (65535 - itemstack:get_wear())
        local value = math.ceil((wear * (128 / 65535)))
        minetest.add_node(pointed_thing.above, {name = ("default:" .. gas.name), param2 = (127 + value)})
        return {name = "default:empty_balloon"}
      end
    end
    return minetest.register_tool(("default:" .. gas.name .. "_balloon"), {description = (capitalization(gas.name) .. " balloon"), inventory_image = ("default_empty_balloon.png^[combine:16x16:0,0=" .. gas.icon), on_use = _5_, stack_max = 1})
  end
end
register_gas = _1_
local attack_radius = 30
local attack_step = 10
local function _2_(name, gas)
  local player = minetest.get_player_by_name(name)
  if player then
    local pos = player:get_pos()
    for x = (pos.x - attack_radius), (pos.x + attack_radius), attack_step do
      for z = (pos.z - attack_radius), (pos.z + attack_radius), attack_step do
        minetest.set_node({x = x, y = pos.y, z = z}, {name = ("default:" .. gas), param2 = gas_levels})
      end
    end
    return minetest.chat_send_player(name, "Done")
  end
end
minetest.register_chatcommand("chemical_attack", {description = "Sends gas", func = _2_, params = "<gas>", privs = {}})
local fill_radius = 10
local function _3_(name, nodename)
  local player = minetest.get_player_by_name(name)
  if (nodename and player) then
    local pos = player:get_pos()
    for x = (pos.x - fill_radius), (pos.x + fill_radius) do
      for z = (pos.z - fill_radius), (pos.z + fill_radius) do
        minetest.set_node({x = x, y = (pos.y - 1), z = z}, {name = nodename})
      end
    end
    return minetest.chat_send_player(name, "Done")
  end
end
minetest.register_chatcommand("fill", {description = string.format("Fill %d\194\160\195\151 %d square", fill_radius, fill_radius), func = _3_, params = "<nodename>", privs = {}})
local function _4_(name, node)
  return minetest.chat_send_player(name, tostring(minetest.get_content_id(node)))
end
minetest.register_chatcommand("cid", {description = "Returns content id.", func = _4_, params = "<node>", privs = {}})
local function _5_(pos)
  local pos_e2_80_b2 = vector.add(pos, vector.new(0, 1, 0))
  if (minetest.get_node(pos_e2_80_b2).name == "air") then
    return minetest.set_node(pos_e2_80_b2, {name = "default:chlorine", param2 = gas_levels})
  end
end
minetest.register_abm({action = _5_, chance = 1, interval = 1, label = "Chlorine source", nodenames = {"default:test"}})
local function _6_(pos)
  local vects = {vector.new(0, 1, 0), vector.new(1, 0, 0), vector.new(-1, 0, 0), vector.new(0, 0, 1), vector.new(0, 0, -1)}
  for _, vect in ipairs(vects) do
    local v = vector.add(pos, vect)
    if (minetest.get_node(v).name == "air") then
      minetest.set_node(v, {name = "default:oxygen", param2 = gas_levels})
    end
  end
  return nil
end
return minetest.register_abm({action = _6_, chance = 1, interval = 1, label = "Oxygen source", nodenames = {"default:infinite_oxygen"}})
