local function organic_3f(name)
  local function _0_(x)
    return starts_with(name, x)
  end
  return (find(_0_, {"default:pars", "default:truncus", "default:viriditas", "default:avarum", "default:rami", "default:spears", "default:naga", "default:petite"}) or ends_with(name, "_body") or small_mushrooms[name:sub((#"default:" + 1))])
end
local function heavy_organic_3f(name)
  return ends_with(name, "_stem")
end
local function fuel_3f(name)
  local function _0_(x)
    return starts_with(name, x)
  end
  return find(_0_, {"default:potassium", "default:trisilane"})
end
local chlorine = {damage = 2, destroys = organic_3f, heavy = true, icon = "default_chlorine_symbol.png", name = "chlorine", palette = "chlorine_palette.png", post_effect_color = {a = 50, b = 0, g = 255, r = 210}, reactions = {["default:glow_stick"] = {gas = "default:chlorine", result = "default:blowed_out_glow_stick"}, ["default:mercury"] = {result = "default:mercury_chloride"}, ["default:mercury_flowing"] = {result = "default:mercury_chloride"}, ["default:mercury_source"] = {result = "default:mercury_chloride"}}}
local oxygen = {damage = 0, destroys = const(false), icon = "default_oxygen_symbol.png", name = "oxygen", reactions = {["default:cinnabar"] = {gas = "default:sulfur_dioxide", result = "default:mercury"}, ["furnace:gas_active"] = {gas = "default:fire", result = "furnace:gas_active"}}, transparent = true}
local hydrogen = {damage = 0, destroys = const(false), icon = "default_hydrogen_symbol.png", name = "hydrogen", reactions = {["furnace:gas_active"] = {gas = "default:fire", result = "furnace:gas_active"}}, transparent = true}
local sulfur_dioxide = {damage = 1, destroys = const(false), heavy = true, icon = "default_sulfur_dioxide_symbol.png", name = "sulfur_dioxide", reactions = {}, transparent = true}
local fluorine = nil
local function _0_(name)
  return (organic_3f(name) or heavy_organic_3f(name))
end
fluorine = {damage = 5, destroys = _0_, heavy = true, icon = "default_fluorine_symbol.png", name = "fluorine", palette = "fluorine_palette.png", post_effect_color = {a = 50, b = 164, g = 251, r = 255}, reactions = {["default:glow_stick"] = {gas = "default:fluorine", result = "default:blowed_out_glow_stick"}, ["default:mercury_oxide"] = {gas = "default:oxygen", result = "default:mercury_fluoride"}, ["default:red_mercury_oxide"] = {gas = "default:oxygen", result = "default:mercury_fluoride"}}}
local fire = nil
local function _1_(name)
  return (organic_3f(name) or heavy_organic_3f(name) or fuel_3f(name))
end
fire = {alpha = 230, damage = 10, destroys = _1_, light_source = 14, name = "fire", no_balloon = true, palette = "fire_palette.png", post_effect_color = {a = 150, b = 255, g = 255, r = 255}}
fire.reactions = {["default:hydrogen"] = {gas = "default:fire", result = "default:fire"}, ["default:oxygen"] = {gas = "default:fire", result = "default:fire"}, ["default:trisilane_flowing"] = {gas = "default:fire", result = "default:fire"}, ["default:trisilane_source"] = {gas = "default:fire", result = "default:fire"}}
local evaporates = {"default:red_mercury_oxide", "default:mercury_oxide", "default:cinnabar", "default:copper_sulfate", "default:cobalt_blue", "default:ammonium_manganese_pyrophosphate"}
local air = {result = "air"}
for _, name in ipairs(evaporates) do
  fire.reactions[name] = air
end
for name, _ in pairs(ores) do
  fire.reactions[("default:" .. name)] = air
  fire.reactions[("default:" .. name .. "_cinnabar")] = air
  fire.reactions[("default:" .. name .. "_azure")] = air
end
return foreach(register_gas, {chlorine, oxygen, hydrogen, sulfur_dioxide, fluorine, fire})
